/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp;

import com.squareup.okhttp.Connection;
import com.squareup.okhttp.Dispatcher;
import com.squareup.okhttp.Failure;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.internal.Util;
import com.squareup.okhttp.internal.http.HttpAuthenticator;
import com.squareup.okhttp.internal.http.HttpEngine;
import com.squareup.okhttp.internal.http.HttpsEngine;
import com.squareup.okhttp.internal.http.Policy;
import com.squareup.okhttp.internal.http.RawHeaders;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.URL;

final class Job
implements Runnable,
Policy {
    private final Dispatcher dispatcher;
    private final OkHttpClient client;
    private final Response.Receiver responseReceiver;
    private Request request;

    public Job(Dispatcher dispatcher, OkHttpClient client, Request request, Response.Receiver responseReceiver) {
        this.dispatcher = dispatcher;
        this.client = client;
        this.request = request;
        this.responseReceiver = responseReceiver;
    }

    @Override
    public int getChunkLength() {
        return this.request.body().contentLength() == -1L ? 1024 : -1;
    }

    @Override
    public long getFixedContentLength() {
        return this.request.body().contentLength();
    }

    @Override
    public boolean getUseCaches() {
        return false;
    }

    @Override
    public HttpURLConnection getHttpConnectionToCache() {
        return null;
    }

    @Override
    public URL getURL() {
        return this.request.url();
    }

    @Override
    public long getIfModifiedSince() {
        return 0L;
    }

    @Override
    public boolean usingProxy() {
        return false;
    }

    @Override
    public void setSelectedProxy(Proxy proxy) {
    }

    Object tag() {
        return this.request.tag();
    }

    @Override
    public void run() {
        try {
            try {
                Response response = this.execute();
                this.responseReceiver.onResponse(response);
            }
            catch (IOException e) {
                this.responseReceiver.onFailure(new Failure.Builder().request(this.request).exception(e).build());
                this.dispatcher.finished(this);
            }
        }
        finally {
            this.dispatcher.finished(this);
        }
    }

    private Response execute() throws IOException {
        Connection connection = null;
        Response redirectedBy = null;
        while (true) {
            HttpEngine engine = this.newEngine(connection);
            Request.Body body = this.request.body();
            if (body != null) {
                MediaType contentType = body.contentType();
                if (contentType == null) {
                    throw new IllegalStateException("contentType == null");
                }
                if (engine.getRequestHeaders().getContentType() == null) {
                    engine.getRequestHeaders().setContentType(contentType.toString());
                }
            }
            engine.sendRequest();
            if (body != null) {
                body.writeTo(engine.getRequestBody());
            }
            engine.readResponse();
            int responseCode = engine.getResponseCode();
            Dispatcher.RealResponseBody responseBody = new Dispatcher.RealResponseBody(engine.getResponseHeaders(), engine.getResponseBody());
            Response response = new Response.Builder(this.request, responseCode).rawHeaders(engine.getResponseHeaders().getHeaders()).body(responseBody).redirectedBy(redirectedBy).build();
            Request redirect = this.processResponse(engine, response);
            if (redirect == null) {
                engine.automaticallyReleaseConnectionToPool();
                return response;
            }
            connection = this.sameConnection(this.request, redirect) ? engine.getConnection() : null;
            redirectedBy = response;
            this.request = redirect;
        }
    }

    HttpEngine newEngine(Connection connection) throws IOException {
        String protocol = this.request.url().getProtocol();
        RawHeaders requestHeaders = this.request.rawHeaders();
        if (protocol.equals("http")) {
            return new HttpEngine(this.client, this, this.request.method(), requestHeaders, connection, null);
        }
        if (protocol.equals("https")) {
            return new HttpsEngine(this.client, this, this.request.method(), requestHeaders, connection, null);
        }
        throw new AssertionError();
    }

    private Request processResponse(HttpEngine engine, Response response) throws IOException {
        Request request = response.request();
        Proxy selectedProxy = engine.getConnection() != null ? engine.getConnection().getRoute().getProxy() : this.client.getProxy();
        int responseCode = response.code();
        switch (responseCode) {
            case 407: {
                if (selectedProxy.type() != Proxy.Type.HTTP) {
                    throw new ProtocolException("Received HTTP_PROXY_AUTH (407) code while not using proxy");
                }
            }
            case 401: {
                RawHeaders successorRequestHeaders = request.rawHeaders();
                boolean credentialsFound = HttpAuthenticator.processAuthHeader(this.client.getAuthenticator(), response.code(), response.rawHeaders(), successorRequestHeaders, selectedProxy, this.request.url());
                return credentialsFound ? request.newBuilder().rawHeaders(successorRequestHeaders).build() : null;
            }
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 307: {
                String method = request.method();
                if (responseCode == 307 && !method.equals("GET") && !method.equals("HEAD")) {
                    return null;
                }
                String location = response.header("Location");
                if (location == null) {
                    return null;
                }
                URL url = new URL(request.url(), location);
                if (!url.getProtocol().equals("https") && !url.getProtocol().equals("http")) {
                    return null;
                }
                return this.request.newBuilder().url(url).build();
            }
        }
        return null;
    }

    private boolean sameConnection(Request a, Request b) {
        return a.url().getHost().equals(b.url().getHost()) && Util.getEffectivePort(a.url()) == Util.getEffectivePort(b.url()) && a.url().getProtocol().equals(b.url().getProtocol());
    }
}

