/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal;

import com.squareup.okhttp.internal.Util;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public class StrictLineReader
implements Closeable {
    private static final byte CR = 13;
    private static final byte LF = 10;
    private final InputStream in;
    private final Charset charset;
    private byte[] buf;
    private int pos;
    private int end;

    public StrictLineReader(InputStream in, Charset charset) {
        this(in, 8192, charset);
    }

    public StrictLineReader(InputStream in, int capacity, Charset charset) {
        if (in == null || charset == null) {
            throw new NullPointerException();
        }
        if (capacity < 0) {
            throw new IllegalArgumentException("capacity <= 0");
        }
        if (!charset.equals(Util.US_ASCII)) {
            throw new IllegalArgumentException("Unsupported encoding");
        }
        this.in = in;
        this.charset = charset;
        this.buf = new byte[capacity];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        InputStream inputStream = this.in;
        synchronized (inputStream) {
            if (this.buf != null) {
                this.buf = null;
                this.in.close();
            }
        }
    }

    public String readLine() throws IOException {
        InputStream inputStream = this.in;
        synchronized (inputStream) {
            if (this.buf == null) {
                throw new IOException("LineReader is closed");
            }
            if (this.pos >= this.end) {
                this.fillBuf();
            }
            int i = this.pos;
            while (i != this.end) {
                if (this.buf[i] == 10) {
                    int lineEnd = i != this.pos && this.buf[i - 1] == 13 ? i - 1 : i;
                    String res = new String(this.buf, this.pos, lineEnd - this.pos, this.charset.name());
                    this.pos = i + 1;
                    return res;
                }
                ++i;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream(this.end - this.pos + 80){

                @Override
                public String toString() {
                    int length = this.count > 0 && this.buf[this.count - 1] == 13 ? this.count - 1 : this.count;
                    try {
                        return new String(this.buf, 0, length, StrictLineReader.this.charset.name());
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new AssertionError((Object)e);
                    }
                }
            };
            block4: while (true) {
                out.write(this.buf, this.pos, this.end - this.pos);
                this.end = -1;
                this.fillBuf();
                int i2 = this.pos;
                while (true) {
                    if (i2 == this.end) continue block4;
                    if (this.buf[i2] == 10) {
                        if (i2 != this.pos) {
                            out.write(this.buf, this.pos, i2 - this.pos);
                        }
                        this.pos = i2 + 1;
                        return out.toString();
                    }
                    ++i2;
                }
                break;
            }
        }
    }

    public int readInt() throws IOException {
        String intString = this.readLine();
        try {
            return Integer.parseInt(intString);
        }
        catch (NumberFormatException e) {
            throw new IOException("expected an int but was \"" + intString + "\"");
        }
    }

    private void fillBuf() throws IOException {
        int result = this.in.read(this.buf, 0, this.buf.length);
        if (result == -1) {
            throw new EOFException();
        }
        this.pos = 0;
        this.end = result;
    }
}

