#MySQL
# This script will drop all the tables in your MySQL River's End database
# and recreate them. This is useful if your database gets corrupted or 
# you isssue a faulty SQL command.

drop table if exists re_type;
drop table if exists re_publisher;
drop table if exists re_title;
drop table if exists re_author;
drop table if exists re_author_title;
drop table if exists re_customer;
drop table if exists re_orders;
drop table if exists re_order_detail;
 

create table re_type
( type     varchar(15)    not null  primary key
)type=InnoDB;


INSERT INTO re_type
VALUES ('Travel');

INSERT INTO re_type
VALUES ('Fantasy');

INSERT INTO re_type
VALUES ('Programming');

INSERT INTO re_type
VALUES ('Children');

INSERT INTO re_type
VALUES ('Cooking');

INSERT INTO re_type
VALUES ('Art');

INSERT INTO re_type
VALUES ('Gothic');

INSERT INTO re_type
VALUES ('Horror');

INSERT INTO re_type
VALUES ('Mystery');

INSERT INTO re_type
VALUES ('Non Fiction');

INSERT INTO re_type
VALUES ('Romance');

INSERT INTO re_type
VALUES ('Science Fiction');


create table re_publisher 
( pub_id     smallint      not null      primary key,
  name       varchar(35)   not null,
  address    varchar(30),
  city       varchar(20),
  state      char(2),
  zip        varchar(10),
  contact    varchar(20)
)type=InnoDB;


INSERT INTO re_publisher VALUES
(1, 'Prentice Hall', '345 Pine',
    'Englewood Cliffs', 'NJ', '07632', NULL);

INSERT INTO re_publisher VALUES
(2, 'Atheneum Books', '1230 Avenue of the Americas', 
     'New York', 'NY', '10020', 'Debbie Johnson');

INSERT INTO re_publisher VALUES
(3, 'Galahad Books', '386 Park Avenue South', 
       'New York', 'NY', '10016', 'Kim Richards');

INSERT INTO re_publisher VALUES
(4, 'Greenwillow Books', '67 Park Avenue West', 
      'New York', 'NY', '10016', 'Fred');

INSERT INTO re_publisher VALUES
(5, 'Henry Holt and Company', '115 West 18th Street', 
      'New York', 'NY', '10111', 'John Wagner');

INSERT INTO re_publisher VALUES
(6, 'Sunset Books', '299 First Street', 
      'Menlo Park', 'CA', '98745', 'Jim Smith');

INSERT INTO re_publisher VALUES
(7, 'Thomas Nelson Publishers', '2 Nelson Lane', 
      'Nashville', 'TN', '75693', 'Tom');

INSERT INTO re_publisher VALUES
(8, 'Arkham House Publishers', 'P.O. Box 546', 
      'Sauk City', 'WI', '53583', 'August D');

INSERT INTO re_publisher VALUES
(9, 'Berkley Publisher Group', '1289 2nd Street', 
       'New York', 'NY', '10247', 'John');

INSERT INTO re_publisher VALUES
(10, 'Del Rey', '258 Broadway', 
       'New York', 'NY', '10023', NULL);

INSERT INTO re_publisher VALUES
(11, 'Tor Fantasy', '2789 First Ave.', 
        'San Francisco', 'CA', '95687', 'John J');

INSERT INTO re_publisher VALUES
(12, 'Viking Press', '234 Broadway', 
        'New York', 'NY', '10054', NULL);

INSERT INTO re_publisher VALUES
(13, 'Prime Crime', '1 Mystery Lane', 
        'Sleepy Hollow', 'NY', '11203', 'Laura');

INSERT INTO re_publisher VALUES
(14, 'Fawcett Books', '509 Wall Street', 
        'New York', 'NY', '10187', 'Mary');

INSERT INTO re_publisher VALUES
(15, 'Harper Torch', '499 Loop Ave.', 
        'Chicago', 'IL', '69875', 'Skippy');

INSERT INTO re_publisher VALUES
(16, 'Thomson Learning', 'One Learning Drive', 
         'Boston', 'MA', '02210', 'Jennifer');


create table re_title
( isbn          char(10)      not null   primary key,
  title         varchar(70)   not null,
  pub_id        smallint      references re_publisher(pub_id),
  type          varchar(15)	references re_type(type),
  qoh           smallint,
  actual_cost   numeric(6,2),
  retail_price  numeric(6,2)
)type=InnoDB;
 
 

INSERT INTO re_title VALUES
('0131103628', 'The C Programming Language', 
 1, 'Programming', 6, 30.00, 39.95);

INSERT INTO re_title VALUES
('0140296301', 'Aunt Dimity''s Christmas', 
 12, 'Mystery', 4, 4.00, 5.95);
                              
INSERT INTO re_title VALUES
('0345345991', 'Crewel Lye', 
 10, 'Fantasy', 4, 4.00, 7.50);

INSERT INTO re_title VALUES
('0345453751', 'The Sword of Shannara Trilogy', 
 10, 'Fantasy', 10, 12.00, 24.95);

INSERT INTO re_title VALUES
('0345470389', 'On the Night of the Seventh Moon', 
 14, 'Romance', 1, 5.00, 6.95);

INSERT INTO re_title VALUES
('0376050187', 'Back Roads and Hidden Places', 
 6, 'Travel', 2, 10.00, 12.50);

INSERT INTO re_title VALUES
('0380820749', 'The Ivy Tree', 
 15, 'Gothic', 4, 4.00, 6.99);

INSERT INTO re_title VALUES
('0380820765', 'Nine Coaches Waiting', 
 15, 'Gothic', 6, 4.00, 5.99);

INSERT INTO re_title VALUES
('0385006009', 'The Legend of the Seventh Virgin', 
 14, 'Romance', 5, 10.00, 15.98);

INSERT INTO re_title VALUES
('0425140989', 'Thyme of Death', 
 9, 'Mystery', 4, 3.50, 6.95);

INSERT INTO re_title VALUES
('0425144062', 'Witches'' Bane', 
 9, 'Mystery', 5, 3.50, 6.95);

INSERT INTO re_title VALUES
('042519129X', 'The English Breakfast Murder', 
 13, 'Mystery', 4, 4.25, 6.95);

INSERT INTO re_title VALUES
('0425193993', 'A Dilly of a Death', 
 9, 'Mystery', 2, 9.00, 16.95);

INSERT INTO re_title VALUES
('0425198138', 'The Jasmine Moon Murder', 
 13, 'Mystery', 7, 10.00, 16.95);

INSERT INTO re_title VALUES
('0445406518', 'Crocodile on the Sandbank', 
 3, 'Mystery', 10, 4.00, 6.75);

INSERT INTO re_title VALUES
('0446363383', 'The Last Camel Died at Noon', 
 3, 'Mystery', 4, 4.00, 6.75);

INSERT INTO re_title VALUES
('0449214222', 'A Walk in Wolf Wood', 
 15, 'Gothic', 7, 10.00, 14.95);

INSERT INTO re_title VALUES
('0449242463', 'Snowfire', 
 14, 'Romance', 8, 5.00, 7.50);

INSERT INTO re_title VALUES
('0619016620', 'Programming with Visual Basic .Net', 
 16, 'Programming', 5, 15.00, 26.00);

INSERT INTO re_title VALUES
('0670032786', 'Aunt Dimity Snowbound', 
 12, 'Mystery', 10, 4.00, 5.95);

INSERT INTO re_title VALUES
('0688010377', 'Airs Above the Ground', 
 15, 'Gothic', 2, 5.00, 7.95);

INSERT INTO re_title VALUES
('0688092101', 'Brrr!', 
 4, 'Children', 4, 4.00, 5.25);

INSERT INTO re_title VALUES
('0689318960', 'A City Under the Sea', 
 2, 'Children', 10, 4.00, 4.95);

INSERT INTO re_title VALUES
('0785269606', 'A Village Christmas', 
 7, 'Art', 23, 21.00, 24.95);

INSERT INTO re_title VALUES
('0805015825', 'Winter Wheat', 
 5, 'Children', 0, 3.50, 5.95);

INSERT INTO re_title VALUES
('0812574990', 'Up in a Heaval', 
 11, 'Fantasy', 9, 5.00, 7.50);

INSERT INTO re_title VALUES
('0870541757', 'Dragonfly', 
 8, 'Fantasy', 8, 12.00, 22.75);

INSERT INTO re_title VALUES
('0870541781', 'In The Stone House', 
 8, 'Science Fiction', 2, 20.00, 32.50);

INSERT INTO re_title VALUES
('0870541811', 'The Cleansing', 
 8, 'Horror', 7, 27.00, 32.50);

INSERT INTO re_title VALUES
('1878252186', 'Shadows over Innsmouth', 
 8, 'Horror', 20, 27.00, 29.95);

INSERT INTO re_title VALUES
('1878252402', 'Whispers in the Night', 
 8, 'Horror', 2, 30.00, 34.50);





create table re_author
( author_id     smallint    not null  primary key,
  last_name     varchar(20) not null,
  first_name    varchar(15),
  full_name     varchar(35)
)type=InnoDB;

INSERT INTO re_author
VALUES (1, 'King', 'Stephen', 'Stephen King');

INSERT INTO re_author
VALUES (2, 'Ritchie', 'Dennis', 'Dennis Ritchie');

INSERT INTO re_author
VALUES (3, 'Wu', 'Norbert', 'Norbert Wu');

INSERT INTO re_author
VALUES (4, 'Peters', 'Elizabeth', 'Elizabeth Peters');

INSERT INTO re_author
VALUES (5, 'Stevenson', 'James', 'James Stevenson');

INSERT INTO re_author
VALUES (6, 'Kinkade', 'Thomas', 'Thomas Kinkade');

INSERT INTO re_author
VALUES (7, 'Guiberson', 'Brenda', 'Brenda Guiberson');

INSERT INTO re_author
VALUES (8, 'Braasch', 'Barbara', 'Barbara Braasch');

INSERT INTO re_author
VALUES (9, 'Cooper', 'Basil', 'Basil Cooper');

INSERT INTO re_author
VALUES (10, 'Campbell', 'Ramsey', 'Ramsey Campbell');

INSERT INTO re_author
VALUES (11, 'Harvey', 'John', 'John Harvey');

INSERT INTO re_author
VALUES (12, 'Anthony', 'Piers', 'Piers Anthony');

INSERT INTO re_author
VALUES (13, 'Brooks', 'Terry', 'Terry Brooks');

INSERT INTO re_author
VALUES (14, 'Albert', 'Susan', 'Susan Albert');

INSERT INTO re_author
VALUES (15, 'Malzberg', 'Barry', 'Barry Malzberg');

INSERT INTO re_author
VALUES (16, 'Durbin', 'Federic', 'Federic Durbin');

INSERT INTO re_author
VALUES (17, 'Atherton', 'Nancy', 'Nancy Atherton');

INSERT INTO re_author
VALUES (18, 'Childs', 'Laura', 'Laura Childs');

INSERT INTO re_author
VALUES (19, 'Stewart', 'Mary', 'Mary Stewart');

INSERT INTO re_author
VALUES (20, 'Whitney', 'Phyllis', 'Phyllis Whitney');

INSERT INTO re_author
VALUES (21, 'Holt', 'Victoria', 'Victoria Holt');

INSERT INTO re_author
VALUES (22, 'Zak', 'Diane', 'Diane Zak');


create table re_author_title 
( author_id       smallint          not null references re_author(author_id),
  isbn            char(10)          not null references re_title(isbn),
  sequence        tinyint,
 primary key (author_id, isbn)
)type=InnoDB;

INSERT INTO re_author_title 
VALUES (2, '0131103628', 1);

INSERT INTO re_author_title 
VALUES (3, '0689318960', 1);

INSERT INTO re_author_title 
VALUES (4, '0445406518', 1);

INSERT INTO re_author_title 
VALUES (4, '0446363383', 1);

INSERT INTO re_author_title 
VALUES (5, '0688092101', 1);

INSERT INTO re_author_title 
VALUES (6, '0785269606', 1);

INSERT INTO re_author_title 
VALUES (7, '0805015825', 1);

INSERT INTO re_author_title 
VALUES (8, '0376050187', 1);

INSERT INTO re_author_title 
VALUES (9, '1878252402', 1);

INSERT INTO re_author_title 
VALUES (10, '1878252186', 1);

INSERT INTO re_author_title 
VALUES (11, '0870541811', 1);

INSERT INTO re_author_title 
VALUES (12, '0345345991', 1);

INSERT INTO re_author_title 
VALUES (12, '0812574990', 1);

INSERT INTO re_author_title 
VALUES (13, '0345453751', 1);

INSERT INTO re_author_title 
VALUES (14, '0425140989', 1);

INSERT INTO re_author_title 
VALUES (14, '0425144062', 1);

INSERT INTO re_author_title 
VALUES (14, '0425193993', 1);

INSERT INTO re_author_title 
VALUES (15, '0870541781', 1);

INSERT INTO re_author_title 
VALUES (16, '0870541757', 1);

INSERT INTO re_author_title 
VALUES (17, '0140296301', 1);

INSERT INTO re_author_title 
VALUES (17, '0670032786', 1);

INSERT INTO re_author_title 
VALUES (18, '042519129X', 1);

INSERT INTO re_author_title 
VALUES (18, '0425198138', 1);

INSERT INTO re_author_title 
VALUES (19, '0380820749', 1);

INSERT INTO re_author_title 
VALUES (19, '0380820765', 1);

INSERT INTO re_author_title 
VALUES (19, '0449214222', 1);

INSERT INTO re_author_title 
VALUES (19, '0688010377', 1);

INSERT INTO re_author_title 
VALUES (20, '0449242463', 1);

INSERT INTO re_author_title 
VALUES (21, '0345470389', 1);

INSERT INTO re_author_title 
VALUES (21, '0385006009', 1);

INSERT INTO re_author_title 
VALUES (22, '0619016620', 1);

create table re_customer 
( cust_id        smallint     not null      primary key,
  last_name      varchar(20)  not null,
  first_name     varchar(15)  not null,
  address        varchar(30),
  city           varchar(20),
  state          char(2),
  zip            varchar(10),
  phone          char(12),
  email	        varchar(35),
  reader_club    char(3),
  card_num	     varchar(16),
  card_exp       varchar(5),
  card_type      varchar(10),
  full_name      varchar(35)
)type=InnoDB;



INSERT INTO re_customer VALUES
(1, 'Richardson', 'John', '1524 Center Dr.', 'La Mesa', 'CA', '91945', '619-358-6578',
'jrich@cox.net', 'No', '4224369865742591', '03/07', 'Visa', 'John Richardson');

INSERT INTO re_customer VALUES
(2, 'Lolan', 'Bobbi', '122 Elysian Fields', 'New Orleans', 'LA', '73401', '704-987-6421',
'blolan@no.rr.net', 'Yes', '5623326598754128', '02/05', 'MasterCard', 'Bobbi Lolan');

INSERT INTO re_customer VALUES
(4, 'Smith', 'Tim', '12597 1st Ave.', 'Chula Vista', 'CA', '92174', '619-658-8794',
'tsmith@sbcglobal.net', 'No', '6598234568710954', '04/06', 'Discover', 'Tim Smith');

INSERT INTO re_customer VALUES
(5, 'Edwards', 'Mitch', '19872 Pine Court', 'Kansas City', 'MO', '69877', '648-987-0938',
'mitch@earthnet.com', 'No', '3700448756697455', '10/04', 'Amex', 'Mitch Edwards');

INSERT INTO re_customer VALUES
(6, 'Brown', 'Edward', '14598 Poway Road', 'Poway', 'CA', '92064', '858-486-6897',
'ebrown@hobo.net', 'No', '5236698756824712', '09/05', 'MasterCard', 'Edward Brown');

INSERT INTO re_customer VALUES
(7, 'Rowland', 'Mike', '32657 Jasmine Place', 'Park City', 'UT', '86987', '236-568-9874',
'roland@hotmail.com', 'Yes', '4225639856875214', '12/04', 'Visa', 'Mike Rowland');

INSERT INTO re_customer VALUES
(8, 'Perkins', 'Anthony', '235 Circle Dr.', 'La Mesa', 'CA', '91942', '247-986-3274',
'psycho@bates.com', 'Yes', '5668213659875897', '12/05', 'MasterCard', 'Anthony Perkins');

INSERT INTO re_customer VALUES
(9, 'Jones', 'Ralph', '2 Shady Lane', 'Chula Vista', 'CA', '92105', '254-987-2327',
'shady@nightmare.com', 'Yes', '6987986215476387', '01/07', 'Discover', 'Ralph Jones');

create table re_orders 
( order_id      smallint      not null   primary key,
  order_date    date,
  cust_id       smallint      references re_customer(cust_id),
  card_num	    varchar(16),
  card_exp      varchar(5),
  card_type     varchar(10)
)type=InnoDB;
 
INSERT INTO re_orders VALUES
(1, '2003/09/10', 1, '4224369869563521', '07/07', 'Visa');

INSERT INTO re_orders VALUES
(2, '2003/10/10', 2, '3772983612873476', '06/05', 'Amex');

INSERT INTO re_orders VALUES
(3, '2003/12/17', 2, '3772983612873476', '06/05', 'Amex');

INSERT INTO re_orders VALUES
(4, '2004/01/12', 1, '4224369869563521', '07/07', 'Visa');

INSERT INTO re_orders VALUES
(5, '2004/01/24', 4, '6987326528742587', '02/06', 'Discover');

INSERT INTO re_orders VALUES
(6, '2004/02/29', 5, '5365879658752414', '03/08', 'MasterCard');

INSERT INTO re_orders VALUES
(7, '2004/03/02', 6, '5224369865214785', '01/06', 'MasterCard');

INSERT INTO re_orders VALUES
(8, '2004/03/10', 6, '5224369865214785', '01/06', 'MasterCard');

INSERT INTO re_orders VALUES
(9, '2004/04/23', 2, '3772983612873476', '06/05', 'Amex');

INSERT INTO re_orders VALUES
(10, '2004/05/14', 5, '5365879658752414', '03/08', 'MasterCard');

INSERT INTO re_orders VALUES
(11, '2004/05/14', 4, '6987326528742587', '02/06', 'Discover');

INSERT INTO re_orders VALUES
(12, '2004/05/20', 1, '4224369869563521', '07/07', 'Visa');


create table re_order_detail 
( order_id    smallint        not null references re_orders(order_id),
  isbn        char(10)        not null references re_title(isbn),
  qty         smallint,
  price       numeric(6,2),
  primary key (order_id, isbn)
)type=InnoDB;


INSERT INTO re_order_detail  VALUES
(1, '0870541811', 1, 32.50);

INSERT INTO re_order_detail  VALUES
(1, '0870541781', 1, 32.50);

INSERT INTO re_order_detail  VALUES
(2, '0449242463', 1, 6.75);

INSERT INTO re_order_detail  VALUES
(3, '0425198138', 2, 15.26);

INSERT INTO re_order_detail  VALUES
(3, '0380820765', 1, 5.39);

INSERT INTO re_order_detail  VALUES
(4, '0140296301', 1, 5.95);

INSERT INTO re_order_detail  VALUES
(5, '0345470389', 1, 5.56);

INSERT INTO re_order_detail  VALUES
(6, '0345345991', 3, 7.13);

INSERT INTO re_order_detail  VALUES
(6, '0345453751', 1, 23.70);

INSERT INTO re_order_detail  VALUES
(7, '0688010377', 1, 7.95);

INSERT INTO re_order_detail  VALUES
(8, '0670032786', 2, 5.95);

INSERT INTO re_order_detail  VALUES
(8, '0812574990', 1, 7.50);

INSERT INTO re_order_detail  VALUES
(9, '0131103628', 1, 35.96);

INSERT INTO re_order_detail  VALUES
(9, '0619016620', 1, 23.40);

INSERT INTO re_order_detail  VALUES
(10, '1878252402', 1, 32.78);

INSERT INTO re_order_detail  VALUES
(11, '0785269606', 1, 19.96);

INSERT INTO re_order_detail  VALUES
(12, '0449214222', 1, 14.95);

INSERT INTO re_order_detail VALUES
(12, '0688010377', 2, 7.95);
