var collapse_container;
var collapse_content;
var cta;
var expand_container;
var expand_content;
var bgExit;
var closeExit;
var isRetina;
var newOrientation;
var cta, arrow, copy, exitTrigger;	


window.onload = function(){
	if (Enabler.isInitialized()) {
		enablerInitHandler();
	}else{
		Enabler.addEventListener(studio.events.StudioEvent.INIT, enablerInitHandler);
	}
};	


enablerInitHandler = function(e) {	
	if(Enabler.isVisible()) {
		startAd();
	} else {
		Enabler.addEventListener(studio.events.StudioEvent.VISIBLE, startAd);
	} 
};


startAd = function(e) {		
	collapse_container = document.getElementById('collapse_container_dc');
	collapse_content = document.getElementById('collapse_content_dc');	
	expand_container = document.getElementById('expand_container_dc');
	expand_content = document.getElementById('expand_content_dc');	
	bgExit = document.getElementById('background_exit_dc');
	cta = document.getElementById('cta');
	arrow = document.getElementById('arrow');
	copy = document.getElementById('copy');
	exitTrigger = document.getElementById('exitTrigger');
	ctaMain = document.getElementById('ctaMain');
		
	addListeners();
	buildAd();
	
	collapse_container.style.display = "block";
	expand_container.style.display = "none";
};

//Add Event Listeners
addListeners = function(e) {
	
	exitTrigger.addEventListener('touchend', function(e){
		triggerExit();		
		e.stopPropagation();
		e.preventDefault();
	},false);
	exitTrigger.addEventListener('click', triggerExit, false);
	
	collapse_container.addEventListener('touchend', function(e){
		Enabler.requestExpand();		
		e.stopPropagation();
		e.preventDefault();
	},false);
	collapse_container.addEventListener('click', expandAd, false);
	
	ctaMain.addEventListener('touchend', function(e){
		fireMainExit();		
		e.stopPropagation();
		e.preventDefault();
	},false);
	ctaMain.addEventListener('click', fireMainExit, false);

	
	Enabler.addEventListener(studio.events.StudioEvent.EXPAND_START, expandHandler);
	Enabler.addEventListener(studio.events.StudioEvent.COLLAPSE_START, collapseHandler);
};

triggerExit = function(){
	Enabler.exit("backgroundExit");
	Enabler.requestCollapse();
}

buildAd = function(){
	setTimeout( function(){ cta.className = "in" }, 300);
	setTimeout( function(){ copy.className = "in" }, 600);
	
	setTimeout( function(){ arrow.className = "" }, 800);
	setTimeout( function(){ arrow.className = "in" }, 1100);
	
	setTimeout( ctaAnimation, 5100);
	setTimeout( ctaAnimation, 9100);
	setTimeout( ctaAnimation, 12800);		
}

ctaAnimation = function(){
	setTimeout( function(){ arrow.className = "off" }, 0);
	setTimeout( function(){ arrow.className = "" }, 200);
	setTimeout( function(){ arrow.className = "in" }, 400);
}


expandAd = function(e) {	
	Enabler.requestExpand();
	e.preventDefault();
};


collapseHandler = function () {
	expand_container.style.display = "none";
	collapse_container.style.display = "block";
	collapse_container.style.top = "0px";
	collapse_container.style.left = "0px";
	Enabler.finishCollapse();
}

//For Expansion
expandHandler = function () {
	console.log("== EXPAND ==");
	collapse_container.style.display = "none";
	expand_container.style.display = "block";
	Enabler.finishExpand();
}



function fireMainExit(e){
	Enabler.exit("ctaExit");
	Enabler.requestCollapse();
}
	
