/*
jquery.percentageloader.js 
 
Copyright (c) 2012, Better2Web
All rights reserved.

This jQuery plugin is licensed under the Simplified BSD License. Please
see the file license.txt that was included with the plugin bundle.

*/

/*global jQuery */

(function ($) {
    /* Strict mode for this plugin */
    "use strict";
    /*jslint browser: true */

    /* Our spiral gradient data */
    var imgdata = "data:image/jpeg;base64,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",
        gradient = new Image();
    gradient.src = imgdata;

    /** Percentage loader
     * @param	params	Specify options in {}. May be on of width, height, progress or value.
     *
     * @example $("#myloader-container).percentageLoader({
		    width : 256,  // width in pixels
		    height : 256, // height in pixels
		    progress: 0,  // initialise progress bar position, within the range [0..1]
		    value: '0kb'  // initialise text label to this value
		});
     */
    $.fn.percentageLoader = function (params) {
        var settings, canvas, percentageText, valueText, items, i, item, selectors, s, ctx, progress,
            value, cX, cY, lingrad, innerGrad, tubeGrad, innerRadius, innerBarRadius, outerBarRadius,
            radius, startAngle, endAngle, counterClockwise, completeAngle, setProgress, setValue,
            applyAngle, drawLoader, clipValue, outerDiv;

        /* Specify default settings */
        settings = {
            width: 441,
            height: 441,
            progress: 0,
            value: '0kb',
            controllable: false
        };

        /* Override default settings with provided params, if any */
        if (params !== undefined) {
            $.extend(settings, params);
        } else {
            params = settings;
        }

        outerDiv = document.createElement('div');
        outerDiv.style.width = settings.width + 'px';
        outerDiv.style.height = settings.height + 'px';
        outerDiv.style.position = 'relative';

        $(this).append(outerDiv);

        /* Create our canvas object */
        canvas = document.createElement('canvas');
        canvas.setAttribute('width', settings.width);
        canvas.setAttribute('height', settings.height);
        outerDiv.appendChild(canvas);

        /* Create div elements we'll use for text. Drawing text is
         * possible with canvas but it is tricky working with custom
         * fonts as it is hard to guarantee when they become available
         * with differences between browsers. DOM is a safer bet here */
        percentageText = document.createElement('div');
        percentageText.style.width = (settings.width.toString() - 2) + 'px';
        percentageText.style.textAlign = 'center';
        percentageText.style.height = '50px';
        percentageText.style.left = 0;
        percentageText.style.position = 'absolute';

        valueText = document.createElement('div');
        valueText.style.width = (settings.width - 2).toString() + 'px';
        valueText.style.textAlign = 'center';
        valueText.style.height = '0px';
        valueText.style.overflow = 'hidden';
        valueText.style.left = 0;
        valueText.style.position = 'absolute';

        /* Force text items to not allow selection */
        items = [valueText, percentageText];
        for (i  = 0; i < items.length; i += 1) {
            item = items[i];
            selectors = [
                '-webkit-user-select',
                '-khtml-user-select',
                '-moz-user-select',
                '-o-user-select',
                'user-select'];

            for (s = 0; s < selectors.length; s += 1) {
                $(item).css(selectors[s], 'none');
            }
        }

        /* Add the new dom elements to the containing div */
        outerDiv.appendChild(percentageText);
        //outerDiv.appendChild(valueText);

        /* Get a reference to the context of our canvas object */
        ctx = canvas.getContext("2d");


        /* Set various initial values */

        /* Centre point */
        cX = (canvas.width / 2) - 1;
        cY = (canvas.height / 2) - 1;

        /* Create our linear gradient for the outer ring */
        lingrad = ctx.createLinearGradient(cX, 0, cX, canvas.height);
        lingrad.addColorStop(0, '#232323');
        lingrad.addColorStop(1, '#232323');

        /* Create inner gradient for the outer ring */
        innerGrad = ctx.createLinearGradient(cX, cX * 0.133333, cX, canvas.height - cX * 0.133333);
        innerGrad.addColorStop(0, '#2e2e2e');
        innerGrad.addColorStop(1, '#2e2e2e');

        /* Tube gradient (background, not the spiral gradient) */
        tubeGrad = ctx.createLinearGradient(cX, 0, cX, canvas.height);
        tubeGrad.addColorStop(0, '#232323');
        tubeGrad.addColorStop(1, '#232323');

        /* The inner circle is 2/3rds the size of the outer one */
        innerRadius = cX * 0.7566;
        /* Outer radius is the same as the width / 2, same as the centre x
        * (but we leave a little room so the borders aren't truncated) */
        radius = cX - 23;

        /* Calculate the radii of the inner tube */
        innerBarRadius = innerRadius + (cX * 0.07);
        outerBarRadius = radius - (cX * 0.07);

        /* Bottom left angle */
        startAngle = 4.6707963267949;
        /* Bottom right angle */
        endAngle = 0.9707963267949 + (Math.PI * 2.558);

        /* Nicer to pass counterClockwise / clockwise into canvas functions
        * than true / false */
        counterClockwise = false;

        /* Borders should be 1px */
        ctx.lineWidth = 1;

        /**
         * Little helper method for transforming points on a given
         * angle and distance for code clarity
         */
        applyAngle = function (point, angle, distance) {
            return {
                x : point.x + (Math.cos(angle) * distance),
                y : point.y + (Math.sin(angle) * distance)
            };
        };


        /**
         * render the widget in its entirety.
         */
        drawLoader = function () {
            /* Clear canvas entirely */
            ctx.clearRect(0, 0, canvas.width, canvas.height);

            /*** IMAGERY ***/

            /* draw outer circle */
            ctx.fillStyle = lingrad;
            ctx.beginPath();
            ctx.strokeStyle = '#2b2b2b';
            ctx.arc(cX, cY, radius, 0, Math.PI * 2, counterClockwise);
            ctx.fill();
            ctx.stroke();

            /* draw inner circle */
            ctx.fillStyle = innerGrad;
            ctx.beginPath();
            ctx.arc(cX, cY, innerRadius, 0, Math.PI * 2, counterClockwise);
            ctx.fill();
            ctx.strokeStyle = '#2b2b2b';
            ctx.stroke();

            ctx.beginPath();

            /**
             * Helper function - adds a path (without calls to beginPath or closePath)
             * to the context which describes the inner tube. We use this for drawing
             * the background of the inner tube (which is always at 100%) and the
             * progress meter itself, which may vary from 0-100% */
            function makeInnerTubePath(startAngle, endAngle) {
                var centrePoint, startPoint, controlAngle, capLength, c1, c2, point1, point2;
                centrePoint = {
                    x : cX,
                    y : cY
                };

                startPoint = applyAngle(centrePoint, startAngle, innerBarRadius);

                ctx.moveTo(startPoint.x, startPoint.y);

                point1 = applyAngle(centrePoint, endAngle, innerBarRadius);
                point2 = applyAngle(centrePoint, endAngle, outerBarRadius);

                controlAngle = endAngle + (3.142 / 2.0);
                /* Cap length - a fifth of the canvas size minus 4 pixels */
                capLength = (cX * 0.30) - 38;

                c1 = applyAngle(point1, controlAngle, capLength);
                c2 = applyAngle(point2, controlAngle, capLength);

                ctx.arc(cX, cY, innerBarRadius, startAngle, endAngle, false);
                ctx.bezierCurveTo(c1.x, c1.y, c2.x, c2.y, point2.x, point2.y);
                ctx.arc(cX, cY, outerBarRadius, endAngle, startAngle, true);

                point1 = applyAngle(centrePoint, startAngle, innerBarRadius);
                point2 = applyAngle(centrePoint, startAngle, outerBarRadius);

                controlAngle = startAngle - (3.145 / 2.0);

                c1 = applyAngle(point2, controlAngle, capLength);
                c2 = applyAngle(point1, controlAngle, capLength);

                ctx.bezierCurveTo(c1.x, c1.y, c2.x, c2.y, point1.x, point1.y);
            }

            /* Background tube */
            ctx.beginPath();
            ctx.strokeStyle = '#232323';
            makeInnerTubePath(startAngle, endAngle);

            ctx.fillStyle = tubeGrad;
            ctx.fill();
            ctx.stroke();

            /* Calculate angles for the the progress metre */
            completeAngle = startAngle + (progress * (endAngle - startAngle));

            ctx.beginPath();
            makeInnerTubePath(startAngle, completeAngle);

            /* We're going to apply a clip so save the current state */
            ctx.save();
            /* Clip so we can apply the image gradient */
            ctx.clip();

            /* Draw the spiral gradient over the clipped area */
            ctx.drawImage(gradient, 0, 0, canvas.width, canvas.height);

            /* Undo the clip */
            ctx.restore();

            /* Draw the outline of the path */
            ctx.beginPath();
            makeInnerTubePath(startAngle, completeAngle);
            ctx.stroke();

            /*** TEXT ***/
            (function () {
                var fontSize, string, smallSize, heightRemaining;
                /* Calculate the size of the font based on the canvas size */
                fontSize = cX / 1.5;

                percentageText.style.top = ((settings.height / 2.5) - (fontSize / 2)).toString() + 'px';
                percentageText.style.color = '#ffffff';
                percentageText.style.font = fontSize.toString() + 'px bebas_neueregular';
                percentageText.style.textShadow = '0 1px 1px #FFFFFF';

                /* Calculate the text for the given percentage */
                string = (progress * 1280.0).toFixed(0)/* + '%'*/;

                percentageText.innerHTML = string;

                /* Calculate font and placement of small 'value' text */
                smallSize = cX / 6;
                valueText.style.color = '#ffffff';
                valueText.style.font = smallSize.toString() + 'px bebas_neueregular';
                valueText.style.height = smallSize.toString() + 'px';
                valueText.style.textShadow = 'None';

                /* Ugly vertical align calculations - fit into bottom ring.
                 * The bottom ring occupes 1/6 of the diameter of the circle */
                heightRemaining = (settings.height * 0.16666666) - smallSize;
                valueText.style.top = ((settings.height * 0.8333333) + (heightRemaining / 4)).toString() + 'px';
            }());
        };

        /**
        * Check the progress value and ensure it is within the correct bounds [0..1]
        */
        clipValue = function () {
            if (progress < 0) {
                progress = 0;
            }

            if (progress > 1.0) {
                progress = 1.0;
            }
        };

        /* Sets the current progress level of the loader
         *
         * @param value the progress value, from 0 to 1. Values outside this range
         * will be clipped
         */
        setProgress = function (value) {
            /* Clip values to the range [0..1] */
            progress = value;
            clipValue();
            drawLoader();
        };

        this.setProgress = setProgress;

        setValue = function (val) {
            value = val;
            valueText.innerHTML = value;
        };

        this.setValue = setValue;
        this.setValue(settings.value);

        progress = settings.progress;
        clipValue();

        /* Do an initial draw */
        drawLoader();

        /* In controllable mode, add event handlers */
        if (params.controllable === true) {
            (function () {
                var mouseDown, getDistance, adjustProgressWithXY;
                getDistance = function (x, y) {
                    return Math.sqrt(Math.pow(x - cX, 2) + Math.pow(y - cY, 2));
                };

                mouseDown = false;

                adjustProgressWithXY = function (x, y) {
                    /* within the bar, calculate angle of touch point */
                    var pX, pY, angle, startTouchAngle, range, posValue;
                    pX = x - cX;
                    pY = y - cY;

                    angle = Math.atan2(pY, pX);
                    if (angle > Math.PI / 2.0) {
                        angle -= (Math.PI * 2.0);
                    }

                    startTouchAngle = startAngle - (Math.PI * 2.0);
                    range = endAngle - startAngle;
                    posValue = (angle - startTouchAngle) / range;
                    setProgress(posValue);

                    if (params.onProgressUpdate) {
                        /* use the progress value as this will have been clipped
                         * to the correct range [0..1] after the call to setProgress
                         */
                        params.onProgressUpdate(progress);
                    }
                };

                $(outerDiv).mousedown(function (e) {
                    var offset, x, y, distance;
                    offset = $(this).offset();
                    x = e.pageX - offset.left;
                    y = e.pageY - offset.top;

                    distance = getDistance(x, y);

                    if (distance > innerRadius && distance < radius) {
                        mouseDown = true;
                        adjustProgressWithXY(x, y);
                    }
                }).mouseup(function () {
                    mouseDown = false;
                }).mousemove(function (e) {
                    var offset, x, y;
                    if (mouseDown) {
                        offset = $(outerDiv).offset();
                        x = e.pageX - offset.left;
                        y = e.pageY - offset.top;
                        adjustProgressWithXY(x, y);
                    }
                }).mouseleave(function () {
                    mouseDown = false;
                });
            }());
        }
        return this;
    };
}(jQuery));
