///////////////////////////////////////////////////////////////////////////////
// serviceListPage.js
// This script has specific functions used by the serviceListPage.html.
///////////////////////////////////////////////////////////////////////////////

//
// OnLoad callback method for the page.
//
function pageOnLoad() {
  var autoId = sessionStorage.getItem(gSelectedAutoIdKey);
  
  getServiceRecordsByAutoId(autoId, dbServiceCallback);
}

//
// Called after a successfull DB query action.
//
function dbServiceCallback(objArray) {
  console.log("serviceLen3: " + objArray.length);

  for (var i = 0; i < objArray.length; i++) {
    var serviceObj = objArray[i];
    console.log("service: " + serviceObj);
    addService(serviceObj);
  }
}

//
// Add the specified service record to the list.
//
function addService(serviceObj) {
  var serviceTable = document.getElementById("carServiceTable");
  var idx = Number(serviceTable.rows.length);
        
  var row = serviceTable.insertRow(idx);
  row.className = "table-tr-service";

  var cellArray = [
    serviceObj.serviceDate,
    serviceObj.serviceType,
    serviceObj.cost,
    serviceObj.notes
  ];

  // Add each row cell at a time.  
  for ( var i = 0; i < cellArray.length; i++) {
    var rowCell = row.insertCell(i);
    
    rowCell.innerHTML = cellArray[i];
    rowCell.className = "table-td-service";
  }  
}

//
// On click handler for the Back link.
//
function onClickBack() {
  console.log("onClickBack()");
  
  // Open the auto list page.
  window.location.href = "autoListPage.html";
}

//
// On Click handler for the Add link.
// 
function onClickAddService() {
  console.log("onCickAddService()");
  
  // Open the auto info page.
  window.location.href = "addServicePage.html";
}

