$(document).ready(function(){


// Search Results of API
function locationLookup() {
	var searchResult = $(".search").val();
	var wuAPIconditions = $.getJSON("http://api.wunderground.com/api/b7800ee8e2896a04/conditions/q/CA/"+searchResult+".json");
	var wuAPIforecast10day = $.getJSON("http://api.wunderground.com/api/b7800ee8e2896a04/forecast10day/q/CA/"+searchResult+".json");
	

	//Get multiple json requests using $.when
	$.when(wuAPIconditions, wuAPIforecast10day).done(function(data1, data2) {

		//Conditional Error: Check if search result returned undefined
		if (data1[0].current_observation == undefined) {
			$(".warning").fadeIn(400);
		} else {

		var city = data1[0].current_observation.display_location.city;
		var state = data1[0].current_observation.display_location.state;
		var location = city+", "+state;

		var weather = data1[0].current_observation.weather;
		var currentTempF = data1[0].current_observation.temp_f;
		var currentLowF = data2[0].forecast.simpleforecast.forecastday[0].low.fahrenheit;
		var currentHighF = data2[0].forecast.simpleforecast.forecastday[0].high.fahrenheit;
		var currentPrec = data1[0].current_observation.precip_today_in;
		var currentHumi = data1[0].current_observation.relative_humidity.slice(0,-1);
		var currentWind = data1[0].current_observation.wind_mph;
		var currentPres = data1[0].current_observation.pressure_in;

		var forecastday = data2[0].forecast.simpleforecast.forecastday.slice(1, 7);

		$(".current .weather").text(weather);
		$(".current .temp-value").text(Math.round(currentTempF));
		$(".current .low-high .low-temp").text(Math.round(currentLowF));
		$(".current .low-high .high-temp").text(Math.round(currentHighF));
		$(".conditions .prec-value").text(Math.round(currentPrec));
		$(".conditions .humi-value").text(Math.round(currentHumi));
		$(".conditions .wind-value").text(Math.round(currentWind));
		$(".conditions .pres-value").text(Math.round(currentPres));


		//Update weather icon for current condition
		var iconURL = data1[0].current_observation.icon_url;
		var icon = iconURL.replace("http://icons.wxug.com/i/c/k/", "").slice(0,-4);
			

		//Object literal used to store default icon names and provide custom values
		var objIcon = {
			chanceflurries: "wi-day-snow-wind", 
			chancerain: "wi-day-rain", 
			chancesleet: "wi-day-sleet", 
			chancesnow: "wi-day-snow", 
			chancetstorms: "wi-day-thunderstorm", 
			clear: "wi-day-sunny", 
			cloudy: "wi-day-cloudy", 
			flurries: "wi-day-snow-wind", 
			fog: "wi-day-fog", 
			hazy: "wi-day-haze", 
			mostlycloudy: "wi-day-cloudy", 
			mostlysunny: "wi-day-cloudy", 
			partlycloudy: "wi-day-cloudy", 
			partlysunny: "wi-day-cloudy", 
			sleet: "wi-day-sleet", 
			rain: "wi-day-rain", 
			snow: "wi-day-snow", 
			sunny: "wi-day-sunny", 
			tstorms: "wi-day-thunderstorm", 
			cloudy: "wi-cloudy", 
			nt_chanceflurries: "wi-night-snow-wind", 
			nt_chancerain: "wi-night-rain", 
			nt_chancesleet: "wi-night-sleet", 
			nt_chancesnow: "wi-night-snow-wind", 
			nt_chancetstorms: "wi-night-thunderstorm", 
			nt_clear: "wi-night-clear", 
			nt_cloudy: "wi-night-cloudy", 
			nt_flurries: "wi-night-snow-wind", 
			nt_fog: "wi-night-fog", 
			nt_hazy: "wi-night-fog", 
			nt_mostlycloudy: "wi-night-cloudy", 
			nt_mostlysunny: "wi-night-cloudy", 
			nt_partlycloudy: "wi-night-partly-cloudy", 
			nt_partlysunny: "wi-night-cloudy", 
			nt_sleet: "wi-night-sleet", 
			nt_rain: "wi-night-showers", 
			nt_snow: "wi-night-snow", 
			nt_sunny: "wi-night-clear", 
			nt_tstorms: "wi-night-thunderstorm"
		}


		//Access object while pulling variable name as [property name]
		
		//Remove extra classes that begin with wi- (https://gist.github.com/imcmahon/4335d05967f54bb6d14e)
		$('.current .wi, .forecast .wi').removeClass(function (index, css) {
			return (css.match (/\bwi-\S+/g) || []).join('');
		});
		
		$(".current .wi").addClass(objIcon[icon]);

		
		//Loop through JSON for weather forecast

			//Loop through 6 days and apply css when period matches
			for (var i = 0; i < forecastday.length; i++) {
				var forecastdayDay = forecastday[i].date.weekday_short;
				var period = forecastday[i].period;
				iconURL = forecastday[i].icon_url;
				icon = iconURL.replace("http://icons.wxug.com/i/c/k/", "").slice(0,-4);
				var forecastLowF = data2[0].forecast.simpleforecast.forecastday[i].low.fahrenheit;
				var forecastHighF = data2[0].forecast.simpleforecast.forecastday[i].high.fahrenheit;

				switch (period) {
					case 2:
					$(".per-1 .day-value").text(forecastdayDay);
					$(".per-1 .wi").addClass(objIcon[icon]);
					$(".per-1 .low-temp").text(forecastLowF);
					$(".per-1 .high-temp").text(forecastHighF);
					break;
					case 3:
					$(".per-2 .day-value").text(forecastdayDay);
					$(".per-2 .wi").addClass(objIcon[icon]);
					$(".per-2 .low-temp").text(forecastLowF);
					$(".per-2 .high-temp").text(forecastHighF);
					break;
					case 4:
					$(".per-3 .day-value").text(forecastdayDay);
					$(".per-3 .wi").addClass(objIcon[icon]);
					$(".per-3 .low-temp").text(forecastLowF);
					$(".per-3 .high-temp").text(forecastHighF);
					break;
					case 5:
					$(".per-4 .day-value").text(forecastdayDay);
					$(".per-4 .wi").addClass(objIcon[icon]);
					$(".per-4 .low-temp").text(forecastLowF);
					$(".per-4 .high-temp").text(forecastHighF);
					break;
					case 6:
					$(".per-5 .day-value").text(forecastdayDay);
					$(".per-5 .wi").addClass(objIcon[icon]);
					$(".per-5 .low-temp").text(forecastLowF);
					$(".per-5 .high-temp").text(forecastHighF);
					break;
					case 7:
					$(".per-6 .day-value").text(forecastdayDay);
					$(".per-6 .wi").addClass(objIcon[icon]);
					$(".per-6 .low-temp").text(forecastLowF);
					$(".per-6 .high-temp").text(forecastHighF);
					break;
					default:
					break;
					//Do nothing
				}
			}


		//Reset input field after submit
		$(".search").val('');


		//Change placeholder value to current city searched
		$(".search").attr('placeholder', location);


		//If search resulted in success, fade in weather block, fade out warnings
		if ($(".all-weather").is(":hidden")) {
			fadeInWeather();
		} 
		if ($(".warning").is(":visible")) {
			$(".warning").fadeOut(400);
		}
		if ($(".connection").is(":visible")) {
			$(".connection").fadeOut(400);
		} 


	}//End Conditional Error

	//Show error message when json is not available
	}).fail(function(){
		$(".connection").fadeIn(400);
	});// JSON data call

	
} //End locationLookup();


//Fade in results after submit
function fadeInWeather() {
	$(".all-weather").css({"display":"block","opacity":"0"}).animate({
		bottom: "0",
		opacity: "1"
	},700);
}

// Submit Search Request on Enter Keypress
$(".search").on('keypress', function(e) {
	if(e.which == 13) {
		locationLookup();
	}
});

// Submit Search Request on Button Click
$(".search-btn").on('click', function() {
	locationLookup();
});




});