///////////////////////////////////////////////////////////////////////////////
// autoInfoModel.js
// This script has functions aware of auto info model.
///////////////////////////////////////////////////////////////////////////////

//
// Define AutoModel object.
//
function AutoModel () {
  this.autoId = 0;
  this.alias = "";
  this.make = "";
  this.model = "";
  this.year = "";
  this.userId = "";
}

//
// Define local variables.
//
var lgPageCallback = null;
var lgAutoArray = [];
var lgAutoId = 0;

//
// Delete auto
//
function deleteAuto(autoId, pageCallback) {
  console.log("deleteAuto(): " + autoId);
  
  lgPageCallback = pageCallback;
  lgAutoId = autoId;

  deleteRecord(TBL_AUTOINFO, "AutoId", autoId, deleteCallback);
}

//
// Callback for the delete auto command, so now delete the service records for the auto.
//
function deleteCallback() {
  console.log("deleteCallback()");
  
  if (lgPageCallback != null)
    deleteRecord(TBL_SERVICERECORD, "AutoId", lgAutoId, lgPageCallback);
}

//
// Add a new auto
//
function addAuto(autoObj, addCallbackFunc) {
  var insertSpec = "(AliasName, MakeName, ModelName, AutoYear, UserId) values('" +
                    autoObj.alias + "', '" +
                    autoObj.make + "', '" +
                    autoObj.model + "', '" +
                    autoObj.year + "', '" +
                    autoObj.userId + "')";
  insertRecord(TBL_AUTOINFO, insertSpec, addCallbackFunc);
}

//
// Update the auto info.
//
function updateAuto(autoObj, updateCallbackFunc) {
  // At this time the only thing we allow to change is the Alias name.
  var updateSpec = "set AliasName = '" + autoObj.alias + "'";
  var condition = "AutoId = '" + autoObj.autoId + "'";
  
  updateRecord(TBL_AUTOINFO, updateSpec, condition, updateCallbackFunc);
}

//
// Query call back function for the AutoInfo table.
//
function autoInfoResultCallback(tx, result) {
  console.log("Query result is: " + result.rows.length);

  // Clear the auto array.
  while(lgAutoArray.length > 0) {
    lgAutoArray.pop();
  }
            
  for (var i = 0; i < result.rows.length; i++) {
    var dbRow = result.rows.item(i);
    var autoObj = new AutoModel();

    console.log(dbRow);

    // Map the DB entity to the model.
    autoObj.autoId = dbRow.AutoId;
    autoObj.alias = dbRow.AliasName;
    autoObj.make = dbRow.MakeName;
    autoObj.model = dbRow.ModelName;
    autoObj.year = dbRow.AutoYear;
    autoObj.userId = dbRow.UserId;
    console.log(autoObj);
    
    // Add the auto to the array.    
    lgAutoArray.push(autoObj);
    console.log("autosLen: " + lgAutoArray.length);
  }
}

//
// On DB query success handler.
//
function autoInfoSuccessCallback() {
  console.log("autosLen2: " + lgAutoArray.length);
  
  if (lgPageCallback != null)
    lgPageCallback(lgAutoArray);
}

//
// On DB query success handler.
//
function autoInfoSuccessCallbackSingle() {
  console.log("autosLen2b: " + lgAutoArray.length);

  //
  // make sure there is one record retrieved from the DB.
  //
  if (lgAutoArray != null && lgAutoArray.length == 1 && lgPageCallback != null)
    return lgPageCallback(lgAutoArray[0]);
}

//
// Return all autos in the DB.
//
function getAutosByUserId(userId, pageCallback) {
  var condition = "UserId = '" + userId + "'";

  lgPageCallback = pageCallback;
  
  selectRecords(TBL_AUTOINFO, condition, autoInfoSuccessCallback, autoInfoResultCallback);
}

//
// Return the specified auto.
//
function getAutoById(autoId, pageCallback) {
  var condition = "AutoId = '" + autoId + "'";
  
  lgPageCallback = pageCallback;
  
  selectRecords(TBL_AUTOINFO, condition, autoInfoSuccessCallbackSingle, autoInfoResultCallback);
}
