///////////////////////////////////////////////////////////////////////////////
// serviceRecordModel.js
// This script has functions aware of auto service record model.
///////////////////////////////////////////////////////////////////////////////

//
// Define ServiceModel object.
//
function ServiceModel () {
  this.serviceId = 0;
  this.autoId = 0;
  this.serviceDate = "";
  this.serviceType = "";
  this.notes = "";
  this.cost = 0.0;
}

//
// Define local variables.
//
var lgServicePageCallback = null;
var lgServiceRecordArray = [];

//
// Add a new service record
//
function addService(serviceObj, addCallbackFunc) {
  var insertSpec = "(AutoId, ServiceDate, ServiceType, Notes, Cost) values('" +
                    serviceObj.autoId + "', '" +
                    serviceObj.serviceDate + "', '" +
                    serviceObj.serviceType + "', '" +
                    serviceObj.notes + "', '" +
                    serviceObj.cost + "')";
  insertRecord(TBL_SERVICERECORD, insertSpec, addCallbackFunc);
}

//
// Query call back function for the AutoInfo table.
//
function serviceResultCallback(tx, result) {
  console.log("Query result is: " + result.rows.length);

  // Clear the service record array.
  while(lgServiceRecordArray.length > 0) {
    lgServiceRecordArray.pop();
  }
            
  for (var i = 0; i < result.rows.length; i++) {
    var dbRow = result.rows.item(i);
    var serviceObj = new ServiceModel();

    console.log(dbRow);

    // Map the DB entity to the model.
    serviceObj.serviceId = dbRow.ServiceId; 
    serviceObj.autoId = dbRow.AutoId;
    serviceObj.serviceDate = dbRow.ServiceDate;
    serviceObj.serviceType = dbRow.ServiceType;
    serviceObj.notes = dbRow.Notes;
    serviceObj.cost = dbRow.Cost;
    console.log(serviceObj);
    
    // Add the service record to the array.    
    lgServiceRecordArray.push(serviceObj);
    console.log("serviceLen: " + lgServiceRecordArray.length);
  }
}

//
// On DB query success handler.  Call the caller's callback function.
//
function serviceSuccessCallback() {
  console.log("serviceLen2: " + lgServiceRecordArray.length);
  
  if (lgServicePageCallback != null)
    lgServicePageCallback(lgServiceRecordArray);
}

//
// Query all service records in the DB for the specified auto.
//
function getServiceRecordsByAutoId(autoId, pageCallback) {
  var condition = "AutoId = '" + autoId + "'";

  lgServicePageCallback = pageCallback;
  
  selectRecords(TBL_SERVICERECORD, condition, serviceSuccessCallback, serviceResultCallback);
}
