﻿///////////////////////////////////////////////////////////////////////////////
// formValidation.js
// This script has functions used to validate user input.
///////////////////////////////////////////////////////////////////////////////

//
// A method to show the validation error.
//
function showValidationError(area, focusOnArea, errMsg) {
  var errElement = document.getElementById(area + "err");
  var testElement = document.getElementById(area);
  var hasMsg = errMsg.length > 0 ? true : false;

  errElement.style.color = '#ff0000';

  if (hasMsg == true) {
    errElement.innerHTML = '  * ' + errMsg;
  } else {
    errElement.innerHTML = errMsg;
  }

  if (focusOnArea == true) {
    testElement.focus();
  }
}

//
// General input validation method for string values.
//
function validateInput(area, patternStr, expectedFormat) {
  //
  // A way to handle unspecified parameters to set default value.
  // http://stackoverflow.com/questions/894860/set-a-default-parameter-value-for-a-javascript-function
  //
  patternStr = typeof patternStr !== 'undefined' ? patternStr : '';
  expectedFormat = typeof expectedFormat !== 'undefined' ? expectedFormat : '';

  var areaVal = getElementValue(area);
  var labelVal = getElementHTML(area + "label");

  // Remove the ':' from the end of the label.
  labelVal = (labelVal.length > 1) ? labelVal.substring(0, labelVal.length - 1) : labelVal;
  
  //
  // If the value is empty, then issue a validation error msg.
  //
  if (areaVal.length < 1) {
    showValidationError(area, true, "Must provide a value for " + labelVal);
    return false;
  }
  //
  // If the input pattern is specified, make sure the value matches the specified pattern.
  //
  else if (patternStr.length > 0) {
    // check the value against the pattern.
    var matchval = areaVal.match(patternStr);
  
    // If no match, then issue the validation error msg.
    if (matchval == null) {
      showValidationError(area, true, "The value must be in this format '" + expectedFormat + "'");
      return false;
    }
  }
  
  // Clear the validation error msg.
  showValidationError(area, false, "");
  
  return true;
}

//
// Check email type input field.
//
function validateEmail(elementId) {
  return validateInput(elementId, '^[A-Za-z]+[A-Za-z0-9_.-]*@[A-Za-z0-9]+\.[A-Za-z]+', 'a@b.com');
}

//
// Check list type input field.
//
function validateList(elementId) {
  var listOption = document.getElementById(elementId).value;

  // Make sure an option is selected.
  if (listOption.length < 1) {
    showValidationError(elementId, true, "Must select at least one option.");
    return false;
  }

  // Clear the validation error msg.
  showValidationError(elementId, false, "");

  return true;
}
