///////////////////////////////////////////////////////////////////////////////
// addServicePage.js
// This script has functions specific to the addServicePage.html.
///////////////////////////////////////////////////////////////////////////////

//
// OnLoad callback method for the page.
//
function pageOnLoad() {
  document.getElementById("servicetype").focus();
}

//
// Validate the input fields.
//
function validateFields() {
  var isValid = true;

  isValid &= validateInput("servicetype");
  isValid &= validateInput("cost");

  return isValid;
}

//
// Callback handler when the add operation completes.
//
function addServicePageCallback() {
  console.log("addServicePageCallback()");
  
  // Open the service list page.
  window.location.href = "serviceListPage.html";
}

//
// Handle the Save button click event.
//
function onClickSave() {
  if (validateFields() == false)
    return false;

  // Build the service record model object.
  var serviceObj = new ServiceModel();
  var today = new Date();
  var dateStr = today.toISOString().substr(0,10);

  serviceObj.serviceType = getSelectElementOption("servicetype");
  serviceObj.cost = getElementValue("cost");
  serviceObj.notes = getElementValue("notes");
  serviceObj.autoId = sessionStorage.getItem(gSelectedAutoIdKey);
  serviceObj.serviceDate = dateStr;
  console.log("service Date: " + dateStr);
  
  // Add the service record to the database.
  addService(serviceObj, addServicePageCallback);
}

//
// Handle the Back button click event.
//
function onClickBack() {
  openYesNoPopupBox("Are you sure you want to revert and go back?", yesNoCallback);
}

// Callback handler used by the YesNo popup, providing the btn selection result.
function yesNoCallback(isYes) {  
  // Open the service list page.
  if (isYes == true)
    window.location.href = "serviceListPage.html";
}

