///////////////////////////////////////////////////////////////////////////////
// webSqlWrapper.js
// This script has functions wrapping the Web SQL functionality.
///////////////////////////////////////////////////////////////////////////////

var dbObj = null;

//
// Open Web SQL database.
//
function openDB(dbName, version) {
  var shortName = dbName;
  var versionNum = version;
  var displayName = dbName;
  var maxSize = 60000;

  // Open/Create the DB.
  console.log("Creating the DB object.");
  dbObj = openDatabase(shortName, versionNum, displayName, maxSize);
  console.log("Created the DB object.");
  
  return dbObj;
}

//
// Generic database SQL statement executer.
// This is where all the work is done.
// The successCallbackFunc is called when the Transaction is completed,
// and all DB operations will need it.
// The resultCallbackFunc is called on a SELECT operation to allow the caller
// to traverse. the query result.
// WebSQL statement execution always run in Async mode (hince the callbacks),
// But the statement execution is not "thread" safe.  It is important to know
// that a statement execution must first complete (success called) before doing
// something else with the DB.
// This was relevent in the implementation here, since the UI was not updated
// in these functions, but in the calling page's JS, and therefore the full use
// of the various callback functions.
//
function executeSqlStatement(sqlStmt, successCallbackFunc, resultCallbackFunc) {
  console.log(sqlStmt);

  if (dbObj == null)
    return false;

  console.log("db: " + dbObj);

  // If the callback function is defined, then use it, otherwise use the default.
  if (typeof resultCallbackFunc !== 'undefined' && resultCallbackFunc != null) {
    dbObj.transaction(
        function(tx) {
          tx.executeSql(sqlStmt, [], resultCallbackFunc, errorHandler);
        },
        errorHandler, successCallbackFunc);
  } else {
    dbObj.transaction(
        function(tx) {
          tx.executeSql(sqlStmt, [], nullHandler, errorHandler);
        },
        errorHandler, successCallbackFunc);
  }
  
  return true;
}

//
// Create table.
//
function createTable(tableSpec, createTableCallbackFunc) {
  var sqlStmt = 'create table if not exists ' + tableSpec;  

  return executeSqlStatement(sqlStmt, createTableCallbackFunc);  
}

//
// Delete a record
//
function deleteRecord(tableName, columnName, itemId, deleteCallbackFunc) {
  var sqlStmt = 'delete from ' + tableName + ' where ' + columnName + '=\'' + itemId + '\'';
    
  return executeSqlStatement(sqlStmt, deleteCallbackFunc);
}

//
// Insert a record
//
function insertRecord(tableName, insertSpec, insertCallbackFunc){
  var sqlStmt = 'insert into ' + tableName + ' ' + insertSpec;

  return executeSqlStatement(sqlStmt, insertCallbackFunc);  
}

//
// Update a record
//
function updateRecord(tableName, updateSpec, condition, updateCallbackFunc) {
  var sqlStmt = 'update ' + tableName + ' ' + updateSpec + ' where ' + condition;

  return executeSqlStatement(sqlStmt, updateCallbackFunc);  
}

//
// Query records
//
function selectRecords(tableName, condition, successCallbackFunc, resultCallbackFunc) {
  var sqlStmt = 'select * from ' + tableName + ' where ' + condition;

  return executeSqlStatement(sqlStmt, successCallbackFunc, resultCallbackFunc);  
}

//
// Database success handler.
//
function successCallBack() {
	console.log('Default DB Success callback');
  return true;
}

//
// Database error handler.
// 
function errorHandler(transaction, error) {
	console.log('DB Error: ' + error.message + 'Code: ' + error.code);
}

//
// Database Null handler.
//
function nullHandler() {
	console.log('Null handler');
}
