<?php

require '/Applications/MAMP/htdocs/stats/includes/models/Stats.php';


class StatsTest extends \PHPUnit_Framework_TestCase
{
	/**
     * @covers Stats::sluggify
     */



    protected $_stats = null;
    //set up method
    public function setUp()
    {
    $this->_stats = new Stats;
    }

    //tear down method
    public function tearDown()
    {
    unset($this->_stats);
    }

    public function testSluggifyReturnsSluggifiedString()
    {
        $originalString = 'This string will be sluggified';
        $expectedResult = 'this-string-will-be-sluggified';

        $url = new Stats;

        $result = $url->sluggify($originalString);

        $this->assertEquals($expectedResult, $result);
    }

    public function testSluggifyReturnsExpectedForStringsContainingNumbers()
    {
        $originalString = 'This1 string2 will3 be 44 sluggified10';
        $expectedResult = 'this1-string2-will3-be-44-sluggified10';

        $url = new Stats();

        $result = $url->sluggify($originalString);

        $this->assertEquals($expectedResult, $result);
    }

    public function testSluggifyReturnsExpectedForStringsContainingSpecialCharacters()
    {
        $originalString = 'This! @string#$ %$will ()be "sluggified';
        $expectedResult = 'this-string-will-be-sluggified';

        $url = new Stats();

        $result = $url->sluggify($originalString);

        $this->assertEquals($expectedResult, $result);
    }
//test entering tags in name
//test entering unlink in bio
//show provider annotation as we through several different options into the name and bio fields.
//test create method
//test connection 
    public function testSluggifyReturnsExpectedForStringsContainingNonEnglishCharacters()
    {
        $originalString = "Tänk efter nu – förr'n vi föser dig bort";
        $expectedResult = 'tank-efter-nu-forrn-vi-foser-dig-bort';

        $url = new Stats();

        $result = $url->sluggify($originalString);

        $this->assertEquals($expectedResult, $result);
    }

    public function testSluggifyReturnsExpectedForEmptyStrings()
    {
        $originalString = '';
        $expectedResult = '';

        $url = new Stats();

        $result = $url->sluggify($originalString);

        $this->assertEquals($expectedResult, $result);
    }
}
