 <?php
/*
CREATE TABLE `contacts` (
  `id` int(5) NOT NULL,
  `fullname` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `phone` varchar(255) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `contacts`
--

INSERT INTO `contacts` (`id`, `fullname`, `email`, `phone`) VALUES
(8, 'Johnny Rivera', 'jrivera@ue.co', '5551212'),
(9, 'Kris Secor', 'kdsecor@gmail.com', '6654546');

--
-- Indexes for dumped tables
--

--
-- Indexes for table `contacts`
--
ALTER TABLE `contacts`
  ADD PRIMARY KEY (`id`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `contacts`
--
ALTER TABLE `contacts`
  MODIFY `id` int(5) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=11;
COMMIT;
*/

class contactsCrud{
 private $host="localhost";
 private $user="root";
 private $db="test";
 private $pass="";
 private $conn;

 public function __construct(){

 $this->conn = new PDO("mysql:host=".$this->host.";dbname=".$this->db,$this->user,$this->pass);
 }

 public function showData($table){

 $sql="SELECT * FROM $table";
 $q = $this->conn->query($sql) or die("failed!");

 while($r = $q->fetch(PDO::FETCH_ASSOC)){
 $data[]=$r;
 }
 return $data;
 }

 public function getById($id,$table){

 $sql="SELECT * FROM $table WHERE id = :id";
 $q = $this->conn->prepare($sql);
 $q->execute(array(':id'=>$id));
 $data = $q->fetch(PDO::FETCH_ASSOC);
 return $data;
 }

 public function update($id,$name,$email,$phone,$table){

$sql = "UPDATE $table
 SET fullname=:name,email=:email,phone=:phone
 WHERE id=:id";
 $q = $this->conn->prepare($sql);
 $q->execute(array(':id'=>$id,':name'=>$name,
':email'=>$email,':phone'=>$phone));
 return true;

 }

 public function insertData($name,$email,$phone,$table){
 $sql = "INSERT INTO $table (fullname,email,phone) values (:name,:email,:phone)";
 $q = $this->conn->prepare($sql);
 $q->execute(array(':name'=>$name,':email'=>$email,
':phone'=>$phone));
 return true;
 }

 public function deleteData($id,$table){

 $sql="DELETE FROM $table WHERE id=:id";
 $q = $this->conn->prepare($sql);
 $q->execute(array(':id'=>$id));
 return true;
 }
}

?>
