// Exercise 1: Create a Class
class Person {
    constructor(name, age) {
        this.name = name;
        this.age = age;
    }

    describe() {
        console.log(`Name: ${this.name}, Age: ${this.age}`);
    }
}


https://www.w3schools.com/jsref/tryit.asp?filename=tryjsref_class_extends

const person1 = new Person("Alice", 30);
person1.describe();  // Output: Name: Alice, Age: 30

// Exercise 2: Inheritance
class Student extends Person {
    constructor(name, age, grade) {
        super(name, age);
        this.grade = grade;
    }

    study() {
        console.log(`${this.name} is studying.`);
    }
}

const student1 = new Student("Bob", 20, "A");
student1.describe();  // Output: Name: Bob, Age: 20
student1.study();     // Output: Bob is studying.

// Exercise 3: Getters and Setters
class PersonWithGetterSetter {
    constructor(name, age) {
        this.name = name;
        this._age = age;
    }

    get age() {
        return this._age;
    }

    set age(newAge) {
        if (newAge > 0) {
            this._age = newAge;
        } else {
            console.log("Age must be positive.");
        }
    }
}

const person2 = new PersonWithGetterSetter("Charlie", 25);
console.log(person2.age);  // Output: 25
person2.age = 30;  
console.log(person2.age);  // Output: 30
person2.age = -5;          // Output: Age must be positive.

// Exercise 4: Static Methods
class MathHelper {
    static add(a, b) {
        return a + b;
    }
}

console.log(MathHelper.add(5, 10));  // Output: 15

// Exercise 5: Encapsulation with Private Fields
class BankAccount {
    #balance;

    constructor(initialBalance) {
        this.#balance = initialBalance;
    }

    deposit(amount) {
        if (amount > 0) {
            this.#balance += amount;
            console.log(`Deposited: $${amount}. New Balance: $${this.#balance}`);
        } else {
            console.log("Deposit amount must be positive.");
        }
    }

    withdraw(amount) {
        if (amount > 0 && amount <= this.#balance) {
            this.#balance -= amount;
            console.log(`Withdrew: $${amount}. New Balance: $${this.#balance}`);
        } else {
            console.log("Invalid withdrawal amount.");
        }
    }

    getBalance() {
        return this.#balance;
    }
}

const account = new BankAccount(100);
account.deposit(50);    // Output: Deposited: $50. New Balance: $150
account.withdraw(30);   // Output: Withdrew: $30. New Balance: $120
console.log(account.getBalance());  // Output: 120
