/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.common.internal.o;
import com.google.android.gms.common.internal.p;
import com.google.android.gms.common.internal.q;
import com.google.android.gms.dynamic.g;

public final class SignInButton
extends FrameLayout
implements View.OnClickListener {
    public static final int SIZE_STANDARD = 0;
    public static final int SIZE_WIDE = 1;
    public static final int SIZE_ICON_ONLY = 2;
    public static final int COLOR_DARK = 0;
    public static final int COLOR_LIGHT = 1;
    private int mSize;
    private int mColor;
    private View Im;
    private View.OnClickListener In = null;

    public SignInButton(Context context) {
        this(context, null);
    }

    public SignInButton(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SignInButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setStyle(0, 0);
    }

    public void setSize(int buttonSize) {
        this.setStyle(buttonSize, this.mColor);
    }

    public void setColorScheme(int colorScheme) {
        this.setStyle(this.mSize, colorScheme);
    }

    public void setStyle(int buttonSize, int colorScheme) {
        o.a(buttonSize >= 0 && buttonSize < 3, "Unknown button size %d", buttonSize);
        o.a(colorScheme >= 0 && colorScheme < 2, "Unknown color scheme %s", colorScheme);
        this.mSize = buttonSize;
        this.mColor = colorScheme;
        this.G(this.getContext());
    }

    private void G(Context context) {
        if (this.Im != null) {
            this.removeView(this.Im);
        }
        try {
            this.Im = p.b(context, this.mSize, this.mColor);
        }
        catch (g.a a2) {
            Log.w((String)"SignInButton", (String)"Sign in button not found, using placeholder instead");
            this.Im = SignInButton.a(context, this.mSize, this.mColor);
        }
        this.addView(this.Im);
        this.Im.setEnabled(this.isEnabled());
        this.Im.setOnClickListener((View.OnClickListener)this);
    }

    private static Button a(Context context, int n2, int n3) {
        q q2 = new q(context);
        q2.a(context.getResources(), n2, n3);
        return q2;
    }

    public void setOnClickListener(View.OnClickListener listener) {
        this.In = listener;
        if (this.Im != null) {
            this.Im.setOnClickListener((View.OnClickListener)this);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.Im.setEnabled(enabled);
    }

    public void onClick(View view) {
        if (this.In != null && view == this.Im) {
            this.In.onClick((View)this);
        }
    }
}

