/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.database.CharArrayBuffer;
import android.database.CursorIndexOutOfBoundsException;
import android.database.CursorWindow;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.util.Log;
import com.google.android.gms.common.data.f;
import com.google.android.gms.common.internal.o;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class DataHolder
implements SafeParcelable {
    public static final f CREATOR = new f();
    private final int BR;
    private final String[] Kb;
    Bundle Kc;
    private final CursorWindow[] Kd;
    private final int HF;
    private final Bundle Ke;
    int[] Kf;
    int Kg;
    boolean mClosed = false;
    private Object Kh;
    private boolean Ki = true;
    private static final a Kj = new a(new String[0], null){};

    DataHolder(int versionCode, String[] columns, CursorWindow[] windows, int statusCode, Bundle metadata) {
        this.BR = versionCode;
        this.Kb = columns;
        this.Kd = windows;
        this.HF = statusCode;
        this.Ke = metadata;
    }

    public DataHolder(String[] columns, CursorWindow[] windows, int statusCode, Bundle metadata) {
        this.BR = 1;
        this.Kb = o.i(columns);
        this.Kd = o.i(windows);
        this.HF = statusCode;
        this.Ke = metadata;
        this.gA();
    }

    public void e(Object object) {
        this.Kh = object;
    }

    private DataHolder(a builder, int statusCode, Bundle metadata) {
        this(builder.Kb, DataHolder.a(builder, -1), statusCode, metadata);
    }

    public void gA() {
        int n2;
        this.Kc = new Bundle();
        for (n2 = 0; n2 < this.Kb.length; ++n2) {
            this.Kc.putInt(this.Kb[n2], n2);
        }
        this.Kf = new int[this.Kd.length];
        n2 = 0;
        for (int i2 = 0; i2 < this.Kd.length; ++i2) {
            this.Kf[i2] = n2;
            int n3 = this.Kd[i2].getStartPosition();
            int n4 = n2 - n3;
            n2 += this.Kd[i2].getNumRows() - n4;
        }
        this.Kg = n2;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        f.a(this, dest, flags);
    }

    int getVersionCode() {
        return this.BR;
    }

    String[] gB() {
        return this.Kb;
    }

    CursorWindow[] gC() {
        return this.Kd;
    }

    public int getStatusCode() {
        return this.HF;
    }

    public Bundle gy() {
        return this.Ke;
    }

    private static CursorWindow[] a(a a2, int n2) {
        if (a2.Kb.length == 0) {
            return new CursorWindow[0];
        }
        List list = n2 < 0 || n2 >= a2.Kk.size() ? a2.Kk : a2.Kk.subList(0, n2);
        int n3 = list.size();
        CursorWindow cursorWindow = new CursorWindow(false);
        ArrayList<CursorWindow> arrayList = new ArrayList<CursorWindow>();
        arrayList.add(cursorWindow);
        cursorWindow.setNumColumns(a2.Kb.length);
        try {
            int n4 = 0;
            for (int i2 = 0; i2 < n3; ++i2) {
                if (!cursorWindow.allocRow()) {
                    Log.d((String)"DataHolder", (String)("Allocating additional cursor window for large data set (row " + i2 + ")"));
                    cursorWindow = new CursorWindow(false);
                    cursorWindow.setStartPosition(i2);
                    cursorWindow.setNumColumns(a2.Kb.length);
                    arrayList.add(cursorWindow);
                    if (!cursorWindow.allocRow()) {
                        Log.e((String)"DataHolder", (String)"Unable to allocate row to hold data.");
                        arrayList.remove(cursorWindow);
                        return arrayList.toArray(new CursorWindow[arrayList.size()]);
                    }
                    n4 = 0;
                }
                Map map = (Map)list.get(i2);
                boolean bl2 = true;
                for (int i3 = 0; i3 < a2.Kb.length && bl2; ++i3) {
                    String string2 = a2.Kb[i3];
                    Object v2 = map.get(string2);
                    if (v2 == null) {
                        bl2 = cursorWindow.putNull(n4, i3);
                        continue;
                    }
                    if (v2 instanceof String) {
                        bl2 = cursorWindow.putString((String)v2, n4, i3);
                        continue;
                    }
                    if (v2 instanceof Long) {
                        bl2 = cursorWindow.putLong(((Long)v2).longValue(), n4, i3);
                        continue;
                    }
                    if (v2 instanceof Integer) {
                        bl2 = cursorWindow.putLong((long)((Integer)v2).intValue(), n4, i3);
                        continue;
                    }
                    if (v2 instanceof Boolean) {
                        boolean bl3 = (Boolean)v2;
                        bl2 = cursorWindow.putLong(bl3 ? 1L : 0L, n4, i3);
                        continue;
                    }
                    if (v2 instanceof byte[]) {
                        bl2 = cursorWindow.putBlob((byte[])v2, n4, i3);
                        continue;
                    }
                    if (v2 instanceof Double) {
                        bl2 = cursorWindow.putDouble(((Double)v2).doubleValue(), n4, i3);
                        continue;
                    }
                    if (v2 instanceof Float) {
                        bl2 = cursorWindow.putDouble((double)((Float)v2).floatValue(), n4, i3);
                        continue;
                    }
                    throw new IllegalArgumentException("Unsupported object for column " + string2 + ": " + v2);
                }
                if (!bl2) {
                    Log.d((String)"DataHolder", (String)("Couldn't populate window data for row " + i2 + " - allocating new window."));
                    cursorWindow.freeLastRow();
                    cursorWindow = new CursorWindow(false);
                    cursorWindow.setNumColumns(a2.Kb.length);
                    arrayList.add(cursorWindow);
                    n4 = 0;
                    --i2;
                    continue;
                }
                ++n4;
            }
        }
        catch (RuntimeException runtimeException) {
            int n5 = arrayList.size();
            for (int i4 = 0; i4 < n5; ++i4) {
                ((CursorWindow)arrayList.get(i4)).close();
            }
            throw runtimeException;
        }
        return arrayList.toArray(new CursorWindow[arrayList.size()]);
    }

    private void g(String string2, int n2) {
        if (this.Kc == null || !this.Kc.containsKey(string2)) {
            throw new IllegalArgumentException("No such column: " + string2);
        }
        if (this.isClosed()) {
            throw new IllegalArgumentException("Buffer is closed.");
        }
        if (n2 < 0 || n2 >= this.Kg) {
            throw new CursorIndexOutOfBoundsException(n2, this.Kg);
        }
    }

    public boolean aQ(String string2) {
        return this.Kc.containsKey(string2);
    }

    public long a(String string2, int n2, int n3) {
        this.g(string2, n2);
        return this.Kd[n3].getLong(n2, this.Kc.getInt(string2));
    }

    public int b(String string2, int n2, int n3) {
        this.g(string2, n2);
        return this.Kd[n3].getInt(n2, this.Kc.getInt(string2));
    }

    public String c(String string2, int n2, int n3) {
        this.g(string2, n2);
        return this.Kd[n3].getString(n2, this.Kc.getInt(string2));
    }

    public boolean d(String string2, int n2, int n3) {
        this.g(string2, n2);
        Long l2 = this.Kd[n3].getLong(n2, this.Kc.getInt(string2));
        return l2 == 1L;
    }

    public float e(String string2, int n2, int n3) {
        this.g(string2, n2);
        return this.Kd[n3].getFloat(n2, this.Kc.getInt(string2));
    }

    public byte[] f(String string2, int n2, int n3) {
        this.g(string2, n2);
        return this.Kd[n3].getBlob(n2, this.Kc.getInt(string2));
    }

    public Uri g(String string2, int n2, int n3) {
        String string3 = this.c(string2, n2, n3);
        return string3 == null ? null : Uri.parse((String)string3);
    }

    public void a(String string2, int n2, int n3, CharArrayBuffer charArrayBuffer) {
        this.g(string2, n2);
        this.Kd[n3].copyStringToBuffer(n2, this.Kc.getInt(string2), charArrayBuffer);
    }

    public boolean h(String string2, int n2, int n3) {
        this.g(string2, n2);
        return this.Kd[n3].isNull(n2, this.Kc.getInt(string2));
    }

    public int getCount() {
        return this.Kg;
    }

    public int ar(int n2) {
        int n3;
        o.I(n2 >= 0 && n2 < this.Kg);
        for (n3 = 0; n3 < this.Kf.length; ++n3) {
            if (n2 >= this.Kf[n3]) continue;
            --n3;
            break;
        }
        if (n3 == this.Kf.length) {
            --n3;
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        DataHolder dataHolder = this;
        synchronized (dataHolder) {
            return this.mClosed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        DataHolder dataHolder = this;
        synchronized (dataHolder) {
            if (!this.mClosed) {
                this.mClosed = true;
                for (int i2 = 0; i2 < this.Kd.length; ++i2) {
                    this.Kd[i2].close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.Ki && this.Kd.length > 0 && !this.isClosed()) {
                String string2 = this.Kh == null ? "internal object: " + this.toString() : this.Kh.toString();
                Log.e((String)"DataBuffer", (String)("Internal data leak within a DataBuffer object detected!  Be sure to explicitly call release() on all DataBuffer extending objects when you are done with them. (" + string2 + ")"));
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    public static DataHolder as(int n2) {
        return DataHolder.a(n2, null);
    }

    public static DataHolder a(int n2, Bundle bundle) {
        return new DataHolder(Kj, n2, bundle);
    }

    public static class a {
        private final String[] Kb;
        private final ArrayList<HashMap<String, Object>> Kk;
        private final String Kl;
        private final HashMap<Object, Integer> Km;
        private boolean Kn;
        private String Ko;

        private a(String[] stringArray, String string2) {
            this.Kb = o.i(stringArray);
            this.Kk = new ArrayList();
            this.Kl = string2;
            this.Km = new HashMap();
            this.Kn = false;
            this.Ko = null;
        }
    }
}

