/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.events;

import android.os.IBinder;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.events.ResourceEvent;
import com.google.android.gms.drive.events.b;
import com.google.android.gms.drive.internal.ae;
import com.google.android.gms.drive.internal.v;
import com.google.android.gms.drive.metadata.internal.MetadataBundle;
import com.google.android.gms.internal.jy;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public final class CompletionEvent
implements SafeParcelable,
ResourceEvent {
    public static final int STATUS_SUCCESS = 0;
    public static final int STATUS_FAILURE = 1;
    public static final int STATUS_CONFLICT = 2;
    public static final Parcelable.Creator<CompletionEvent> CREATOR = new b();
    final int BR;
    final DriveId MW;
    final String Dd;
    final ParcelFileDescriptor NN;
    final ParcelFileDescriptor NO;
    final MetadataBundle NP;
    final ArrayList<String> NQ;
    final int Fa;
    final IBinder NR;
    private boolean NS = false;
    private boolean NT = false;
    private boolean NU = false;

    CompletionEvent(int versionCode, DriveId driveId, String accountName, ParcelFileDescriptor baseParcelFileDescriptor, ParcelFileDescriptor modifiedParcelFileDescriptor, MetadataBundle modifiedMetadataBundle, ArrayList<String> trackingTags, int status, IBinder releaseCallback) {
        this.BR = versionCode;
        this.MW = driveId;
        this.Dd = accountName;
        this.NN = baseParcelFileDescriptor;
        this.NO = modifiedParcelFileDescriptor;
        this.NP = modifiedMetadataBundle;
        this.NQ = trackingTags;
        this.Fa = status;
        this.NR = releaseCallback;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        b.a(this, dest, flags);
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public DriveId getDriveId() {
        this.hU();
        return this.MW;
    }

    public String getAccountName() {
        this.hU();
        return this.Dd;
    }

    public InputStream getBaseContentsInputStream() {
        this.hU();
        if (this.NN == null) {
            return null;
        }
        if (this.NS) {
            throw new IllegalStateException("getBaseInputStream() can only be called once per CompletionEvent instance.");
        }
        this.NS = true;
        return new FileInputStream(this.NN.getFileDescriptor());
    }

    public InputStream getModifiedContentsInputStream() {
        this.hU();
        if (this.NO == null) {
            return null;
        }
        if (this.NT) {
            throw new IllegalStateException("getModifiedInputStream() can only be called once per CompletionEvent instance.");
        }
        this.NT = true;
        return new FileInputStream(this.NO.getFileDescriptor());
    }

    public MetadataChangeSet getModifiedMetadataChangeSet() {
        this.hU();
        return this.NP != null ? new MetadataChangeSet(this.NP) : null;
    }

    public List<String> getTrackingTags() {
        this.hU();
        return new ArrayList<String>(this.NQ);
    }

    public int getStatus() {
        this.hU();
        return this.Fa;
    }

    public void dismiss() {
        this.L(false);
    }

    public void snooze() {
        this.L(true);
    }

    private void L(boolean bl2) {
        this.hU();
        this.NU = true;
        jy.a(this.NN);
        jy.a(this.NO);
        if (this.NR == null) {
            v.q("CompletionEvent", "No callback on " + (bl2 ? "snooze" : "dismiss"));
            return;
        }
        try {
            ae.a.X(this.NR).L(bl2);
        }
        catch (RemoteException remoteException) {
            v.q("CompletionEvent", "RemoteException on " + (bl2 ? "snooze" : "dismiss") + ": " + (Object)((Object)remoteException));
        }
    }

    private void hU() {
        if (this.NU) {
            throw new IllegalStateException("Event has already been dismissed or snoozed.");
        }
    }

    public String toString() {
        String string2 = this.NQ == null ? "<null>" : "'" + TextUtils.join((CharSequence)"','", this.NQ) + "'";
        return String.format(Locale.US, "CompletionEvent [id=%s, status=%s, trackingTag=%s]", this.MW, this.Fa, string2);
    }
}

