/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.o;
import com.google.android.gms.common.internal.safeparcel.c;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.DataDeleteRequest;
import com.google.android.gms.fitness.request.DataReadRequest;
import com.google.android.gms.fitness.result.DataReadResult;
import java.util.concurrent.TimeUnit;

public interface HistoryApi {
    public PendingResult<DataReadResult> readData(GoogleApiClient var1, DataReadRequest var2);

    public PendingResult<Status> insertData(GoogleApiClient var1, DataSet var2);

    public PendingResult<Status> deleteData(GoogleApiClient var1, DataDeleteRequest var2);

    public static class ViewIntentBuilder {
        private final Context mContext;
        private final DataType Sp;
        private DataSource Sq;
        private long KS;
        private long Sr;
        private String Ss;

        public ViewIntentBuilder(Context context, DataType dataType) {
            this.mContext = context;
            this.Sp = dataType;
        }

        public ViewIntentBuilder setTimeInterval(long start, long end, TimeUnit timeUnit) {
            this.KS = timeUnit.toMillis(start);
            this.Sr = timeUnit.toMillis(end);
            return this;
        }

        public ViewIntentBuilder setDataSource(DataSource dataSource) {
            o.b(dataSource.getDataType().equals(this.Sp), "Data source %s is not for the data type %s", dataSource, this.Sp);
            this.Sq = dataSource;
            return this;
        }

        public ViewIntentBuilder setPreferredApplication(String packageName) {
            this.Ss = packageName;
            return this;
        }

        public Intent build() {
            o.a(this.KS > 0L, "Start time must be set");
            o.a(this.Sr > this.KS, "End time must be set and after start time");
            Intent intent = new Intent("vnd.google.fitness.VIEW");
            intent.setType(DataType.getMimeType(this.Sq.getDataType()));
            intent.putExtra("vnd.google.fitness.start_time", this.KS);
            intent.putExtra("vnd.google.fitness.end_time", this.Sr);
            c.a(this.Sq, intent, "vnd.google.fitness.data_source");
            return this.i(intent);
        }

        private Intent i(Intent intent) {
            if (this.Ss == null) {
                return intent;
            }
            Intent intent2 = new Intent(intent).setPackage(this.Ss);
            ResolveInfo resolveInfo = this.mContext.getPackageManager().resolveActivity(intent2, 0);
            if (resolveInfo != null) {
                String string2 = resolveInfo.activityInfo.name;
                intent2.setComponent(new ComponentName(this.Ss, string2));
                return intent2;
            }
            return intent;
        }
    }
}

