/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.common.internal.o;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawDataPoint;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.data.f;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class DataSet
implements SafeParcelable {
    private final int BR;
    private final DataSource Sq;
    private final DataType Sp;
    private final List<DataPoint> SM;
    private final List<DataSource> SN;
    private boolean SF = false;
    public static final Parcelable.Creator<DataSet> CREATOR = new f();

    DataSet(int versionCode, DataSource dataSource, DataType dataType, List<RawDataPoint> dataPoints, List<DataSource> uniqueDataSources, boolean serverHasMoreData) {
        this.BR = versionCode;
        this.Sq = dataSource;
        this.Sp = dataType;
        this.SF = serverHasMoreData;
        this.SM = new ArrayList<DataPoint>(dataPoints.size());
        this.SN = versionCode >= 2 ? uniqueDataSources : Collections.singletonList(dataSource);
        for (RawDataPoint rawDataPoint : dataPoints) {
            this.SM.add(new DataPoint(this.SN, rawDataPoint));
        }
    }

    private DataSet(DataSource dataSource, DataType dataType) {
        this.BR = 3;
        this.Sq = o.i(dataSource);
        this.Sp = o.i(dataType);
        this.SM = new ArrayList<DataPoint>();
        this.SN = new ArrayList<DataSource>();
        this.SN.add(this.Sq);
    }

    public DataSet(RawDataSet dataSet, List<DataSource> uniqueDataSources, List<DataType> uniqueDataTypes) {
        this(3, DataSet.b(uniqueDataSources, dataSet.Tm), DataSet.b(uniqueDataTypes, dataSet.To), dataSet.Tp, uniqueDataSources, dataSet.SF);
    }

    private static <T> T b(List<T> list, int n2) {
        return n2 >= 0 && n2 < list.size() ? (T)list.get(n2) : null;
    }

    public static DataSet create(DataSource dataSource) {
        o.b(dataSource, (Object)"DataSource should be specified");
        return new DataSet(dataSource, dataSource.getDataType());
    }

    public DataPoint createDataPoint() {
        return DataPoint.create(this.Sq);
    }

    public void add(DataPoint dataPoint) {
        DataSource dataSource = dataPoint.getDataSource();
        o.b(dataSource.getStreamIdentifier().equals(this.Sq.getStreamIdentifier()), "Conflicting data sources found %s vs %s", dataSource, this.Sq);
        o.b(dataPoint.getDataType().getName().equals(this.Sp.getName()), "Conflicting data types found %s vs %s", dataPoint.getDataType(), this.Sp);
        o.b(dataPoint.getTimestamp(TimeUnit.NANOSECONDS) > 0L, "Data point does not have the timestamp set: %s", dataPoint);
        o.b(dataPoint.getStartTime(TimeUnit.NANOSECONDS) <= dataPoint.getEndTime(TimeUnit.NANOSECONDS), "Data point with start time greater than end time found: %s", dataPoint);
        this.b(dataPoint);
    }

    public void b(DataPoint dataPoint) {
        this.SM.add(dataPoint);
        DataSource dataSource = dataPoint.getOriginalDataSource();
        if (dataSource != null && !this.SN.contains(dataSource)) {
            this.SN.add(dataSource);
        }
    }

    public void addAll(Iterable<DataPoint> dataPoints) {
        for (DataPoint dataPoint : dataPoints) {
            this.add(dataPoint);
        }
    }

    public void a(Iterable<DataPoint> iterable) {
        for (DataPoint dataPoint : iterable) {
            this.b(dataPoint);
        }
    }

    public DataSource getDataSource() {
        return this.Sq;
    }

    public DataType getDataType() {
        return this.Sp;
    }

    public List<DataPoint> getDataPoints() {
        return Collections.unmodifiableList(this.SM);
    }

    public boolean iC() {
        return this.SF;
    }

    public boolean equals(Object o2) {
        return o2 == this || o2 instanceof DataSet && this.a((DataSet)o2);
    }

    private boolean a(DataSet dataSet) {
        return n.equal(this.Sp, dataSet.Sp) && n.equal(this.Sq, dataSet.Sq) && n.equal(this.SM, dataSet.SM) && this.SF == dataSet.SF;
    }

    public int hashCode() {
        return n.hashCode(this.Sp, this.Sq);
    }

    public String toString() {
        List<RawDataPoint> list = this.iK();
        return String.format("DataSet{%s %s}", this.Sq.toDebugString(), this.SM.size() < 10 ? list : String.format("%d data points, first 5: %s", this.SM.size(), list.subList(0, 5)));
    }

    int getVersionCode() {
        return this.BR;
    }

    List<RawDataPoint> iK() {
        return this.e(this.SN);
    }

    List<RawDataPoint> e(List<DataSource> list) {
        ArrayList<RawDataPoint> arrayList = new ArrayList<RawDataPoint>(this.SM.size());
        for (DataPoint dataPoint : this.SM) {
            arrayList.add(new RawDataPoint(dataPoint, list));
        }
        return arrayList;
    }

    List<DataSource> iL() {
        return this.SN;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        f.a(this, parcel, flags);
    }
}

