/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Context;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.o;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.c;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Device;
import com.google.android.gms.fitness.data.a;
import com.google.android.gms.fitness.data.g;
import com.google.android.gms.internal.kw;

public class DataSource
implements SafeParcelable {
    public static final String EXTRA_DATA_SOURCE = "vnd.google.fitness.data_source";
    public static final int TYPE_RAW = 0;
    public static final int TYPE_DERIVED = 1;
    private final int BR;
    private final DataType Sp;
    private final String mName;
    private final int FD;
    private final Device SO;
    private final a SP;
    private final String SQ;
    private final boolean SR;
    private final String SS;
    public static final Parcelable.Creator<DataSource> CREATOR = new g();

    DataSource(int versionCode, DataType dataType, String name, int type, Device device, a application, String streamName, boolean isObfuscated) {
        this.BR = versionCode;
        this.Sp = dataType;
        this.FD = type;
        this.mName = name;
        this.SO = device;
        this.SP = application;
        this.SQ = streamName;
        this.SR = isObfuscated;
        this.SS = this.iN();
    }

    private DataSource(Builder builder) {
        this.BR = 3;
        this.Sp = builder.Sp;
        this.FD = builder.FD;
        this.mName = builder.mName;
        this.SO = builder.SO;
        this.SP = builder.SP;
        this.SQ = builder.SQ;
        this.SR = builder.SR;
        this.SS = this.iN();
    }

    public static DataSource extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return c.a(intent, EXTRA_DATA_SOURCE, CREATOR);
    }

    public DataType getDataType() {
        return this.Sp;
    }

    public int getType() {
        return this.FD;
    }

    public String getName() {
        return this.mName;
    }

    public String getAppPackageName() {
        return this.SP == null ? null : this.SP.getPackageName();
    }

    public a iM() {
        return this.SP;
    }

    public Device getDevice() {
        return this.SO;
    }

    public String getStreamName() {
        return this.SQ;
    }

    public String getStreamIdentifier() {
        return this.SS;
    }

    private String iN() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getTypeString());
        stringBuilder.append(":").append(this.Sp.getName());
        if (this.SP != null) {
            stringBuilder.append(":").append(this.SP.getPackageName());
        }
        if (this.SO != null) {
            stringBuilder.append(":").append(this.SO.getStreamIdentifier());
        }
        if (this.SQ != null) {
            stringBuilder.append(":").append(this.SQ);
        }
        return stringBuilder.toString();
    }

    public boolean iO() {
        return this.SR;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof DataSource && this.a((DataSource)that);
    }

    private boolean a(DataSource dataSource) {
        return this.SS.equals(dataSource.SS);
    }

    public int hashCode() {
        return this.SS.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("DataSource{");
        stringBuilder.append(this.getTypeString());
        if (this.mName != null) {
            stringBuilder.append(":").append(this.mName);
        }
        if (this.SP != null) {
            stringBuilder.append(":").append(this.SP);
        }
        if (this.SO != null) {
            stringBuilder.append(":").append(this.SO);
        }
        if (this.SQ != null) {
            stringBuilder.append(":").append(this.SQ);
        }
        stringBuilder.append(":").append(this.Sp);
        return stringBuilder.append("}").toString();
    }

    public String toDebugString() {
        return (this.FD == 0 ? "r" : "d") + ":" + this.Sp.iQ() + (this.SP == null ? "" : (this.SP.equals(a.Sw) ? ":gms" : ":" + this.SP.getPackageName())) + (this.SO != null ? ":" + this.SO.getModel() + ":" + this.SO.getUid() : "") + (this.SQ != null ? ":" + this.SQ : "");
    }

    private String getTypeString() {
        switch (this.FD) {
            case 0: {
                return "raw";
            }
            case 1: {
                return "derived";
            }
        }
        throw new IllegalArgumentException("invalid type value");
    }

    public DataSource iP() {
        Device device = this.SO == null ? null : this.SO.iT();
        a a2 = this.SP == null ? null : this.SP.iA();
        return new DataSource(3, this.Sp, this.mName, this.FD, device, a2, kw.bt(this.SQ), this.SR);
    }

    int getVersionCode() {
        return this.BR;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        DataSource dataSource = kw.c(this);
        g.a(dataSource, parcel, flags);
    }

    public static final class Builder {
        private DataType Sp;
        private int FD = -1;
        private String mName;
        private Device SO;
        private a SP;
        private String SQ = "";
        private boolean SR = false;

        public Builder setDataType(DataType dataType) {
            this.Sp = dataType;
            return this;
        }

        public Builder setType(int type) {
            this.FD = type;
            return this;
        }

        public Builder setName(String name) {
            this.mName = name;
            return this;
        }

        public Builder setDevice(Device device) {
            this.SO = device;
            return this;
        }

        public Builder setAppPackageName(String packageName) {
            this.SP = new a(packageName, null, null);
            return this;
        }

        public Builder setAppPackageName(Context appContext) {
            return this.setAppPackageName(appContext.getPackageName());
        }

        public Builder setStreamName(String streamName) {
            o.b(streamName != null, (Object)"Must specify a valid stream name");
            this.SQ = streamName;
            return this;
        }

        public Builder setObfuscated(boolean isObfuscated) {
            this.SR = isObfuscated;
            return this;
        }

        public DataSource build() {
            o.a(this.Sp != null, "Must set data type");
            o.a(this.FD >= 0, "Must set data source type");
            return new DataSource(this);
        }
    }
}

