/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.common.internal.o;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.c;
import com.google.android.gms.fitness.FitnessActivities;
import com.google.android.gms.fitness.data.a;
import com.google.android.gms.fitness.data.p;
import java.util.concurrent.TimeUnit;

public class Session
implements SafeParcelable {
    public static final String EXTRA_SESSION = "vnd.google.fitness.session";
    public static final String MIME_TYPE_PREFIX = "vnd.google.fitness.session/";
    private final int BR;
    private final long KS;
    private final long Sr;
    private final String mName;
    private final String Tq;
    private final String Tr;
    private final int SC;
    private final a SP;
    public static final Parcelable.Creator<Session> CREATOR = new p();

    Session(int versionCode, long startTimeMillis, long endTimeMillis, String name, String identifier, String description, int activityType, a application) {
        this.BR = versionCode;
        this.KS = startTimeMillis;
        this.Sr = endTimeMillis;
        this.mName = name;
        this.Tq = identifier;
        this.Tr = description;
        this.SC = activityType;
        this.SP = application;
    }

    private Session(Builder builder) {
        this.BR = 2;
        this.KS = builder.KS;
        this.Sr = builder.Sr;
        this.mName = builder.mName;
        this.Tq = builder.Tq;
        this.Tr = builder.Tr;
        this.SC = builder.SC;
        this.SP = builder.SP;
    }

    public static Session extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return c.a(intent, EXTRA_SESSION, CREATOR);
    }

    public static String getMimeType(String activity) {
        return MIME_TYPE_PREFIX + activity;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.KS, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.Sr, TimeUnit.MILLISECONDS);
    }

    public boolean isOngoing() {
        return this.Sr == 0L;
    }

    public String getName() {
        return this.mName;
    }

    public String getIdentifier() {
        return this.Tq;
    }

    public String getDescription() {
        return this.Tr;
    }

    public String getActivity() {
        return FitnessActivities.getName(this.SC);
    }

    public int iB() {
        return this.SC;
    }

    public a iM() {
        return this.SP;
    }

    public String getAppPackageName() {
        return this.SP == null ? null : this.SP.getPackageName();
    }

    public boolean equals(Object o2) {
        return o2 == this || o2 instanceof Session && this.a((Session)o2);
    }

    private boolean a(Session session) {
        return this.KS == session.KS && this.Sr == session.Sr && n.equal(this.mName, session.mName) && n.equal(this.Tq, session.Tq) && n.equal(this.Tr, session.Tr) && n.equal(this.SP, session.SP) && this.SC == session.SC;
    }

    public int hashCode() {
        return n.hashCode(this.KS, this.Sr, this.Tq);
    }

    public String toString() {
        return n.h(this).a("startTime", this.KS).a("endTime", this.Sr).a("name", this.mName).a("identifier", this.Tq).a("description", this.Tr).a("activity", this.SC).a("application", this.SP).toString();
    }

    int getVersionCode() {
        return this.BR;
    }

    public long iD() {
        return this.KS;
    }

    public long iE() {
        return this.Sr;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        p.a(this, dest, flags);
    }

    public static class Builder {
        private long KS = 0L;
        private long Sr = 0L;
        private String mName = null;
        private String Tq;
        private String Tr;
        private int SC = 4;
        private a SP;

        public Builder setStartTime(long time, TimeUnit timeUnit) {
            o.a(time > 0L, "Start time should be positive.");
            this.KS = timeUnit.toMillis(time);
            return this;
        }

        public Builder setEndTime(long time, TimeUnit timeUnit) {
            o.a(time >= 0L, "End time should be positive.");
            this.Sr = timeUnit.toMillis(time);
            return this;
        }

        public Builder setName(String name) {
            o.b(name.length() <= 100, "Session name cannot exceed %d characters", 100);
            this.mName = name;
            return this;
        }

        public Builder setIdentifier(String identifier) {
            o.K(identifier != null && TextUtils.getTrimmedLength((CharSequence)identifier) > 0);
            this.Tq = identifier;
            return this;
        }

        public Builder setDescription(String description) {
            o.b(description.length() <= 1000, "Session description cannot exceed %d characters", 1000);
            this.Tr = description;
            return this;
        }

        public Builder setActivity(String activity) {
            return this.cK(FitnessActivities.bp(activity));
        }

        public Builder cK(int n2) {
            this.SC = n2;
            return this;
        }

        public Session build() {
            o.a(this.KS > 0L, "Start time should be specified.");
            o.a(this.Sr == 0L || this.Sr > this.KS, "End time should be later than start time.");
            if (this.Tq == null) {
                this.Tq = (this.mName == null ? "" : this.mName) + this.KS;
            }
            return new Session(this);
        }
    }
}

