/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.common.internal.o;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.Field;
import com.google.android.gms.fitness.request.i;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DataTypeCreateRequest
implements SafeParcelable {
    private final int BR;
    private final String mName;
    private final List<Field> SY;
    public static final Parcelable.Creator<DataTypeCreateRequest> CREATOR = new i();

    DataTypeCreateRequest(int versionCode, String name, List<Field> fields) {
        this.BR = versionCode;
        this.mName = name;
        this.SY = Collections.unmodifiableList(fields);
    }

    private DataTypeCreateRequest(Builder builder) {
        this.BR = 1;
        this.mName = builder.mName;
        this.SY = Collections.unmodifiableList(builder.SY);
    }

    public String getName() {
        return this.mName;
    }

    public List<Field> getFields() {
        return this.SY;
    }

    public boolean equals(Object o2) {
        return o2 == this || o2 instanceof DataTypeCreateRequest && this.a((DataTypeCreateRequest)o2);
    }

    private boolean a(DataTypeCreateRequest dataTypeCreateRequest) {
        return n.equal(this.mName, dataTypeCreateRequest.mName) && n.equal(this.SY, dataTypeCreateRequest.SY);
    }

    public int hashCode() {
        return n.hashCode(this.mName, this.SY);
    }

    public String toString() {
        return n.h(this).a("name", this.mName).a("fields", this.SY).toString();
    }

    int getVersionCode() {
        return this.BR;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        i.a(this, dest, flags);
    }

    public static class Builder {
        private String mName;
        private List<Field> SY = new ArrayList<Field>();

        public Builder setName(String name) {
            this.mName = name;
            return this;
        }

        public Builder addField(Field field) {
            if (!this.SY.contains(field)) {
                this.SY.add(field);
            }
            return this;
        }

        public Builder addField(String name, int format) {
            o.b(name != null || !name.isEmpty(), (Object)"Invalid name specified");
            Field field = new Field(name, format);
            return this.addField(field);
        }

        public DataTypeCreateRequest build() {
            o.a(this.mName != null, "Must set the name");
            o.a(!this.SY.isEmpty(), "Must specify the data fields");
            return new DataTypeCreateRequest(this);
        }
    }
}

