/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.os.Parcel;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.common.internal.o;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.PlayerLevelCreator;

public final class PlayerLevel
implements SafeParcelable {
    public static final PlayerLevelCreator CREATOR = new PlayerLevelCreator();
    private final int BR;
    private final int VR;
    private final long VS;
    private final long VT;

    public PlayerLevel(int value, long minXp, long maxXp) {
        this(1, value, minXp, maxXp);
    }

    PlayerLevel(int versionCode, int levelNumber, long minXp, long maxXp) {
        o.a(minXp >= 0L, "Min XP must be positive!");
        o.a(maxXp > minXp, "Max XP must be more than min XP!");
        this.BR = versionCode;
        this.VR = levelNumber;
        this.VS = minXp;
        this.VT = maxXp;
    }

    public int getVersionCode() {
        return this.BR;
    }

    public int getLevelNumber() {
        return this.VR;
    }

    public long getMinXp() {
        return this.VS;
    }

    public long getMaxXp() {
        return this.VT;
    }

    public int hashCode() {
        return n.hashCode(this.VR, this.VS, this.VT);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PlayerLevel)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        PlayerLevel playerLevel = (PlayerLevel)obj;
        return n.equal(playerLevel.getLevelNumber(), this.getLevelNumber()) && n.equal(playerLevel.getMinXp(), this.getMinXp()) && n.equal(playerLevel.getMaxXp(), this.getMaxXp());
    }

    public String toString() {
        return n.h(this).a("LevelNumber", this.getLevelNumber()).a("MinXp", this.getMinXp()).a("MaxXp", this.getMaxXp()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        PlayerLevelCreator.a(this, out, flags);
    }
}

