/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.os.Parcel;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.common.internal.o;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.PlayerLevel;
import com.google.android.gms.games.PlayerLevelInfoCreator;

public final class PlayerLevelInfo
implements SafeParcelable {
    public static final PlayerLevelInfoCreator CREATOR = new PlayerLevelInfoCreator();
    private final int BR;
    private final long VU;
    private final long VV;
    private final PlayerLevel VW;
    private final PlayerLevel VX;

    public PlayerLevelInfo(long currentXpTotal, long lastLevelUpTimestamp, PlayerLevel currentLevel, PlayerLevel nextLevel) {
        this(1, currentXpTotal, lastLevelUpTimestamp, currentLevel, nextLevel);
    }

    PlayerLevelInfo(int versionCode, long currentXpTotal, long lastLevelUpTimestamp, PlayerLevel currentLevel, PlayerLevel nextLevel) {
        o.I(currentXpTotal != -1L);
        o.i(currentLevel);
        o.i(nextLevel);
        this.BR = versionCode;
        this.VU = currentXpTotal;
        this.VV = lastLevelUpTimestamp;
        this.VW = currentLevel;
        this.VX = nextLevel;
    }

    public int getVersionCode() {
        return this.BR;
    }

    public long getCurrentXpTotal() {
        return this.VU;
    }

    public long getLastLevelUpTimestamp() {
        return this.VV;
    }

    public PlayerLevel getCurrentLevel() {
        return this.VW;
    }

    public PlayerLevel getNextLevel() {
        return this.VX;
    }

    public boolean isMaxLevel() {
        return this.VW.equals(this.VX);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PlayerLevelInfo)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        PlayerLevelInfo playerLevelInfo = (PlayerLevelInfo)obj;
        return n.equal(this.VU, playerLevelInfo.VU) && n.equal(this.VV, playerLevelInfo.VV) && n.equal(this.VW, playerLevelInfo.VW) && n.equal(this.VX, playerLevelInfo.VX);
    }

    public int hashCode() {
        return n.hashCode(this.VU, this.VV, this.VW, this.VX);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        PlayerLevelInfoCreator.a(this, out, flags);
    }
}

