/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.data.a;
import com.google.android.gms.common.internal.o;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataChangeCreator;

public final class SnapshotMetadataChange
implements SafeParcelable {
    public static final SnapshotMetadataChangeCreator CREATOR = new SnapshotMetadataChangeCreator();
    private final int BR;
    private final String Tr;
    private final Long adj;
    private final Uri adk;
    private a adl;
    public static final SnapshotMetadataChange EMPTY_CHANGE = new SnapshotMetadataChange();

    SnapshotMetadataChange() {
        this(4, null, null, null, null);
    }

    SnapshotMetadataChange(String description, Long playedTimeMillis, a coverImage, Uri coverImageUri) {
        this(4, description, playedTimeMillis, coverImage, coverImageUri);
    }

    SnapshotMetadataChange(int versionCode, String description, Long playedTimeMillis, a coverImage, Uri coverImageUri) {
        this.BR = versionCode;
        this.Tr = description;
        this.adj = playedTimeMillis;
        this.adl = coverImage;
        this.adk = coverImageUri;
        if (this.adl != null) {
            o.a(this.adk == null, "Cannot set both a URI and an image");
        } else if (this.adk != null) {
            o.a(this.adl == null, "Cannot set both a URI and an image");
        }
    }

    public int getVersionCode() {
        return this.BR;
    }

    public String getDescription() {
        return this.Tr;
    }

    public Long getPlayedTimeMillis() {
        return this.adj;
    }

    public a lM() {
        return this.adl;
    }

    public Bitmap getCoverImage() {
        return this.adl == null ? null : this.adl.gw();
    }

    public Uri getCoverImageUri() {
        return this.adk;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        SnapshotMetadataChangeCreator.a(this, out, flags);
    }

    public static final class Builder {
        private String Tr;
        private Long adm;
        private a adn;
        private Uri adk;

        public Builder setDescription(String description) {
            this.Tr = description;
            return this;
        }

        public Builder setPlayedTimeMillis(long playedTimeMillis) {
            this.adm = playedTimeMillis;
            return this;
        }

        public Builder setCoverImage(Bitmap coverImage) {
            this.adn = new a(coverImage);
            this.adk = null;
            return this;
        }

        public Builder fromMetadata(SnapshotMetadata metadata) {
            this.Tr = metadata.getDescription();
            this.adm = metadata.getPlayedTime();
            if (this.adm == -1L) {
                this.adm = null;
            }
            this.adk = metadata.getCoverImageUri();
            if (this.adk != null) {
                this.adn = null;
            }
            return this;
        }

        public SnapshotMetadataChange build() {
            return new SnapshotMetadataChange(this.Tr, this.adm, this.adn, this.adk);
        }
    }
}

