/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import com.google.android.gms.common.internal.o;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.dynamic.d;
import com.google.android.gms.maps.internal.v;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.e;
import com.google.android.gms.maps.model.f;

public final class GroundOverlayOptions
implements SafeParcelable {
    public static final e CREATOR = new e();
    public static final float NO_DIMENSION = -1.0f;
    private final int BR;
    private BitmapDescriptor ajO;
    private LatLng ajP;
    private float ajQ;
    private float ajR;
    private LatLngBounds ajS;
    private float ajE;
    private float ajL;
    private boolean ajM = true;
    private float ajT = 0.0f;
    private float ajU = 0.5f;
    private float ajV = 0.5f;

    GroundOverlayOptions(int versionCode, IBinder wrappedImage, LatLng location, float width, float height, LatLngBounds bounds, float bearing, float zIndex, boolean visible, float transparency, float anchorU, float anchorV) {
        this.BR = versionCode;
        this.ajO = new BitmapDescriptor(d.a.am(wrappedImage));
        this.ajP = location;
        this.ajQ = width;
        this.ajR = height;
        this.ajS = bounds;
        this.ajE = bearing;
        this.ajL = zIndex;
        this.ajM = visible;
        this.ajT = transparency;
        this.ajU = anchorU;
        this.ajV = anchorV;
    }

    public GroundOverlayOptions() {
        this.BR = 1;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (v.mM()) {
            f.a(this, out, flags);
        } else {
            e.a(this, out, flags);
        }
    }

    public int describeContents() {
        return 0;
    }

    IBinder mO() {
        return this.ajO.mo().asBinder();
    }

    public GroundOverlayOptions image(BitmapDescriptor image) {
        this.ajO = image;
        return this;
    }

    public GroundOverlayOptions anchor(float u2, float v2) {
        this.ajU = u2;
        this.ajV = v2;
        return this;
    }

    public GroundOverlayOptions position(LatLng location, float width) {
        o.a(this.ajS == null, "Position has already been set using positionFromBounds");
        o.b(location != null, (Object)"Location must be specified");
        o.b(width >= 0.0f, (Object)"Width must be non-negative");
        return this.a(location, width, -1.0f);
    }

    public GroundOverlayOptions position(LatLng location, float width, float height) {
        o.a(this.ajS == null, "Position has already been set using positionFromBounds");
        o.b(location != null, (Object)"Location must be specified");
        o.b(width >= 0.0f, (Object)"Width must be non-negative");
        o.b(height >= 0.0f, (Object)"Height must be non-negative");
        return this.a(location, width, height);
    }

    private GroundOverlayOptions a(LatLng latLng, float f2, float f3) {
        this.ajP = latLng;
        this.ajQ = f2;
        this.ajR = f3;
        return this;
    }

    public GroundOverlayOptions positionFromBounds(LatLngBounds bounds) {
        o.a(this.ajP == null, "Position has already been set using position: " + this.ajP);
        this.ajS = bounds;
        return this;
    }

    public GroundOverlayOptions bearing(float bearing) {
        this.ajE = (bearing % 360.0f + 360.0f) % 360.0f;
        return this;
    }

    public GroundOverlayOptions zIndex(float zIndex) {
        this.ajL = zIndex;
        return this;
    }

    public GroundOverlayOptions visible(boolean visible) {
        this.ajM = visible;
        return this;
    }

    public GroundOverlayOptions transparency(float transparency) {
        o.b(transparency >= 0.0f && transparency <= 1.0f, (Object)"Transparency must be in the range [0..1]");
        this.ajT = transparency;
        return this;
    }

    int getVersionCode() {
        return this.BR;
    }

    public BitmapDescriptor getImage() {
        return this.ajO;
    }

    public LatLng getLocation() {
        return this.ajP;
    }

    public float getWidth() {
        return this.ajQ;
    }

    public float getHeight() {
        return this.ajR;
    }

    public LatLngBounds getBounds() {
        return this.ajS;
    }

    public float getBearing() {
        return this.ajE;
    }

    public float getZIndex() {
        return this.ajL;
    }

    public float getTransparency() {
        return this.ajT;
    }

    public float getAnchorU() {
        return this.ajU;
    }

    public float getAnchorV() {
        return this.ajV;
    }

    public boolean isVisible() {
        return this.ajM;
    }
}

