/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.common.internal.o;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.internal.v;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.g;
import com.google.android.gms.maps.model.h;

public final class LatLngBounds
implements SafeParcelable {
    public static final g CREATOR = new g();
    private final int BR;
    public final LatLng southwest;
    public final LatLng northeast;

    LatLngBounds(int versionCode, LatLng southwest, LatLng northeast) {
        o.b(southwest, (Object)"null southwest");
        o.b(northeast, (Object)"null northeast");
        o.b(northeast.latitude >= southwest.latitude, "southern latitude exceeds northern latitude (%s > %s)", southwest.latitude, northeast.latitude);
        this.BR = versionCode;
        this.southwest = southwest;
        this.northeast = northeast;
    }

    public LatLngBounds(LatLng southwest, LatLng northeast) {
        this(1, southwest, northeast);
    }

    int getVersionCode() {
        return this.BR;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (v.mM()) {
            h.a(this, out, flags);
        } else {
            g.a(this, out, flags);
        }
    }

    public int describeContents() {
        return 0;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean contains(LatLng point) {
        LatLng latLng = point;
        return this.c(latLng.latitude) && this.d(latLng.longitude);
    }

    public LatLngBounds including(LatLng point) {
        LatLng latLng = point;
        double d2 = Math.min(this.southwest.latitude, latLng.latitude);
        double d3 = Math.max(this.northeast.latitude, latLng.latitude);
        double d4 = this.northeast.longitude;
        double d5 = this.southwest.longitude;
        double d6 = latLng.longitude;
        if (!this.d(d6)) {
            if (LatLngBounds.b(d5, d6) < LatLngBounds.c(d4, d6)) {
                d5 = d6;
            } else {
                d4 = d6;
            }
        }
        return new LatLngBounds(new LatLng(d2, d5), new LatLng(d3, d4));
    }

    public LatLng getCenter() {
        double d2 = (this.southwest.latitude + this.northeast.latitude) / 2.0;
        double d3 = this.southwest.longitude;
        double d4 = this.northeast.longitude;
        double d5 = d3 <= d4 ? (d4 + d3) / 2.0 : (d4 + 360.0 + d3) / 2.0;
        return new LatLng(d2, d5);
    }

    private static double b(double d2, double d3) {
        return (d2 - d3 + 360.0) % 360.0;
    }

    private static double c(double d2, double d3) {
        return (d3 - d2 + 360.0) % 360.0;
    }

    private boolean c(double d2) {
        return this.southwest.latitude <= d2 && d2 <= this.northeast.latitude;
    }

    private boolean d(double d2) {
        if (this.southwest.longitude <= this.northeast.longitude) {
            return this.southwest.longitude <= d2 && d2 <= this.northeast.longitude;
        }
        return this.southwest.longitude <= d2 || d2 <= this.northeast.longitude;
    }

    public int hashCode() {
        return n.hashCode(this.southwest, this.northeast);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof LatLngBounds)) {
            return false;
        }
        LatLngBounds latLngBounds = (LatLngBounds)o2;
        return this.southwest.equals(latLngBounds.southwest) && this.northeast.equals(latLngBounds.northeast);
    }

    public String toString() {
        return n.h(this).a("southwest", this.southwest).a("northeast", this.northeast).toString();
    }

    public static final class Builder {
        private double ajY = Double.POSITIVE_INFINITY;
        private double ajZ = Double.NEGATIVE_INFINITY;
        private double aka = Double.NaN;
        private double akb = Double.NaN;

        public Builder include(LatLng point) {
            this.ajY = Math.min(this.ajY, point.latitude);
            this.ajZ = Math.max(this.ajZ, point.latitude);
            double d2 = point.longitude;
            if (Double.isNaN(this.aka)) {
                this.aka = d2;
                this.akb = d2;
            } else if (!this.d(d2)) {
                if (LatLngBounds.b(this.aka, d2) < LatLngBounds.c(this.akb, d2)) {
                    this.aka = d2;
                } else {
                    this.akb = d2;
                }
            }
            return this;
        }

        private boolean d(double d2) {
            if (this.aka <= this.akb) {
                return this.aka <= d2 && d2 <= this.akb;
            }
            return this.aka <= d2 || d2 <= this.akb;
        }

        public LatLngBounds build() {
            o.a(!Double.isNaN(this.aka), "no included points");
            return new LatLngBounds(new LatLng(this.ajY, this.aka), new LatLng(this.ajZ, this.akb));
        }
    }
}

