/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.wallet.fragment.WalletFragmentStyle;
import com.google.android.gms.wallet.fragment.b;

public final class WalletFragmentOptions
implements SafeParcelable {
    public static final Parcelable.Creator<WalletFragmentOptions> CREATOR = new b();
    final int BR;
    private int atL;
    private int mTheme;
    private WalletFragmentStyle aum;
    private int MV;

    public static Builder newBuilder() {
        WalletFragmentOptions walletFragmentOptions = new WalletFragmentOptions();
        walletFragmentOptions.getClass();
        return walletFragmentOptions.new Builder();
    }

    private WalletFragmentOptions() {
        this.BR = 1;
    }

    WalletFragmentOptions(int versionCode, int environment, int theme, WalletFragmentStyle fragmentStyle, int mode) {
        this.BR = versionCode;
        this.atL = environment;
        this.mTheme = theme;
        this.aum = fragmentStyle;
        this.MV = mode;
    }

    public int getEnvironment() {
        return this.atL;
    }

    public int getTheme() {
        return this.mTheme;
    }

    public WalletFragmentStyle getFragmentStyle() {
        return this.aum;
    }

    public int getMode() {
        return this.MV;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        b.a(this, dest, flags);
    }

    public void aa(Context context) {
        if (this.aum != null) {
            this.aum.aa(context);
        }
    }

    public static WalletFragmentOptions a(Context context, AttributeSet attributeSet) {
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.WalletFragmentOptions);
        int n2 = typedArray.getInt(R.styleable.WalletFragmentOptions_appTheme, 0);
        int n3 = typedArray.getInt(R.styleable.WalletFragmentOptions_environment, 1);
        int n4 = typedArray.getResourceId(R.styleable.WalletFragmentOptions_fragmentStyle, 0);
        int n5 = typedArray.getInt(R.styleable.WalletFragmentOptions_fragmentMode, 1);
        typedArray.recycle();
        WalletFragmentOptions walletFragmentOptions = new WalletFragmentOptions();
        walletFragmentOptions.mTheme = n2;
        walletFragmentOptions.atL = n3;
        walletFragmentOptions.aum = new WalletFragmentStyle().setStyleResourceId(n4);
        walletFragmentOptions.aum.aa(context);
        walletFragmentOptions.MV = n5;
        return walletFragmentOptions;
    }

    public final class Builder {
        private Builder() {
        }

        public Builder setEnvironment(int environment) {
            WalletFragmentOptions.this.atL = environment;
            return this;
        }

        public Builder setTheme(int theme) {
            WalletFragmentOptions.this.mTheme = theme;
            return this;
        }

        public Builder setFragmentStyle(int styleResourceId) {
            WalletFragmentOptions.this.aum = new WalletFragmentStyle().setStyleResourceId(styleResourceId);
            return this;
        }

        public Builder setFragmentStyle(WalletFragmentStyle fragmentStyle) {
            WalletFragmentOptions.this.aum = fragmentStyle;
            return this;
        }

        public Builder setMode(int mode) {
            WalletFragmentOptions.this.MV = mode;
            return this;
        }

        public WalletFragmentOptions build() {
            return WalletFragmentOptions.this;
        }
    }
}

