/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.net.Uri;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.wearable.a;

public class Asset
implements SafeParcelable {
    public static final Parcelable.Creator<Asset> CREATOR = new a();
    final int BR;
    private byte[] acH;
    private String auQ;
    public ParcelFileDescriptor auR;
    public Uri uri;

    Asset(int versionCode, byte[] data, String digest, ParcelFileDescriptor fd2, Uri uri) {
        this.BR = versionCode;
        this.acH = data;
        this.auQ = digest;
        this.auR = fd2;
        this.uri = uri;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        a.a(this, dest, flags | 1);
    }

    public static Asset createFromRef(String digest) {
        if (digest == null) {
            throw new IllegalArgumentException("Asset digest cannot be null");
        }
        return new Asset(1, null, digest, null, null);
    }

    public static Asset createFromBytes(byte[] assetData) {
        if (assetData == null) {
            throw new IllegalArgumentException("Asset data cannot be null");
        }
        return new Asset(1, assetData, null, null, null);
    }

    public static Asset createFromFd(ParcelFileDescriptor fd2) {
        if (fd2 == null) {
            throw new IllegalArgumentException("Asset fd cannot be null");
        }
        return new Asset(1, null, null, fd2, null);
    }

    public static Asset createFromUri(Uri uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Asset uri cannot be null");
        }
        return new Asset(1, null, null, null, uri);
    }

    public byte[] getData() {
        return this.acH;
    }

    public String getDigest() {
        return this.auQ;
    }

    public ParcelFileDescriptor getFd() {
        return this.auR;
    }

    public Uri getUri() {
        return this.uri;
    }

    public int hashCode() {
        return n.hashCode(this.acH, this.auQ, this.auR, this.uri);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof Asset)) {
            return false;
        }
        Asset asset = (Asset)o2;
        return n.equal(this.acH, asset.acH) && n.equal(this.auQ, asset.auQ) && n.equal(this.auR, asset.auR) && n.equal(this.uri, asset.uri);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Asset[@");
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        if (this.auQ == null) {
            stringBuilder.append(", nodigest");
        } else {
            stringBuilder.append(", ");
            stringBuilder.append(this.auQ);
        }
        if (this.acH != null) {
            stringBuilder.append(", size=");
            stringBuilder.append(this.acH.length);
        }
        if (this.auR != null) {
            stringBuilder.append(", fd=");
            stringBuilder.append(this.auR);
        }
        if (this.uri != null) {
            stringBuilder.append(", uri=");
            stringBuilder.append(this.uri);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

