/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.internal.view.menu;

import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.support.v4.internal.view.SupportMenuItem;
import android.support.v4.view.ActionProvider;
import android.support.v4.view.MenuItemCompat;
import android.support.v7.internal.view.menu.BaseMenuWrapper;
import android.support.v7.internal.view.menu.BaseWrapper;
import android.util.Log;
import android.view.CollapsibleActionView;
import android.view.ContextMenu;
import android.view.MenuItem;
import android.view.SubMenu;
import android.view.View;
import android.widget.FrameLayout;
import java.lang.reflect.Method;

public class MenuItemWrapperICS
extends BaseMenuWrapper<MenuItem>
implements SupportMenuItem {
    static final String LOG_TAG = "MenuItemWrapper";
    private final boolean mEmulateProviderVisibilityOverride;
    private boolean mLastRequestVisible;
    private Method mSetExclusiveCheckableMethod;

    MenuItemWrapperICS(MenuItem object, boolean emulateProviderVisibilityOverride) {
        super(object);
        this.mLastRequestVisible = object.isVisible();
        this.mEmulateProviderVisibilityOverride = emulateProviderVisibilityOverride;
    }

    MenuItemWrapperICS(MenuItem object) {
        this(object, true);
    }

    public int getItemId() {
        return ((MenuItem)this.mWrappedObject).getItemId();
    }

    public int getGroupId() {
        return ((MenuItem)this.mWrappedObject).getGroupId();
    }

    public int getOrder() {
        return ((MenuItem)this.mWrappedObject).getOrder();
    }

    public MenuItem setTitle(CharSequence title) {
        ((MenuItem)this.mWrappedObject).setTitle(title);
        return this;
    }

    public MenuItem setTitle(int title) {
        ((MenuItem)this.mWrappedObject).setTitle(title);
        return this;
    }

    public CharSequence getTitle() {
        return ((MenuItem)this.mWrappedObject).getTitle();
    }

    public MenuItem setTitleCondensed(CharSequence title) {
        ((MenuItem)this.mWrappedObject).setTitleCondensed(title);
        return this;
    }

    public CharSequence getTitleCondensed() {
        return ((MenuItem)this.mWrappedObject).getTitleCondensed();
    }

    public MenuItem setIcon(Drawable icon) {
        ((MenuItem)this.mWrappedObject).setIcon(icon);
        return this;
    }

    public MenuItem setIcon(int iconRes) {
        ((MenuItem)this.mWrappedObject).setIcon(iconRes);
        return this;
    }

    public Drawable getIcon() {
        return ((MenuItem)this.mWrappedObject).getIcon();
    }

    public MenuItem setIntent(Intent intent) {
        ((MenuItem)this.mWrappedObject).setIntent(intent);
        return this;
    }

    public Intent getIntent() {
        return ((MenuItem)this.mWrappedObject).getIntent();
    }

    public MenuItem setShortcut(char numericChar, char alphaChar) {
        ((MenuItem)this.mWrappedObject).setShortcut(numericChar, alphaChar);
        return this;
    }

    public MenuItem setNumericShortcut(char numericChar) {
        ((MenuItem)this.mWrappedObject).setNumericShortcut(numericChar);
        return this;
    }

    public char getNumericShortcut() {
        return ((MenuItem)this.mWrappedObject).getNumericShortcut();
    }

    public MenuItem setAlphabeticShortcut(char alphaChar) {
        ((MenuItem)this.mWrappedObject).setAlphabeticShortcut(alphaChar);
        return this;
    }

    public char getAlphabeticShortcut() {
        return ((MenuItem)this.mWrappedObject).getAlphabeticShortcut();
    }

    public MenuItem setCheckable(boolean checkable) {
        ((MenuItem)this.mWrappedObject).setCheckable(checkable);
        return this;
    }

    public boolean isCheckable() {
        return ((MenuItem)this.mWrappedObject).isCheckable();
    }

    public MenuItem setChecked(boolean checked) {
        ((MenuItem)this.mWrappedObject).setChecked(checked);
        return this;
    }

    public boolean isChecked() {
        return ((MenuItem)this.mWrappedObject).isChecked();
    }

    public MenuItem setVisible(boolean visible) {
        if (this.mEmulateProviderVisibilityOverride) {
            this.mLastRequestVisible = visible;
            if (this.checkActionProviderOverrideVisibility()) {
                return this;
            }
        }
        return this.wrappedSetVisible(visible);
    }

    public boolean isVisible() {
        return ((MenuItem)this.mWrappedObject).isVisible();
    }

    public MenuItem setEnabled(boolean enabled) {
        ((MenuItem)this.mWrappedObject).setEnabled(enabled);
        return this;
    }

    public boolean isEnabled() {
        return ((MenuItem)this.mWrappedObject).isEnabled();
    }

    public boolean hasSubMenu() {
        return ((MenuItem)this.mWrappedObject).hasSubMenu();
    }

    public SubMenu getSubMenu() {
        return this.getSubMenuWrapper(((MenuItem)this.mWrappedObject).getSubMenu());
    }

    public MenuItem setOnMenuItemClickListener(MenuItem.OnMenuItemClickListener menuItemClickListener) {
        ((MenuItem)this.mWrappedObject).setOnMenuItemClickListener((MenuItem.OnMenuItemClickListener)(menuItemClickListener != null ? new OnMenuItemClickListenerWrapper(menuItemClickListener) : null));
        return this;
    }

    public ContextMenu.ContextMenuInfo getMenuInfo() {
        return ((MenuItem)this.mWrappedObject).getMenuInfo();
    }

    public void setShowAsAction(int actionEnum) {
        ((MenuItem)this.mWrappedObject).setShowAsAction(actionEnum);
    }

    public MenuItem setShowAsActionFlags(int actionEnum) {
        ((MenuItem)this.mWrappedObject).setShowAsActionFlags(actionEnum);
        return this;
    }

    public MenuItem setActionView(View view) {
        if (view instanceof android.support.v7.view.CollapsibleActionView) {
            view = new CollapsibleActionViewWrapper((View)view);
        }
        ((MenuItem)this.mWrappedObject).setActionView(view);
        return this;
    }

    public MenuItem setActionView(int resId) {
        ((MenuItem)this.mWrappedObject).setActionView(resId);
        View actionView = ((MenuItem)this.mWrappedObject).getActionView();
        if (actionView instanceof android.support.v7.view.CollapsibleActionView) {
            ((MenuItem)this.mWrappedObject).setActionView((View)new CollapsibleActionViewWrapper(actionView));
        }
        return this;
    }

    public View getActionView() {
        View actionView = ((MenuItem)this.mWrappedObject).getActionView();
        if (actionView instanceof CollapsibleActionViewWrapper) {
            return ((CollapsibleActionViewWrapper)actionView).getWrappedView();
        }
        return actionView;
    }

    public MenuItem setActionProvider(android.view.ActionProvider provider) {
        ((MenuItem)this.mWrappedObject).setActionProvider(provider);
        if (provider != null && this.mEmulateProviderVisibilityOverride) {
            this.checkActionProviderOverrideVisibility();
        }
        return this;
    }

    public android.view.ActionProvider getActionProvider() {
        return ((MenuItem)this.mWrappedObject).getActionProvider();
    }

    public boolean expandActionView() {
        return ((MenuItem)this.mWrappedObject).expandActionView();
    }

    public boolean collapseActionView() {
        return ((MenuItem)this.mWrappedObject).collapseActionView();
    }

    public boolean isActionViewExpanded() {
        return ((MenuItem)this.mWrappedObject).isActionViewExpanded();
    }

    public MenuItem setOnActionExpandListener(MenuItem.OnActionExpandListener listener) {
        ((MenuItem)this.mWrappedObject).setOnActionExpandListener(listener);
        return this;
    }

    public SupportMenuItem setSupportOnActionExpandListener(MenuItemCompat.OnActionExpandListener listener) {
        ((MenuItem)this.mWrappedObject).setOnActionExpandListener((MenuItem.OnActionExpandListener)(listener != null ? new OnActionExpandListenerWrapper(listener) : null));
        return null;
    }

    public SupportMenuItem setSupportActionProvider(ActionProvider actionProvider) {
        ((MenuItem)this.mWrappedObject).setActionProvider(actionProvider != null ? this.createActionProviderWrapper(actionProvider) : null);
        return this;
    }

    public ActionProvider getSupportActionProvider() {
        ActionProviderWrapper providerWrapper = (ActionProviderWrapper)((MenuItem)this.mWrappedObject).getActionProvider();
        return providerWrapper != null ? providerWrapper.mInner : null;
    }

    public void setExclusiveCheckable(boolean checkable) {
        try {
            if (this.mSetExclusiveCheckableMethod == null) {
                this.mSetExclusiveCheckableMethod = ((MenuItem)this.mWrappedObject).getClass().getDeclaredMethod("setExclusiveCheckable", Boolean.TYPE);
            }
            this.mSetExclusiveCheckableMethod.invoke(this.mWrappedObject, checkable);
        }
        catch (Exception e) {
            Log.w((String)LOG_TAG, (String)"Error while calling setExclusiveCheckable", (Throwable)e);
        }
    }

    ActionProviderWrapper createActionProviderWrapper(ActionProvider provider) {
        return new ActionProviderWrapper(provider);
    }

    final boolean checkActionProviderOverrideVisibility() {
        ActionProvider provider;
        if (this.mLastRequestVisible && (provider = this.getSupportActionProvider()) != null && provider.overridesItemVisibility() && !provider.isVisible()) {
            this.wrappedSetVisible(false);
            return true;
        }
        return false;
    }

    final MenuItem wrappedSetVisible(boolean visible) {
        return ((MenuItem)this.mWrappedObject).setVisible(visible);
    }

    static class CollapsibleActionViewWrapper
    extends FrameLayout
    implements CollapsibleActionView {
        final android.support.v7.view.CollapsibleActionView mWrappedView;

        CollapsibleActionViewWrapper(View actionView) {
            super(actionView.getContext());
            this.mWrappedView = (android.support.v7.view.CollapsibleActionView)actionView;
            this.addView(actionView);
        }

        public void onActionViewExpanded() {
            this.mWrappedView.onActionViewExpanded();
        }

        public void onActionViewCollapsed() {
            this.mWrappedView.onActionViewCollapsed();
        }

        View getWrappedView() {
            return (View)this.mWrappedView;
        }
    }

    class ActionProviderWrapper
    extends android.view.ActionProvider {
        final ActionProvider mInner;

        public ActionProviderWrapper(ActionProvider inner) {
            super(inner.getContext());
            this.mInner = inner;
            if (MenuItemWrapperICS.this.mEmulateProviderVisibilityOverride) {
                this.mInner.setVisibilityListener(new ActionProvider.VisibilityListener(){

                    public void onActionProviderVisibilityChanged(boolean isVisible) {
                        if (ActionProviderWrapper.this.mInner.overridesItemVisibility() && MenuItemWrapperICS.this.mLastRequestVisible) {
                            MenuItemWrapperICS.this.wrappedSetVisible(isVisible);
                        }
                    }
                });
            }
        }

        public View onCreateActionView() {
            if (MenuItemWrapperICS.this.mEmulateProviderVisibilityOverride) {
                MenuItemWrapperICS.this.checkActionProviderOverrideVisibility();
            }
            return this.mInner.onCreateActionView();
        }

        public boolean onPerformDefaultAction() {
            return this.mInner.onPerformDefaultAction();
        }

        public boolean hasSubMenu() {
            return this.mInner.hasSubMenu();
        }

        public void onPrepareSubMenu(SubMenu subMenu) {
            this.mInner.onPrepareSubMenu(MenuItemWrapperICS.this.getSubMenuWrapper(subMenu));
        }
    }

    private class OnActionExpandListenerWrapper
    extends BaseWrapper<MenuItemCompat.OnActionExpandListener>
    implements MenuItem.OnActionExpandListener {
        OnActionExpandListenerWrapper(MenuItemCompat.OnActionExpandListener object) {
            super(object);
        }

        public boolean onMenuItemActionExpand(MenuItem item) {
            return ((MenuItemCompat.OnActionExpandListener)this.mWrappedObject).onMenuItemActionExpand((MenuItem)MenuItemWrapperICS.this.getMenuItemWrapper(item));
        }

        public boolean onMenuItemActionCollapse(MenuItem item) {
            return ((MenuItemCompat.OnActionExpandListener)this.mWrappedObject).onMenuItemActionCollapse((MenuItem)MenuItemWrapperICS.this.getMenuItemWrapper(item));
        }
    }

    private class OnMenuItemClickListenerWrapper
    extends BaseWrapper<MenuItem.OnMenuItemClickListener>
    implements MenuItem.OnMenuItemClickListener {
        OnMenuItemClickListenerWrapper(MenuItem.OnMenuItemClickListener object) {
            super(object);
        }

        public boolean onMenuItemClick(MenuItem item) {
            return ((MenuItem.OnMenuItemClickListener)this.mWrappedObject).onMenuItemClick((MenuItem)MenuItemWrapperICS.this.getMenuItemWrapper(item));
        }
    }
}

