/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.google.android.gms.analytics.ExceptionReporter;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.TrackerHandler;
import com.google.android.gms.analytics.ac;
import com.google.android.gms.analytics.ad;
import com.google.android.gms.analytics.ai;
import com.google.android.gms.analytics.aj;
import com.google.android.gms.analytics.g;
import com.google.android.gms.analytics.h;
import com.google.android.gms.analytics.t;
import com.google.android.gms.analytics.y;
import com.google.android.gms.analytics.z;
import com.google.android.gms.common.internal.o;
import com.google.android.gms.internal.ju;
import com.google.android.gms.internal.jw;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;

public class Tracker {
    private final TrackerHandler Bm;
    private Context mContext;
    private final Map<String, String> qM = new HashMap<String, String>();
    private ac Bn;
    private final h Bo;
    private final ad Bp;
    private final g Bq;
    private boolean Br;
    private a Bs;
    private ai Bt;
    private ExceptionReporter Bu;

    Tracker(String trackingId, TrackerHandler handler, Context context) {
        this(trackingId, handler, h.dQ(), ad.eQ(), g.dP(), new y("tracking"), context);
    }

    Tracker(String trackingId, TrackerHandler handler, h clientIdDefaultProvider, ad screenResolutionDefaultProvider, g appFieldsDefaultProvider, ac rateLimiter, Context context) {
        this.Bm = handler;
        if (context != null) {
            this.mContext = context.getApplicationContext();
        }
        if (trackingId != null) {
            this.qM.put("&tid", trackingId);
        }
        this.qM.put("useSecure", "1");
        this.Bo = clientIdDefaultProvider;
        this.Bp = screenResolutionDefaultProvider;
        this.Bq = appFieldsDefaultProvider;
        this.qM.put("&a", Integer.toString(new Random().nextInt(Integer.MAX_VALUE) + 1));
        this.Bn = rateLimiter;
        this.Bs = new a();
        this.enableAdvertisingIdCollection(false);
    }

    void a(ai ai2) {
        String string2;
        z.V("Loading Tracker config values.");
        this.Bt = ai2;
        if (this.Bt.eZ()) {
            string2 = this.Bt.fa();
            this.set("&tid", string2);
            z.V("[Tracker] trackingId loaded: " + string2);
        }
        if (this.Bt.fb()) {
            string2 = Double.toString(this.Bt.fc());
            this.set("&sf", string2);
            z.V("[Tracker] sample frequency loaded: " + string2);
        }
        if (this.Bt.fd()) {
            this.setSessionTimeout(this.Bt.getSessionTimeout());
            z.V("[Tracker] session timeout loaded: " + this.eT());
        }
        if (this.Bt.fe()) {
            this.enableAutoActivityTracking(this.Bt.ff());
            z.V("[Tracker] auto activity tracking loaded: " + this.eU());
        }
        if (this.Bt.fg()) {
            if (this.Bt.fh()) {
                this.set("&aip", "1");
                z.V("[Tracker] anonymize ip loaded: true");
            }
            z.V("[Tracker] anonymize ip loaded: false");
        }
        this.enableExceptionReporting(this.Bt.fi());
    }

    public void enableExceptionReporting(boolean enabled) {
        if (this.Br == enabled) {
            return;
        }
        this.Br = enabled;
        if (enabled) {
            this.Bu = new ExceptionReporter(this, Thread.getDefaultUncaughtExceptionHandler(), this.mContext);
            Thread.setDefaultUncaughtExceptionHandler(this.Bu);
            z.V("Uncaught exceptions will be reported to Google Analytics.");
        } else {
            if (this.Bu != null) {
                Thread.setDefaultUncaughtExceptionHandler(this.Bu.dY());
            } else {
                Thread.setDefaultUncaughtExceptionHandler(null);
            }
            z.V("Uncaught exceptions will not be reported to Google Analytics.");
        }
    }

    public void setSessionTimeout(long sessionTimeout) {
        this.Bs.setSessionTimeout(sessionTimeout * 1000L);
    }

    long eT() {
        return this.Bs.eT();
    }

    public void enableAutoActivityTracking(boolean enabled) {
        this.Bs.enableAutoActivityTracking(enabled);
    }

    boolean eU() {
        return this.Bs.eU();
    }

    public void send(Map<String, String> params) {
        String string2;
        t.ep().a(t.a.zq);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.putAll(this.qM);
        if (params != null) {
            hashMap.putAll(params);
        }
        if (TextUtils.isEmpty((CharSequence)((CharSequence)hashMap.get("&tid")))) {
            z.W(String.format("Missing tracking id (%s) parameter.", "&tid"));
        }
        if (TextUtils.isEmpty((CharSequence)(string2 = (String)hashMap.get("&t")))) {
            z.W(String.format("Missing hit type (%s) parameter.", "&t"));
            string2 = "";
        }
        if (this.Bs.eV()) {
            hashMap.put("&sc", "start");
        }
        if ("screenview".equals(string2 = string2.toLowerCase()) || "pageview".equals(string2) || "appview".equals(string2) || TextUtils.isEmpty((CharSequence)string2)) {
            int n2 = Integer.parseInt(this.qM.get("&a"));
            n2 = ++n2 >= Integer.MAX_VALUE ? 1 : n2;
            this.qM.put("&a", Integer.toString(n2));
        }
        if (!(string2.equals("transaction") || string2.equals("item") || this.Bn.eJ())) {
            z.W("Too many hits sent too quickly, rate limiting invoked.");
        } else {
            this.Bm.u(hashMap);
        }
    }

    public String get(String key) {
        t.ep().a(t.a.zo);
        if (TextUtils.isEmpty((CharSequence)key)) {
            return null;
        }
        if (this.qM.containsKey(key)) {
            return this.qM.get(key);
        }
        if (key.equals("&ul")) {
            return aj.a(Locale.getDefault());
        }
        if (this.Bo != null && this.Bo.ac(key)) {
            return this.Bo.getValue(key);
        }
        if (this.Bp != null && this.Bp.ac(key)) {
            return this.Bp.getValue(key);
        }
        if (this.Bq != null && this.Bq.ac(key)) {
            return this.Bq.getValue(key);
        }
        return null;
    }

    public void set(String key, String value) {
        o.b(key, (Object)"Key should be non-null");
        t.ep().a(t.a.zp);
        this.qM.put(key, value);
    }

    public void setSampleRate(double sampleRate) {
        this.set("&sf", Double.toHexString(sampleRate));
    }

    public void setUseSecure(boolean useSecure) {
        this.set("useSecure", aj.C(useSecure));
    }

    public void setScreenName(String screenName) {
        this.set("&cd", screenName);
    }

    public void setLocation(String location) {
        this.set("&dl", location);
    }

    public void setReferrer(String referrer) {
        this.set("&dr", referrer);
    }

    public void setPage(String page) {
        this.set("&dp", page);
    }

    public void setHostname(String hostname) {
        this.set("&dh", hostname);
    }

    public void setTitle(String title) {
        this.set("&dt", title);
    }

    public void setLanguage(String language) {
        this.set("&ul", language);
    }

    public void setEncoding(String encoding) {
        this.set("&de", encoding);
    }

    public void setScreenColors(String screenColors) {
        this.set("&sd", screenColors);
    }

    public void setScreenResolution(int width, int height) {
        if (width < 0 && height < 0) {
            z.W("Invalid width or height. The values should be non-negative.");
            return;
        }
        this.set("&sr", width + "x" + height);
    }

    public void setViewportSize(String viewportSize) {
        this.set("&vp", viewportSize);
    }

    public void setClientId(String clientId) {
        this.set("&cid", clientId);
    }

    public void setAppName(String appName) {
        this.set("&an", appName);
    }

    public void setAppId(String appId) {
        this.set("&aid", appId);
    }

    public void setAppInstallerId(String appInstallerId) {
        this.set("&aiid", appInstallerId);
    }

    public void setAppVersion(String appVersion) {
        this.set("&av", appVersion);
    }

    public void setAnonymizeIp(boolean anonymize) {
        this.set("&aip", aj.C(anonymize));
    }

    public void enableAdvertisingIdCollection(boolean enabled) {
        if (!enabled) {
            this.qM.put("&ate", null);
            this.qM.put("&adid", null);
        } else {
            if (this.qM.containsKey("&ate")) {
                this.qM.remove("&ate");
            }
            if (this.qM.containsKey("&adid")) {
                this.qM.remove("&adid");
            }
        }
    }

    private class a
    implements GoogleAnalytics.a {
        private boolean Bv = false;
        private int Bw = 0;
        private long Bx = -1L;
        private boolean By = false;
        private long Bz;
        private ju yD = jw.hA();

        public void setSessionTimeout(long sessionTimeout) {
            this.Bx = sessionTimeout;
            this.eW();
        }

        public long eT() {
            return this.Bx;
        }

        public void enableAutoActivityTracking(boolean enabled) {
            this.Bv = enabled;
            this.eW();
        }

        public boolean eU() {
            return this.Bv;
        }

        public boolean eV() {
            boolean bl2 = this.By;
            this.By = false;
            return bl2;
        }

        private void eW() {
            GoogleAnalytics googleAnalytics = GoogleAnalytics.eD();
            if (googleAnalytics == null) {
                z.T("GoogleAnalytics isn't initialized for the Tracker!");
                return;
            }
            if (this.Bx >= 0L || this.Bv) {
                googleAnalytics.a(Tracker.this.Bs);
            } else {
                googleAnalytics.b(Tracker.this.Bs);
            }
        }

        @Override
        public void i(Activity activity) {
            t.ep().a(t.a.An);
            if (this.Bw == 0 && this.eX()) {
                this.By = true;
            }
            ++this.Bw;
            if (this.Bv) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("&t", "screenview");
                t.ep().B(true);
                Tracker.this.set("&cd", Tracker.this.Bt != null ? Tracker.this.Bt.k(activity) : activity.getClass().getCanonicalName());
                Tracker.this.send(hashMap);
                t.ep().B(false);
            }
        }

        @Override
        public void j(Activity activity) {
            t.ep().a(t.a.Ao);
            --this.Bw;
            this.Bw = Math.max(0, this.Bw);
            if (this.Bw == 0) {
                this.Bz = this.yD.elapsedRealtime();
            }
        }

        boolean eX() {
            return this.yD.elapsedRealtime() >= this.Bz + Math.max(1000L, this.Bx);
        }
    }
}

