/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.os.DeadObjectException;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.b;
import com.google.android.gms.common.internal.j;
import com.google.android.gms.common.internal.o;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class BaseImplementation {
    static void a(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)((Object)result)).release();
            }
            catch (RuntimeException runtimeException) {
                Log.w((String)"GoogleApi", (String)("Unable to release " + result), (Throwable)runtimeException);
            }
        }
    }

    public static class CallbackHandler<R extends Result>
    extends Handler {
        public static final int CALLBACK_ON_COMPLETE = 1;
        public static final int CALLBACK_ON_TIMEOUT = 2;

        public CallbackHandler() {
            this(Looper.getMainLooper());
        }

        public CallbackHandler(Looper looper) {
            super(looper);
        }

        public void sendResultCallback(ResultCallback<R> callback, R result) {
            this.sendMessage(this.obtainMessage(1, new Pair(callback, result)));
        }

        public void sendTimeoutResultCallback(AbstractPendingResult<R> pendingResult, long millis) {
            this.sendMessageDelayed(this.obtainMessage(2, pendingResult), millis);
        }

        public void removeTimeoutMessages() {
            this.removeMessages(2);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Pair pair = (Pair)msg.obj;
                    this.deliverResultCallback((ResultCallback)pair.first, (Result)pair.second);
                    return;
                }
                case 2: {
                    AbstractPendingResult abstractPendingResult = (AbstractPendingResult)msg.obj;
                    abstractPendingResult.gi();
                    return;
                }
            }
            Log.wtf((String)"GoogleApi", (String)"Don't know how to handle this message.");
        }

        protected void deliverResultCallback(ResultCallback<R> callback, R result) {
            try {
                callback.onResult(result);
            }
            catch (RuntimeException runtimeException) {
                BaseImplementation.a(result);
                throw runtimeException;
            }
        }
    }

    public static abstract class AbstractPendingResult<R extends Result>
    implements b<R>,
    PendingResult<R> {
        private final Object Ir = new Object();
        protected CallbackHandler<R> mHandler;
        private final CountDownLatch mg = new CountDownLatch(1);
        private final ArrayList<PendingResult.a> Is = new ArrayList();
        private ResultCallback<R> It;
        private volatile R Iu;
        private volatile boolean Iv;
        private boolean Iw;
        private boolean Ix;
        private j Iy;

        AbstractPendingResult() {
        }

        public AbstractPendingResult(Looper looper) {
            this.mHandler = new CallbackHandler(looper);
        }

        public AbstractPendingResult(CallbackHandler<R> callbackHandler) {
            this.mHandler = callbackHandler;
        }

        protected abstract R c(Status var1);

        public final boolean isReady() {
            return this.mg.getCount() == 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private R gf() {
            Object object = this.Ir;
            synchronized (object) {
                o.a(!this.Iv, "Result has already been consumed.");
                o.a(this.isReady(), "Result is not ready.");
                R r2 = this.Iu;
                this.gg();
                return r2;
            }
        }

        @Override
        public final R await() {
            o.a(Looper.myLooper() != Looper.getMainLooper(), "await must not be called on the UI thread");
            o.a(!this.Iv, "Result has already been consumed");
            try {
                this.mg.await();
            }
            catch (InterruptedException interruptedException) {
                this.gh();
            }
            o.a(this.isReady(), "Result is not ready.");
            return this.gf();
        }

        @Override
        public final R await(long time, TimeUnit units) {
            o.a(time <= 0L || Looper.myLooper() != Looper.getMainLooper(), "await must not be called on the UI thread when time is greater than zero.");
            o.a(!this.Iv, "Result has already been consumed.");
            try {
                boolean bl2 = this.mg.await(time, units);
                if (!bl2) {
                    this.gi();
                }
            }
            catch (InterruptedException interruptedException) {
                this.gh();
            }
            o.a(this.isReady(), "Result is not ready.");
            return this.gf();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void setResultCallback(ResultCallback<R> callback) {
            o.a(!this.Iv, "Result has already been consumed.");
            Object object = this.Ir;
            synchronized (object) {
                if (this.isCanceled()) {
                    return;
                }
                if (this.isReady()) {
                    this.mHandler.sendResultCallback(callback, this.gf());
                } else {
                    this.It = callback;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void setResultCallback(ResultCallback<R> callback, long time, TimeUnit units) {
            o.a(!this.Iv, "Result has already been consumed.");
            o.a(this.mHandler != null, "CallbackHandler has not been set before calling setResultCallback.");
            Object object = this.Ir;
            synchronized (object) {
                if (this.isCanceled()) {
                    return;
                }
                if (this.isReady()) {
                    this.mHandler.sendResultCallback(callback, this.gf());
                } else {
                    this.It = callback;
                    this.mHandler.sendTimeoutResultCallback(this, units.toMillis(time));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void a(PendingResult.a a2) {
            o.a(!this.Iv, "Result has already been consumed.");
            Object object = this.Ir;
            synchronized (object) {
                if (this.isReady()) {
                    a2.n(this.Iu.getStatus());
                } else {
                    this.Is.add(a2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void a(j j2) {
            Object object = this.Ir;
            synchronized (object) {
                this.Iy = j2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel() {
            Object object = this.Ir;
            synchronized (object) {
                if (this.Iw || this.Iv) {
                    return;
                }
                if (this.Iy != null) {
                    try {
                        this.Iy.cancel();
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
                BaseImplementation.a(this.Iu);
                this.It = null;
                this.Iw = true;
                this.c(this.c(Status.Jz));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isCanceled() {
            Object object = this.Ir;
            synchronized (object) {
                return this.Iw;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void b(R r2) {
            Object object = this.Ir;
            synchronized (object) {
                if (this.Ix || this.Iw) {
                    BaseImplementation.a(r2);
                    return;
                }
                o.a(!this.isReady(), "Results have already been set");
                o.a(!this.Iv, "Result has already been consumed");
                this.c(r2);
            }
        }

        protected void gg() {
            this.Iv = true;
            this.Iu = null;
            this.It = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void gh() {
            Object object = this.Ir;
            synchronized (object) {
                if (!this.isReady()) {
                    this.b(this.c(Status.Jw));
                    this.Ix = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void gi() {
            Object object = this.Ir;
            synchronized (object) {
                if (!this.isReady()) {
                    this.b(this.c(Status.Jy));
                    this.Ix = true;
                }
            }
        }

        private void c(R r2) {
            this.Iu = r2;
            this.Iy = null;
            this.mg.countDown();
            Status status = this.Iu.getStatus();
            if (this.It != null) {
                this.mHandler.removeTimeoutMessages();
                if (!this.Iw) {
                    this.mHandler.sendResultCallback(this.It, this.gf());
                }
            }
            for (PendingResult.a a2 : this.Is) {
                a2.n(status);
            }
            this.Is.clear();
        }

        protected void a(CallbackHandler<R> callbackHandler) {
            this.mHandler = callbackHandler;
        }
    }

    public static abstract class a<R extends Result, A extends Api.a>
    extends AbstractPendingResult<R>
    implements b.c<A> {
        private final Api.c<A> Ip;
        private b.a Iz;

        protected a(Api.c<A> c2) {
            this.Ip = o.i(c2);
        }

        @Override
        public final Api.c<A> ge() {
            return this.Ip;
        }

        @Override
        public final void b(A a2) throws DeadObjectException {
            if (this.mHandler == null) {
                this.a((A)((Object)new CallbackHandler(a2.getLooper())));
            }
            try {
                this.a(a2);
            }
            catch (DeadObjectException deadObjectException) {
                this.a((RemoteException)((Object)deadObjectException));
                throw deadObjectException;
            }
            catch (RemoteException remoteException) {
                this.a(remoteException);
            }
        }

        @Override
        public final void m(Status status) {
            o.b(!status.isSuccess(), (Object)"Failed result must not be success");
            this.b((A)this.c(status));
        }

        @Override
        public void a(b.a a2) {
            this.Iz = a2;
        }

        @Override
        public int gj() {
            return 0;
        }

        protected abstract void a(A var1) throws RemoteException;

        @Override
        protected void gg() {
            super.gg();
            if (this.Iz != null) {
                this.Iz.b(this);
                this.Iz = null;
            }
        }

        private void a(RemoteException remoteException) {
            Status status = new Status(8, remoteException.getLocalizedMessage(), null);
            this.m(status);
        }
    }

    public static interface b<R> {
        public void b(R var1);
    }
}

