/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.IntentSender;
import android.os.Parcel;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.StatusCreator;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;

public final class Status
implements Result,
SafeParcelable {
    public static final Status Jv = new Status(0);
    public static final Status Jw = new Status(14);
    public static final Status Jx = new Status(8);
    public static final Status Jy = new Status(15);
    public static final Status Jz = new Status(16);
    public static final StatusCreator CREATOR = new StatusCreator();
    private final int BR;
    private final int HF;
    private final String JA;
    private final PendingIntent mPendingIntent;

    Status(int versionCode, int statusCode, String statusMessage, PendingIntent pendingIntent) {
        this.BR = versionCode;
        this.HF = statusCode;
        this.JA = statusMessage;
        this.mPendingIntent = pendingIntent;
    }

    public Status(int statusCode) {
        this(statusCode, null);
    }

    public Status(int statusCode, String statusMessage) {
        this(1, statusCode, statusMessage, null);
    }

    public Status(int statusCode, String statusMessage, PendingIntent pendingIntent) {
        this(1, statusCode, statusMessage, pendingIntent);
    }

    public void startResolutionForResult(Activity activity, int requestCode) throws IntentSender.SendIntentException {
        if (!this.hasResolution()) {
            return;
        }
        activity.startIntentSenderForResult(this.mPendingIntent.getIntentSender(), requestCode, null, 0, 0, 0);
    }

    PendingIntent getPendingIntent() {
        return this.mPendingIntent;
    }

    public String getStatusMessage() {
        return this.JA;
    }

    int getVersionCode() {
        return this.BR;
    }

    public boolean hasResolution() {
        return this.mPendingIntent != null;
    }

    public boolean isSuccess() {
        return this.HF <= 0;
    }

    public boolean isCanceled() {
        return this.HF == 16;
    }

    public boolean isInterrupted() {
        return this.HF == 14;
    }

    public int getStatusCode() {
        return this.HF;
    }

    public PendingIntent getResolution() {
        return this.mPendingIntent;
    }

    public int hashCode() {
        return n.hashCode(this.BR, this.HF, this.JA, this.mPendingIntent);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Status)) {
            return false;
        }
        Status status = (Status)obj;
        return this.BR == status.BR && this.HF == status.HF && n.equal(this.JA, status.JA) && n.equal(this.mPendingIntent, status.mPendingIntent);
    }

    private String fX() {
        if (this.JA != null) {
            return this.JA;
        }
        return CommonStatusCodes.getStatusCodeString(this.HF);
    }

    public String toString() {
        return n.h(this).a("statusCode", this.fX()).a("resolution", this.mPendingIntent).toString();
    }

    @Deprecated
    public ConnectionResult gt() {
        return new ConnectionResult(this.HF, this.mPendingIntent);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        StatusCreator.a(this, out, flags);
    }

    @Override
    public Status getStatus() {
        return this;
    }
}

