/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.o;

public class d
extends Fragment
implements DialogInterface.OnCancelListener,
LoaderManager.LoaderCallbacks<ConnectionResult> {
    private boolean JB;
    private int JC = -1;
    private ConnectionResult JD;
    private final Handler JE = new Handler(Looper.getMainLooper());
    private final SparseArray<b> JF = new SparseArray();

    public static d a(FragmentActivity fragmentActivity) {
        d d2;
        o.aT("Must be called from main thread of process");
        FragmentManager fragmentManager = fragmentActivity.getSupportFragmentManager();
        try {
            d2 = (d)fragmentManager.findFragmentByTag("GmsSupportLifecycleFragment");
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("Fragment with tag GmsSupportLifecycleFragment is not a SupportLifecycleFragment", classCastException);
        }
        if (d2 == null || d2.isRemoving()) {
            d2 = new d();
            fragmentManager.beginTransaction().add((Fragment)d2, "GmsSupportLifecycleFragment").commit();
            fragmentManager.executePendingTransactions();
        }
        return d2;
    }

    public GoogleApiClient ak(int n2) {
        a a2;
        if (this.getActivity() != null && (a2 = this.am(n2)) != null) {
            return a2.JG;
        }
        return null;
    }

    public void a(int n2, GoogleApiClient googleApiClient, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        o.b(googleApiClient, (Object)"GoogleApiClient instance cannot be null");
        o.a(this.JF.indexOfKey(n2) < 0, "Already managing a GoogleApiClient with id " + n2);
        b b2 = new b(googleApiClient, onConnectionFailedListener);
        this.JF.put(n2, (Object)b2);
        if (this.getActivity() != null) {
            this.getLoaderManager().initLoader(n2, null, (LoaderManager.LoaderCallbacks)this);
        }
    }

    public void al(int n2) {
        this.getLoaderManager().destroyLoader(n2);
        this.JF.remove(n2);
    }

    public void onCancel(DialogInterface dialogInterface) {
        this.b(this.JC, this.JD);
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        for (int i2 = 0; i2 < this.JF.size(); ++i2) {
            int n2 = this.JF.keyAt(i2);
            a a2 = this.am(n2);
            if (a2 != null) {
                b b2 = (b)this.JF.valueAt(i2);
                if (b2.JG != a2.JG) {
                    this.getLoaderManager().restartLoader(n2, null, (LoaderManager.LoaderCallbacks)this);
                    continue;
                }
            }
            this.getLoaderManager().initLoader(n2, null, (LoaderManager.LoaderCallbacks)this);
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.JB = savedInstanceState.getBoolean("resolving_error", false);
            this.JC = savedInstanceState.getInt("failed_client_id", -1);
            if (this.JC >= 0) {
                this.JD = new ConnectionResult(savedInstanceState.getInt("failed_status"), (PendingIntent)savedInstanceState.getParcelable("failed_resolution"));
            }
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean("resolving_error", this.JB);
        if (this.JC >= 0) {
            outState.putInt("failed_client_id", this.JC);
            outState.putInt("failed_status", this.JD.getErrorCode());
            outState.putParcelable("failed_resolution", (Parcelable)this.JD.getResolution());
        }
    }

    public void onStart() {
        super.onStart();
        if (!this.JB) {
            for (int i2 = 0; i2 < this.JF.size(); ++i2) {
                this.getLoaderManager().initLoader(this.JF.keyAt(i2), null, (LoaderManager.LoaderCallbacks)this);
            }
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        boolean bl2 = false;
        switch (requestCode) {
            case 2: {
                if (GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.getActivity()) != 0) break;
                bl2 = true;
                break;
            }
            case 1: {
                if (resultCode != -1) break;
                bl2 = true;
            }
        }
        if (bl2) {
            this.gu();
        } else {
            this.b(this.JC, this.JD);
        }
    }

    public Loader<ConnectionResult> onCreateLoader(int id2, Bundle args) {
        return new a((Context)this.getActivity(), ((b)this.JF.get((int)id2)).JG);
    }

    public void a(Loader<ConnectionResult> loader, ConnectionResult connectionResult) {
        if (connectionResult.isSuccess()) {
            this.an(loader.getId());
        } else {
            this.a(loader.getId(), connectionResult);
        }
    }

    public void onLoaderReset(Loader<ConnectionResult> loader) {
        if (loader.getId() == this.JC) {
            this.gu();
        }
    }

    a am(int n2) {
        try {
            return (a)this.getLoaderManager().getLoader(n2);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("Unknown loader in SupportLifecycleFragment", classCastException);
        }
    }

    private void an(int n2) {
        if (n2 == this.JC) {
            this.gu();
        }
    }

    private void a(int n2, ConnectionResult connectionResult) {
        if (!this.JB) {
            this.JB = true;
            this.JC = n2;
            this.JD = connectionResult;
            this.JE.post((Runnable)new c(n2, connectionResult));
        }
    }

    private void b(int n2, ConnectionResult connectionResult) {
        Log.w((String)"GmsSupportLifecycleFragment", (String)"Unresolved error while connecting client. Stopping auto-manage.");
        b b2 = (b)this.JF.get(n2);
        if (b2 != null) {
            this.al(n2);
            GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = b2.JJ;
            if (onConnectionFailedListener != null) {
                onConnectionFailedListener.onConnectionFailed(connectionResult);
            }
        }
        this.gu();
    }

    private void gu() {
        this.JB = false;
        this.JC = -1;
        this.JD = null;
        LoaderManager loaderManager = this.getLoaderManager();
        for (int i2 = 0; i2 < this.JF.size(); ++i2) {
            int n2 = this.JF.keyAt(i2);
            a a2 = this.am(n2);
            if (a2 != null) {
                a2.gv();
            }
            loaderManager.initLoader(n2, null, (LoaderManager.LoaderCallbacks)this);
        }
    }

    public /* synthetic */ void onLoadFinished(Loader x0, Object x1) {
        this.a((Loader<ConnectionResult>)x0, (ConnectionResult)x1);
    }

    static class a
    extends Loader<ConnectionResult>
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener {
        public final GoogleApiClient JG;
        private boolean JH;
        private ConnectionResult JI;

        public a(Context context, GoogleApiClient googleApiClient) {
            super(context);
            this.JG = googleApiClient;
        }

        public void gv() {
            if (this.JH) {
                this.JH = false;
                if (this.isStarted() && !this.isAbandoned()) {
                    this.JG.connect();
                }
            }
        }

        protected void onStartLoading() {
            super.onStartLoading();
            this.JG.registerConnectionCallbacks(this);
            this.JG.registerConnectionFailedListener(this);
            if (this.JI != null) {
                this.deliverResult(this.JI);
            }
            if (!(this.JG.isConnected() || this.JG.isConnecting() || this.JH)) {
                this.JG.connect();
            }
        }

        protected void onStopLoading() {
            this.JG.disconnect();
        }

        protected void onReset() {
            this.JI = null;
            this.JH = false;
            this.JG.unregisterConnectionCallbacks(this);
            this.JG.unregisterConnectionFailedListener(this);
            this.JG.disconnect();
        }

        @Override
        public void onConnected(Bundle connectionHint) {
            this.JH = false;
            this.a(ConnectionResult.HE);
        }

        @Override
        public void onConnectionSuspended(int cause) {
        }

        @Override
        public void onConnectionFailed(ConnectionResult result) {
            this.JH = true;
            this.a(result);
        }

        private void a(ConnectionResult connectionResult) {
            this.JI = connectionResult;
            if (this.isStarted() && !this.isAbandoned()) {
                this.deliverResult(connectionResult);
            }
        }
    }

    private static class b {
        public final GoogleApiClient JG;
        public final GoogleApiClient.OnConnectionFailedListener JJ;

        private b(GoogleApiClient googleApiClient, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            this.JG = googleApiClient;
            this.JJ = onConnectionFailedListener;
        }
    }

    private class c
    implements Runnable {
        private final int JK;
        private final ConnectionResult JL;

        public c(int n2, ConnectionResult connectionResult) {
            this.JK = n2;
            this.JL = connectionResult;
        }

        @Override
        public void run() {
            if (this.JL.hasResolution()) {
                try {
                    int n2 = d.this.getActivity().getSupportFragmentManager().getFragments().indexOf((Object)d.this);
                    int n3 = 1 + (1 + n2 << 16);
                    this.JL.startResolutionForResult((Activity)d.this.getActivity(), n3);
                }
                catch (IntentSender.SendIntentException sendIntentException) {
                    d.this.gu();
                }
            } else if (GooglePlayServicesUtil.isUserRecoverableError(this.JL.getErrorCode())) {
                GooglePlayServicesUtil.showErrorDialogFragment(this.JL.getErrorCode(), (Activity)d.this.getActivity(), d.this, 2, d.this);
            } else {
                d.this.b(this.JK, this.JL);
            }
        }
    }
}

