/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.internal;

import android.os.RemoteException;
import com.google.android.gms.common.api.BaseImplementation;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.drive.Contents;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveContents;
import com.google.android.gms.drive.DriveFile;
import com.google.android.gms.drive.DriveFolder;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.ExecutionOptions;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.internal.CreateFileRequest;
import com.google.android.gms.drive.internal.CreateFolderRequest;
import com.google.android.gms.drive.internal.OnDriveIdResponse;
import com.google.android.gms.drive.internal.ac;
import com.google.android.gms.drive.internal.o;
import com.google.android.gms.drive.internal.p;
import com.google.android.gms.drive.internal.q;
import com.google.android.gms.drive.internal.r;
import com.google.android.gms.drive.internal.s;
import com.google.android.gms.drive.internal.w;
import com.google.android.gms.drive.query.Filters;
import com.google.android.gms.drive.query.Query;
import com.google.android.gms.drive.query.SearchableField;

public class u
extends w
implements DriveFolder {
    public u(DriveId driveId) {
        super(driveId);
    }

    @Override
    public PendingResult<DriveApi.MetadataBufferResult> listChildren(GoogleApiClient apiClient) {
        return this.queryChildren(apiClient, null);
    }

    @Override
    public PendingResult<DriveApi.MetadataBufferResult> queryChildren(GoogleApiClient apiClient, Query query) {
        Query.Builder builder = new Query.Builder().addFilter(Filters.in(SearchableField.PARENTS, this.getDriveId()));
        if (query != null) {
            if (query.getFilter() != null) {
                builder.addFilter(query.getFilter());
            }
            builder.setPageToken(query.getPageToken());
            builder.setSortOrder(query.getSortOrder());
        }
        return new o().query(apiClient, builder.build());
    }

    @Override
    public PendingResult<DriveFolder.DriveFileResult> createFile(GoogleApiClient apiClient, MetadataChangeSet changeSet, Contents contents) {
        r r2 = new r(contents);
        return this.createFile(apiClient, changeSet, r2);
    }

    @Override
    public PendingResult<DriveFolder.DriveFileResult> createFile(GoogleApiClient apiClient, MetadataChangeSet changeSet, DriveContents driveContents) {
        return this.createFile(apiClient, changeSet, driveContents, null);
    }

    @Override
    public PendingResult<DriveFolder.DriveFileResult> createFile(GoogleApiClient apiClient, MetadataChangeSet changeSet, DriveContents driveContents, ExecutionOptions executionOptions) {
        if (executionOptions == null) {
            executionOptions = new ExecutionOptions.Builder().build();
        }
        if (executionOptions.hQ() != 0) {
            throw new IllegalStateException("May not set a conflict strategy for calls to createFile.");
        }
        return this.a(apiClient, changeSet, driveContents, executionOptions);
    }

    private PendingResult<DriveFolder.DriveFileResult> a(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet, DriveContents driveContents, ExecutionOptions executionOptions) {
        if (driveContents == null) {
            throw new IllegalArgumentException("DriveContents must be provided.");
        }
        if (!(driveContents instanceof r)) {
            throw new IllegalArgumentException("Only DriveContents obtained from the Drive API are accepted.");
        }
        if (driveContents.getDriveId() != null) {
            throw new IllegalArgumentException("Only DriveContents obtained through DriveApi.newDriveContents are accepted for file creation.");
        }
        if (driveContents.getContents().hK()) {
            throw new IllegalArgumentException("DriveContents are already closed.");
        }
        if (metadataChangeSet == null) {
            throw new IllegalArgumentException("MetadataChangeSet must be provided.");
        }
        if ("application/vnd.google-apps.folder".equals(metadataChangeSet.getMimeType())) {
            throw new IllegalArgumentException("May not create folders (mimetype: application/vnd.google-apps.folder) using this method. Use DriveFolder.createFolder() instead.");
        }
        return this.a(googleApiClient, metadataChangeSet, driveContents.getContents(), 0, executionOptions);
    }

    private PendingResult<DriveFolder.DriveFileResult> a(GoogleApiClient googleApiClient, final MetadataChangeSet metadataChangeSet, final Contents contents, final int n2, final ExecutionOptions executionOptions) {
        ExecutionOptions.a(googleApiClient, executionOptions);
        if (contents != null) {
            contents.hJ();
        }
        return googleApiClient.b(new d(){

            @Override
            protected void a(q q2) throws RemoteException {
                metadataChangeSet.hS().setContext(q2.getContext());
                int n22 = contents == null ? 0 : contents.getRequestId();
                CreateFileRequest createFileRequest = new CreateFileRequest(u.this.getDriveId(), metadataChangeSet.hS(), n22, n2, executionOptions);
                q2.hY().a(createFileRequest, (ac)new a(this));
            }
        });
    }

    @Override
    public PendingResult<DriveFolder.DriveFolderResult> createFolder(GoogleApiClient apiClient, final MetadataChangeSet changeSet) {
        if (changeSet == null) {
            throw new IllegalArgumentException("MetadataChangeSet must be provided.");
        }
        if (changeSet.getMimeType() != null && !changeSet.getMimeType().equals("application/vnd.google-apps.folder")) {
            throw new IllegalArgumentException("The mimetype must be of type application/vnd.google-apps.folder");
        }
        return apiClient.b(new f(){

            @Override
            protected void a(q q2) throws RemoteException {
                changeSet.hS().setContext(q2.getContext());
                q2.hY().a(new CreateFolderRequest(u.this.getDriveId(), changeSet.hS()), (ac)new b(this));
            }
        });
    }

    private static class b
    extends com.google.android.gms.drive.internal.c {
        private final BaseImplementation.b<DriveFolder.DriveFolderResult> De;

        public b(BaseImplementation.b<DriveFolder.DriveFolderResult> b2) {
            this.De = b2;
        }

        @Override
        public void a(OnDriveIdResponse onDriveIdResponse) throws RemoteException {
            this.De.b(new e(Status.Jv, new u(onDriveIdResponse.getDriveId())));
        }

        @Override
        public void o(Status status) throws RemoteException {
            this.De.b(new e(status, null));
        }
    }

    private static class e
    implements DriveFolder.DriveFolderResult {
        private final Status CM;
        private final DriveFolder OZ;

        public e(Status status, DriveFolder driveFolder) {
            this.CM = status;
            this.OZ = driveFolder;
        }

        @Override
        public Status getStatus() {
            return this.CM;
        }

        @Override
        public DriveFolder getDriveFolder() {
            return this.OZ;
        }
    }

    static abstract class f
    extends p<DriveFolder.DriveFolderResult> {
        f() {
        }

        public DriveFolder.DriveFolderResult u(Status status) {
            return new e(status, null);
        }

        @Override
        public /* synthetic */ Result c(Status status) {
            return this.u(status);
        }
    }

    private static class a
    extends com.google.android.gms.drive.internal.c {
        private final BaseImplementation.b<DriveFolder.DriveFileResult> De;

        public a(BaseImplementation.b<DriveFolder.DriveFileResult> b2) {
            this.De = b2;
        }

        @Override
        public void a(OnDriveIdResponse onDriveIdResponse) throws RemoteException {
            this.De.b(new c(Status.Jv, new s(onDriveIdResponse.getDriveId())));
        }

        @Override
        public void o(Status status) throws RemoteException {
            this.De.b(new c(status, null));
        }
    }

    private static class c
    implements DriveFolder.DriveFileResult {
        private final Status CM;
        private final DriveFile OY;

        public c(Status status, DriveFile driveFile) {
            this.CM = status;
            this.OY = driveFile;
        }

        @Override
        public Status getStatus() {
            return this.CM;
        }

        @Override
        public DriveFile getDriveFile() {
            return this.OY;
        }
    }

    static abstract class d
    extends p<DriveFolder.DriveFileResult> {
        d() {
        }

        public DriveFolder.DriveFileResult t(Status status) {
            return new c(status, null);
        }

        @Override
        public /* synthetic */ Result c(Status status) {
            return this.t(status);
        }
    }
}

