/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness;

import android.util.SparseArray;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.Field;

public class FitnessActivities {
    public static final String MIME_TYPE_PREFIX = "vnd.google.fitness.activity/";
    public static final String EXTRA_STATUS = "actionStatus";
    public static final String STATUS_ACTIVE = "ActiveActionStatus";
    public static final String STATUS_COMPLETED = "CompletedActionStatus";
    private static final SparseArray<String> So = new SparseArray(109);
    public static final String AEROBICS = "aerobics";
    public static final String BADMINTON = "badminton";
    public static final String BASEBALL = "baseball";
    public static final String BASKETBALL = "basketball";
    public static final String BIATHLON = "biathlon";
    public static final String BIKING = "biking";
    public static final String BIKING_HAND = "biking.hand";
    public static final String BIKING_MOUNTAIN = "biking.mountain";
    public static final String BIKING_ROAD = "biking.road";
    public static final String BIKING_SPINNING = "biking.spinning";
    public static final String BIKING_STATIONARY = "biking.stationary";
    public static final String BIKING_UTILITY = "biking.utility";
    public static final String BOXING = "boxing";
    public static final String CALISTHENICS = "calisthenics";
    public static final String CIRCUIT_TRAINING = "circuit_training";
    public static final String CRICKET = "cricket";
    public static final String CURLING = "curling";
    public static final String DANCING = "dancing";
    public static final String DIVING = "diving";
    public static final String ELLIPTICAL = "elliptical";
    public static final String ERGOMETER = "ergometer";
    public static final String FENCING = "fencing";
    public static final String FOOTBALL_AMERICAN = "football.american";
    public static final String FOOTBALL_AUSTRALIAN = "football.australian";
    public static final String FOOTBALL_SOCCER = "football.soccer";
    public static final String FRISBEE_DISC = "frisbee_disc";
    public static final String GARDENING = "gardening";
    public static final String GOLF = "golf";
    public static final String GYMNASTICS = "gymnastics";
    public static final String HANDBALL = "handball";
    public static final String HIKING = "hiking";
    public static final String HOCKEY = "hockey";
    public static final String HORSEBACK_RIDING = "horseback_riding";
    public static final String HOUSEWORK = "housework";
    public static final String ICE_SKATING = "ice_skating";
    public static final String IN_VEHICLE = "in_vehicle";
    public static final String JUMP_ROPE = "jump_rope";
    public static final String KAYAKING = "kayaking";
    public static final String KETTLEBELL_TRAINING = "kettlebell_training";
    public static final String KICK_SCOOTER = "kick_scooter";
    public static final String KICKBOXING = "kickboxing";
    public static final String KITESURFING = "kitesurfing";
    public static final String MARTIAL_ARTS = "martial_arts";
    public static final String MEDITATION = "meditation";
    public static final String MIXED_MARTIAL_ARTS = "martial_arts.mixed";
    public static final String ON_FOOT = "on_foot";
    public static final String OTHER = "other";
    public static final String P90X = "p90x";
    public static final String PARAGLIDING = "paragliding";
    public static final String PILATES = "pilates";
    public static final String POLO = "polo";
    public static final String RACQUETBALL = "racquetball";
    public static final String ROCK_CLIMBING = "rock_climbing";
    public static final String ROWING = "rowing";
    public static final String ROWING_MACHINE = "rowing.machine";
    public static final String RUGBY = "rugby";
    public static final String RUNNING = "running";
    public static final String RUNNING_JOGGING = "running.jogging";
    public static final String RUNNING_SAND = "running.sand";
    public static final String RUNNING_TREADMILL = "running.treadmill";
    public static final String SAILING = "sailing";
    public static final String SCUBA_DIVING = "scuba_diving";
    public static final String SKATEBOARDING = "skateboarding";
    public static final String SKATING = "skating";
    public static final String SKATING_CROSS = "skating.cross";
    public static final String SKATING_INDOOR = "skating.indoor";
    public static final String SKATING_INLINE = "skating.inline";
    public static final String SKIING = "skiing";
    public static final String SKIING_BACK_COUNTRY = "skiing.back_country";
    public static final String SKIING_CROSS_COUNTRY = "skiing.cross_country";
    public static final String SKIING_DOWNHILL = "skiing.downhill";
    public static final String SKIING_KITE = "skiing.kite";
    public static final String SKIING_ROLLER = "skiing.roller";
    public static final String SLEDDING = "sledding";
    public static final String SLEEP = "sleep";
    public static final String SNOWBOARDING = "snowboarding";
    public static final String SNOWMOBILE = "snowmobile";
    public static final String SNOWSHOEING = "snowshoeing";
    public static final String SQUASH = "squash";
    public static final String STAIR_CLIMBING = "stair_climbing";
    public static final String STAIR_CLIMBING_MACHINE = "stair_climbing.machine";
    public static final String STANDUP_PADDLEBOARDING = "standup_paddleboarding";
    public static final String STILL = "still";
    public static final String STRENGTH_TRAINING = "strength_training";
    public static final String SURFING = "surfing";
    public static final String SWIMMING = "swimming";
    public static final String SWIMMING_POOL = "swimming.pool";
    public static final String SWIMMING_OPEN_WATER = "swimming.open_water";
    public static final String TABLE_TENNIS = "table_tennis";
    public static final String TEAM_SPORTS = "team_sports";
    public static final String TENNIS = "tennis";
    public static final String TILTING = "tilting";
    public static final String TREADMILL = "treadmill";
    public static final String UNKNOWN = "unknown";
    public static final String VOLLEYBALL = "volleyball";
    public static final String VOLLEYBALL_BEACH = "volleyball.beach";
    public static final String VOLLEYBALL_INDOOR = "volleyball.indoor";
    public static final String WAKEBOARDING = "wakeboarding";
    public static final String WALKING = "walking";
    public static final String WALKING_FITNESS = "walking.fitness";
    public static final String WALKING_NORDIC = "walking.nordic";
    public static final String WALKING_TREADMILL = "walking.treadmill";
    public static final String WATER_POLO = "water_polo";
    public static final String WEIGHTLIFTING = "weightlifting";
    public static final String WHEELCHAIR = "wheelchair";
    public static final String WINDSURFING = "windsurfing";
    public static final String YOGA = "yoga";
    public static final String ZUMBA = "zumba";

    FitnessActivities() {
    }

    public static void setValue(DataPoint dataPoint, String activity) {
        dataPoint.getValue(Field.FIELD_ACTIVITY).setInt(FitnessActivities.bp(activity));
    }

    public static String getValue(DataPoint dataPoint) {
        return FitnessActivities.getName(dataPoint.getValue(Field.FIELD_ACTIVITY).asInt());
    }

    public static int bp(String string2) {
        int n2 = So.indexOfValue((Object)string2);
        if (n2 < 0) {
            return 4;
        }
        int n3 = So.keyAt(n2);
        if (n3 > 108) {
            return 4;
        }
        return n3;
    }

    public static String getName(int activity) {
        String string2 = (String)So.get(activity);
        if (string2 == null) {
            throw new IllegalArgumentException("Unknown activity " + activity);
        }
        return string2;
    }

    public static String getMimeType(String activity) {
        return MIME_TYPE_PREFIX + activity;
    }

    static {
        So.put(9, (Object)AEROBICS);
        So.put(10, (Object)BADMINTON);
        So.put(11, (Object)BASEBALL);
        So.put(12, (Object)BASKETBALL);
        So.put(13, (Object)BIATHLON);
        So.put(1, (Object)BIKING);
        So.put(14, (Object)BIKING_HAND);
        So.put(15, (Object)BIKING_MOUNTAIN);
        So.put(16, (Object)BIKING_ROAD);
        So.put(17, (Object)BIKING_SPINNING);
        So.put(18, (Object)BIKING_STATIONARY);
        So.put(19, (Object)BIKING_UTILITY);
        So.put(20, (Object)BOXING);
        So.put(21, (Object)CALISTHENICS);
        So.put(22, (Object)CIRCUIT_TRAINING);
        So.put(23, (Object)CRICKET);
        So.put(106, (Object)CURLING);
        So.put(24, (Object)DANCING);
        So.put(102, (Object)DIVING);
        So.put(25, (Object)ELLIPTICAL);
        So.put(103, (Object)ERGOMETER);
        So.put(6, (Object)"exiting_vehicle");
        So.put(26, (Object)FENCING);
        So.put(27, (Object)FOOTBALL_AMERICAN);
        So.put(28, (Object)FOOTBALL_AUSTRALIAN);
        So.put(29, (Object)FOOTBALL_SOCCER);
        So.put(30, (Object)FRISBEE_DISC);
        So.put(31, (Object)GARDENING);
        So.put(32, (Object)GOLF);
        So.put(33, (Object)GYMNASTICS);
        So.put(34, (Object)HANDBALL);
        So.put(35, (Object)HIKING);
        So.put(36, (Object)HOCKEY);
        So.put(37, (Object)HORSEBACK_RIDING);
        So.put(38, (Object)HOUSEWORK);
        So.put(104, (Object)ICE_SKATING);
        So.put(0, (Object)IN_VEHICLE);
        So.put(39, (Object)JUMP_ROPE);
        So.put(40, (Object)KAYAKING);
        So.put(41, (Object)KETTLEBELL_TRAINING);
        So.put(107, (Object)KICK_SCOOTER);
        So.put(42, (Object)KICKBOXING);
        So.put(43, (Object)KITESURFING);
        So.put(44, (Object)MARTIAL_ARTS);
        So.put(45, (Object)MEDITATION);
        So.put(46, (Object)MIXED_MARTIAL_ARTS);
        So.put(2, (Object)ON_FOOT);
        So.put(108, (Object)OTHER);
        So.put(47, (Object)P90X);
        So.put(48, (Object)PARAGLIDING);
        So.put(49, (Object)PILATES);
        So.put(50, (Object)POLO);
        So.put(51, (Object)RACQUETBALL);
        So.put(52, (Object)ROCK_CLIMBING);
        So.put(53, (Object)ROWING);
        So.put(54, (Object)ROWING_MACHINE);
        So.put(55, (Object)RUGBY);
        So.put(8, (Object)RUNNING);
        So.put(56, (Object)RUNNING_JOGGING);
        So.put(57, (Object)RUNNING_SAND);
        So.put(58, (Object)RUNNING_TREADMILL);
        So.put(59, (Object)SAILING);
        So.put(60, (Object)SCUBA_DIVING);
        So.put(61, (Object)SKATEBOARDING);
        So.put(62, (Object)SKATING);
        So.put(63, (Object)SKATING_CROSS);
        So.put(105, (Object)SKATING_INDOOR);
        So.put(64, (Object)SKATING_INLINE);
        So.put(65, (Object)SKIING);
        So.put(66, (Object)SKIING_BACK_COUNTRY);
        So.put(67, (Object)SKIING_CROSS_COUNTRY);
        So.put(68, (Object)SKIING_DOWNHILL);
        So.put(69, (Object)SKIING_KITE);
        So.put(70, (Object)SKIING_ROLLER);
        So.put(71, (Object)SLEDDING);
        So.put(72, (Object)SLEEP);
        So.put(73, (Object)SNOWBOARDING);
        So.put(74, (Object)SNOWMOBILE);
        So.put(75, (Object)SNOWSHOEING);
        So.put(76, (Object)SQUASH);
        So.put(77, (Object)STAIR_CLIMBING);
        So.put(78, (Object)STAIR_CLIMBING_MACHINE);
        So.put(79, (Object)STANDUP_PADDLEBOARDING);
        So.put(3, (Object)STILL);
        So.put(80, (Object)STRENGTH_TRAINING);
        So.put(81, (Object)SURFING);
        So.put(82, (Object)SWIMMING);
        So.put(83, (Object)SWIMMING_POOL);
        So.put(84, (Object)SWIMMING_OPEN_WATER);
        So.put(85, (Object)TABLE_TENNIS);
        So.put(86, (Object)TEAM_SPORTS);
        So.put(87, (Object)TENNIS);
        So.put(5, (Object)TILTING);
        So.put(88, (Object)TREADMILL);
        So.put(4, (Object)UNKNOWN);
        So.put(89, (Object)VOLLEYBALL);
        So.put(90, (Object)VOLLEYBALL_BEACH);
        So.put(91, (Object)VOLLEYBALL_INDOOR);
        So.put(92, (Object)WAKEBOARDING);
        So.put(7, (Object)WALKING);
        So.put(93, (Object)WALKING_FITNESS);
        So.put(94, (Object)WALKING_NORDIC);
        So.put(95, (Object)WALKING_TREADMILL);
        So.put(96, (Object)WATER_POLO);
        So.put(97, (Object)WEIGHTLIFTING);
        So.put(98, (Object)WHEELCHAIR);
        So.put(99, (Object)WINDSURFING);
        So.put(100, (Object)YOGA);
        So.put(101, (Object)ZUMBA);
    }
}

