/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.FitnessActivities;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawBucket;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.data.d;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class Bucket
implements SafeParcelable {
    public static final int TYPE_TIME = 1;
    public static final int TYPE_SESSION = 2;
    public static final int TYPE_ACTIVITY_TYPE = 3;
    public static final int TYPE_ACTIVITY_SEGMENT = 4;
    private final int BR;
    private final long KS;
    private final long Sr;
    private final Session St;
    private final int SC;
    private final List<DataSet> SD;
    private final int SE;
    private boolean SF = false;
    public static final Parcelable.Creator<Bucket> CREATOR = new d();

    Bucket(int versionCode, long startTimeMillis, long endTimeMillis, Session session, int activityType, List<DataSet> dataSets, int bucketType, boolean serverHasMoreData) {
        this.BR = versionCode;
        this.KS = startTimeMillis;
        this.Sr = endTimeMillis;
        this.St = session;
        this.SC = activityType;
        this.SD = dataSets;
        this.SE = bucketType;
        this.SF = serverHasMoreData;
    }

    public Bucket(RawBucket bucket, List<DataSource> uniqueDataSources, List<DataType> uniqueDataTypes) {
        this(2, bucket.KS, bucket.Sr, bucket.St, bucket.Tl, Bucket.a(bucket.SD, uniqueDataSources, uniqueDataTypes), bucket.SE, bucket.SF);
    }

    private static List<DataSet> a(List<RawDataSet> list, List<DataSource> list2, List<DataType> list3) {
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>(list.size());
        for (RawDataSet rawDataSet : list) {
            arrayList.add(new DataSet(rawDataSet, list2, list3));
        }
        return arrayList;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.KS, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.Sr, TimeUnit.MILLISECONDS);
    }

    public Session getSession() {
        return this.St;
    }

    public String getActivity() {
        return FitnessActivities.getName(this.SC);
    }

    public int iB() {
        return this.SC;
    }

    public List<DataSet> getDataSets() {
        return this.SD;
    }

    public DataSet getDataSet(DataType dataType) {
        for (DataSet dataSet : this.SD) {
            if (!dataSet.getDataType().equals(dataType)) continue;
            return dataSet;
        }
        return null;
    }

    public int getBucketType() {
        return this.SE;
    }

    public boolean equals(Object o2) {
        return o2 == this || o2 instanceof Bucket && this.a((Bucket)o2);
    }

    private boolean a(Bucket bucket) {
        return this.KS == bucket.KS && this.Sr == bucket.Sr && this.SC == bucket.SC && n.equal(this.SD, bucket.SD) && this.SE == bucket.SE && this.SF == bucket.SF;
    }

    public boolean b(Bucket bucket) {
        return this.KS == bucket.KS && this.Sr == bucket.Sr && this.SC == bucket.SC && this.SE == bucket.SE;
    }

    public boolean iC() {
        if (this.SF) {
            return true;
        }
        for (DataSet dataSet : this.SD) {
            if (!dataSet.iC()) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return n.hashCode(this.KS, this.Sr, this.SC, this.SE);
    }

    public String toString() {
        return n.h(this).a("startTime", this.KS).a("endTime", this.Sr).a("activity", this.SC).a("dataSets", this.SD).a("bucketType", Bucket.cy(this.SE)).a("serverHasMoreData", this.SF).toString();
    }

    public static String cy(int n2) {
        switch (n2) {
            case 1: {
                return "time";
            }
            case 3: {
                return "type";
            }
            case 4: {
                return "segment";
            }
            case 2: {
                return "session";
            }
            case 0: {
                return "unknown";
            }
        }
        return "bug";
    }

    int getVersionCode() {
        return this.BR;
    }

    public long iD() {
        return this.KS;
    }

    public long iE() {
        return this.Sr;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        d.a(this, dest, flags);
    }
}

