/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.SystemClock;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.common.internal.o;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.location.LocationRequest;
import java.util.concurrent.TimeUnit;

public class SensorRequest {
    public static final int ACCURACY_MODE_LOW = 1;
    public static final int ACCURACY_MODE_DEFAULT = 2;
    public static final int ACCURACY_MODE_HIGH = 3;
    private final DataSource Sq;
    private final DataType Sp;
    private final long Tt;
    private final long UE;
    private final long UD;
    private final int Tu;
    private final LocationRequest UI;
    private final long UJ;

    private SensorRequest(Builder builder) {
        this.Sq = builder.Sq;
        this.Sp = builder.Sp;
        this.Tt = builder.Tt;
        this.UE = builder.UE;
        this.UD = builder.UD;
        this.Tu = builder.Tu;
        this.UI = null;
        this.UJ = builder.UJ;
    }

    private SensorRequest(DataSource dataSource, LocationRequest locationRequest) {
        this.UI = locationRequest;
        this.Tt = TimeUnit.MILLISECONDS.toMicros(locationRequest.getInterval());
        this.UE = TimeUnit.MILLISECONDS.toMicros(locationRequest.getFastestInterval());
        this.UD = this.Tt;
        this.Sp = dataSource.getDataType();
        this.Tu = SensorRequest.a(locationRequest);
        this.Sq = dataSource;
        long l2 = locationRequest.getExpirationTime();
        this.UJ = l2 == Long.MAX_VALUE ? Long.MAX_VALUE : TimeUnit.MILLISECONDS.toMicros(l2 - SystemClock.elapsedRealtime());
    }

    public static SensorRequest fromLocationRequest(DataSource dataSource, LocationRequest locationRequest) {
        return new SensorRequest(dataSource, locationRequest);
    }

    private static int a(LocationRequest locationRequest) {
        switch (locationRequest.getPriority()) {
            case 100: {
                return 3;
            }
            case 104: {
                return 1;
            }
        }
        return 2;
    }

    public DataSource getDataSource() {
        return this.Sq;
    }

    public DataType getDataType() {
        return this.Sp;
    }

    public long getSamplingRate(TimeUnit timeUnit) {
        return timeUnit.convert(this.Tt, TimeUnit.MICROSECONDS);
    }

    public long getFastestRate(TimeUnit timeUnit) {
        return timeUnit.convert(this.UE, TimeUnit.MICROSECONDS);
    }

    public long getMaxDeliveryLatency(TimeUnit timeUnit) {
        return timeUnit.convert(this.UD, TimeUnit.MICROSECONDS);
    }

    public int getAccuracyMode() {
        return this.Tu;
    }

    public long jx() {
        return this.UJ;
    }

    public String toString() {
        return n.h(this).a("dataSource", this.Sq).a("dataType", this.Sp).a("samplingRateMicros", this.Tt).a("deliveryLatencyMicros", this.UD).a("timeOutMicros", this.UJ).toString();
    }

    public boolean equals(Object that) {
        return this == that || that instanceof SensorRequest && this.a((SensorRequest)that);
    }

    private boolean a(SensorRequest sensorRequest) {
        return n.equal(this.Sq, sensorRequest.Sq) && n.equal(this.Sp, sensorRequest.Sp) && this.Tt == sensorRequest.Tt && this.UE == sensorRequest.UE && this.UD == sensorRequest.UD && this.Tu == sensorRequest.Tu && n.equal(this.UI, sensorRequest.UI) && this.UJ == sensorRequest.UJ;
    }

    public int hashCode() {
        return n.hashCode(this.Sq, this.Sp, this.Tt, this.UE, this.UD, this.Tu, this.UI, this.UJ);
    }

    public static int da(int n2) {
        switch (n2) {
            case 1: 
            case 3: {
                return n2;
            }
        }
        return 2;
    }

    public static class Builder {
        private DataSource Sq;
        private DataType Sp;
        private long Tt = -1L;
        private long UE = 0L;
        private long UD = 0L;
        private boolean UK = false;
        private int Tu = 2;
        private long UJ = Long.MAX_VALUE;

        public Builder setDataSource(DataSource dataSource) {
            this.Sq = dataSource;
            return this;
        }

        public Builder setDataType(DataType dataType) {
            this.Sp = dataType;
            return this;
        }

        public Builder setSamplingRate(long interval, TimeUnit unit) {
            o.b(interval >= 0L, (Object)"Cannot use a negative sampling interval");
            this.Tt = unit.toMicros(interval);
            if (!this.UK) {
                this.UE = this.Tt / 2L;
            }
            return this;
        }

        public Builder setFastestRate(int fastestInterval, TimeUnit unit) {
            o.b(fastestInterval >= 0, (Object)"Cannot use a negative interval");
            this.UK = true;
            this.UE = unit.toMicros(fastestInterval);
            return this;
        }

        public Builder setMaxDeliveryLatency(int interval, TimeUnit unit) {
            o.b(interval >= 0, (Object)"Cannot use a negative delivery interval");
            this.UD = unit.toMicros(interval);
            return this;
        }

        public Builder setAccuracyMode(int accuracyMode) {
            this.Tu = SensorRequest.da(accuracyMode);
            return this;
        }

        public Builder setTimeout(long timeout, TimeUnit timeUnit) {
            o.b(timeout > 0L, "Invalid time out value specified: %d", timeout);
            o.b(timeUnit != null, (Object)"Invalid time unit specified");
            this.UJ = timeUnit.toMicros(timeout);
            return this;
        }

        public SensorRequest build() {
            o.a(this.Sq != null || this.Sp != null, "Must call setDataSource() or setDataType()");
            o.a(this.Sp == null || this.Sq == null || this.Sp.equals(this.Sq.getDataType()), "Specified data type is incompatible with specified data source");
            return new SensorRequest(this);
        }
    }
}

