/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.common.internal.o;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.request.s;
import com.google.android.gms.internal.kj;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SessionInsertRequest
implements SafeParcelable {
    private final int BR;
    private final Session St;
    private final List<DataSet> SD;
    private final List<DataPoint> UL;
    public static final Parcelable.Creator<SessionInsertRequest> CREATOR = new s();

    SessionInsertRequest(int versionCode, Session session, List<DataSet> dataSets, List<DataPoint> aggregateDataPoints) {
        this.BR = versionCode;
        this.St = session;
        this.SD = Collections.unmodifiableList(dataSets);
        this.UL = Collections.unmodifiableList(aggregateDataPoints);
    }

    private SessionInsertRequest(Builder builder) {
        this.BR = 1;
        this.St = builder.St;
        this.SD = Collections.unmodifiableList(builder.SD);
        this.UL = Collections.unmodifiableList(builder.UL);
    }

    public Session getSession() {
        return this.St;
    }

    public List<DataSet> getDataSets() {
        return this.SD;
    }

    public List<DataPoint> getAggregateDataPoints() {
        return this.UL;
    }

    public boolean equals(Object o2) {
        return o2 == this || o2 instanceof SessionInsertRequest && this.a((SessionInsertRequest)o2);
    }

    private boolean a(SessionInsertRequest sessionInsertRequest) {
        return n.equal(this.St, sessionInsertRequest.St) && n.equal(this.SD, sessionInsertRequest.SD) && n.equal(this.UL, sessionInsertRequest.UL);
    }

    public int hashCode() {
        return n.hashCode(this.St, this.SD, this.UL);
    }

    public String toString() {
        return n.h(this).a("session", this.St).a("dataSets", this.SD).a("aggregateDataPoints", this.UL).toString();
    }

    int getVersionCode() {
        return this.BR;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        s.a(this, dest, flags);
    }

    public static class Builder {
        private Session St;
        private List<DataSet> SD = new ArrayList<DataSet>();
        private List<DataPoint> UL = new ArrayList<DataPoint>();
        private List<DataSource> UM = new ArrayList<DataSource>();

        public Builder setSession(Session session) {
            this.St = session;
            return this;
        }

        public Builder addDataSet(DataSet dataSet) {
            o.b(dataSet != null, (Object)"Must specify a valid data set.");
            DataSource dataSource = dataSet.getDataSource();
            o.a(!this.UM.contains(dataSource), "Data set for this data source %s is already added.", dataSource);
            List<DataPoint> list = dataSet.getDataPoints();
            o.b(!list.isEmpty(), (Object)"No data points specified in the input data set.");
            this.UM.add(dataSource);
            this.SD.add(dataSet);
            return this;
        }

        public Builder addAggregateDataPoint(DataPoint aggregateDataPoint) {
            o.b(aggregateDataPoint != null, (Object)"Must specify a valid aggregate data point.");
            long l2 = aggregateDataPoint.getStartTime(TimeUnit.NANOSECONDS);
            long l3 = aggregateDataPoint.getEndTime(TimeUnit.NANOSECONDS);
            o.b(l2 > 0L && l3 > l2, "Aggregate data point should have valid start and end times: %s", aggregateDataPoint);
            DataSource dataSource = aggregateDataPoint.getDataSource();
            o.a(!this.UM.contains(dataSource), "Data set/Aggregate data point for this data source %s is already added.", dataSource);
            this.UM.add(dataSource);
            this.UL.add(aggregateDataPoint);
            return this;
        }

        public SessionInsertRequest build() {
            o.a(this.St != null, "Must specify a valid session.");
            o.a(this.St.getEndTime(TimeUnit.MILLISECONDS) != 0L, "Must specify a valid end time, cannot insert a continuing session.");
            this.jy();
            return new SessionInsertRequest(this);
        }

        private void d(DataPoint dataPoint) {
            this.f(dataPoint);
            this.e(dataPoint);
        }

        private void e(DataPoint dataPoint) {
            long l2 = this.St.getStartTime(TimeUnit.NANOSECONDS);
            long l3 = this.St.getEndTime(TimeUnit.NANOSECONDS);
            long l4 = dataPoint.getStartTime(TimeUnit.NANOSECONDS);
            long l5 = dataPoint.getEndTime(TimeUnit.NANOSECONDS);
            if (l4 != 0L && l5 != 0L) {
                TimeUnit timeUnit = TimeUnit.MILLISECONDS;
                if (l5 > l3) {
                    l5 = kj.a(l5, TimeUnit.NANOSECONDS, timeUnit);
                }
                o.a(l4 >= l2 && l5 <= l3, "Data point %s has start and end times outside session interval [%d, %d]", dataPoint, l2, l3);
                if (l5 != dataPoint.getEndTime(TimeUnit.NANOSECONDS)) {
                    Log.w((String)"Fitness", (String)String.format("Data point end time [%d] is truncated to [%d] to match the precision [%s] of the session start and end time", new Object[]{dataPoint.getEndTime(TimeUnit.NANOSECONDS), l5, timeUnit}));
                    dataPoint.setTimeInterval(l4, l5, TimeUnit.NANOSECONDS);
                }
            }
        }

        private void f(DataPoint dataPoint) {
            long l2 = this.St.getStartTime(TimeUnit.NANOSECONDS);
            long l3 = this.St.getEndTime(TimeUnit.NANOSECONDS);
            long l4 = dataPoint.getTimestamp(TimeUnit.NANOSECONDS);
            if (l4 != 0L) {
                TimeUnit timeUnit = TimeUnit.MILLISECONDS;
                if (l4 < l2 || l4 > l3) {
                    l4 = kj.a(l4, TimeUnit.NANOSECONDS, timeUnit);
                }
                o.a(l4 >= l2 && l4 <= l3, "Data point %s has time stamp outside session interval [%d, %d]", dataPoint, l2, l3);
                if (dataPoint.getTimestamp(TimeUnit.NANOSECONDS) != l4) {
                    Log.w((String)"Fitness", (String)String.format("Data point timestamp [%d] is truncated to [%d] to match the precision [%s] of the session start and end time", new Object[]{dataPoint.getTimestamp(TimeUnit.NANOSECONDS), l4, timeUnit}));
                    dataPoint.setTimestamp(l4, TimeUnit.NANOSECONDS);
                }
            }
        }

        private void jy() {
            for (DataSet safeParcelable : this.SD) {
                for (DataPoint dataPoint : safeParcelable.getDataPoints()) {
                    this.d(dataPoint);
                }
            }
            for (DataPoint dataPoint : this.UL) {
                this.d(dataPoint);
            }
        }
    }
}

