/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.common.internal.o;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.t;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SessionReadRequest
implements SafeParcelable {
    private final int BR;
    private final String UN;
    private final String vL;
    private final long KS;
    private final long Sr;
    private final List<DataType> SB;
    private final List<DataSource> Uk;
    private boolean UO;
    private final boolean Uv;
    private final List<String> UP;
    public static final Parcelable.Creator<SessionReadRequest> CREATOR = new t();

    SessionReadRequest(int versionCode, String sessionName, String sessionId, long startTimeMillis, long endTimeMillis, List<DataType> dataTypes, List<DataSource> dataSources, boolean getSessionsFromAllApps, boolean serverQueriesEnabled, List<String> excludedPackages) {
        this.BR = versionCode;
        this.UN = sessionName;
        this.vL = sessionId;
        this.KS = startTimeMillis;
        this.Sr = endTimeMillis;
        this.SB = Collections.unmodifiableList(dataTypes);
        this.Uk = Collections.unmodifiableList(dataSources);
        this.UO = getSessionsFromAllApps;
        this.Uv = serverQueriesEnabled;
        this.UP = excludedPackages;
    }

    private SessionReadRequest(Builder builder) {
        this.BR = 3;
        this.UN = builder.UN;
        this.vL = builder.vL;
        this.KS = builder.KS;
        this.Sr = builder.Sr;
        this.SB = Collections.unmodifiableList(builder.SB);
        this.Uk = Collections.unmodifiableList(builder.Uk);
        this.UO = builder.UO;
        this.Uv = builder.Uv;
        this.UP = Collections.unmodifiableList(builder.UP);
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.KS, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.Sr, TimeUnit.MILLISECONDS);
    }

    public String getSessionName() {
        return this.UN;
    }

    public String getSessionId() {
        return this.vL;
    }

    public List<DataType> getDataTypes() {
        return this.SB;
    }

    public List<DataSource> getDataSources() {
        return this.Uk;
    }

    public boolean includeSessionsFromAllApps() {
        return this.UO;
    }

    public List<String> getExcludedPackages() {
        return this.UP;
    }

    public boolean jl() {
        return this.Uv;
    }

    public boolean equals(Object o2) {
        return this == o2 || o2 instanceof SessionReadRequest && this.a((SessionReadRequest)o2);
    }

    private boolean a(SessionReadRequest sessionReadRequest) {
        return n.equal(this.UN, sessionReadRequest.UN) && this.vL.equals(sessionReadRequest.vL) && this.KS == sessionReadRequest.KS && this.Sr == sessionReadRequest.Sr && n.equal(this.SB, sessionReadRequest.SB) && n.equal(this.Uk, sessionReadRequest.Uk) && this.UO == sessionReadRequest.UO && this.UP.equals(sessionReadRequest.UP) && this.Uv == sessionReadRequest.Uv;
    }

    public int hashCode() {
        return n.hashCode(this.UN, this.vL, this.KS, this.Sr);
    }

    public String toString() {
        return n.h(this).a("sessionName", this.UN).a("sessionId", this.vL).a("startTimeMillis", this.KS).a("endTimeMillis", this.Sr).a("dataTypes", this.SB).a("dataSources", this.Uk).a("sessionsFromAllApps", this.UO).a("excludedPackages", this.UP).a("useServer", this.Uv).toString();
    }

    public long iE() {
        return this.Sr;
    }

    public long iD() {
        return this.KS;
    }

    public boolean jz() {
        return this.UO;
    }

    int getVersionCode() {
        return this.BR;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        t.a(this, dest, flags);
    }

    public static class Builder {
        private String UN;
        private String vL;
        private long KS = 0L;
        private long Sr = 0L;
        private List<DataType> SB = new ArrayList<DataType>();
        private List<DataSource> Uk = new ArrayList<DataSource>();
        private boolean UO = false;
        private boolean Uv = false;
        private List<String> UP = new ArrayList<String>();

        public Builder setTimeInterval(long startTime, long endTime, TimeUnit timeUnit) {
            this.KS = timeUnit.toMillis(startTime);
            this.Sr = timeUnit.toMillis(endTime);
            return this;
        }

        public Builder setSessionName(String sessionName) {
            this.UN = sessionName;
            return this;
        }

        public Builder setSessionId(String sessionId) {
            this.vL = sessionId;
            return this;
        }

        public Builder read(DataSource dataSource) {
            o.b(dataSource, (Object)"Attempting to add a null data source");
            if (!this.Uk.contains(dataSource)) {
                this.Uk.add(dataSource);
            }
            return this;
        }

        public Builder read(DataType dataType) {
            o.b(dataType, (Object)"Attempting to use a null data type");
            if (!this.SB.contains(dataType)) {
                this.SB.add(dataType);
            }
            return this;
        }

        public Builder readSessionsFromAllApps() {
            this.UO = true;
            return this;
        }

        public Builder excludePackage(String appPackageName) {
            o.b(appPackageName, (Object)"Attempting to use a null package name");
            if (!this.UP.contains(appPackageName)) {
                this.UP.add(appPackageName);
            }
            return this;
        }

        public Builder enableServerQueries() {
            this.Uv = true;
            return this;
        }

        public SessionReadRequest build() {
            o.b(this.KS > 0L, "Invalid start time: %s", this.KS);
            o.b(this.Sr > 0L && this.Sr > this.KS, "Invalid end time: %s", this.Sr);
            return new SessionReadRequest(this);
        }
    }
}

