/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.achievement;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.internal.a;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.achievement.Achievement;
import com.google.android.gms.games.achievement.AchievementEntityCreator;
import com.google.android.gms.internal.jv;

public final class AchievementEntity
implements SafeParcelable,
Achievement {
    public static final AchievementEntityCreator CREATOR = new AchievementEntityCreator();
    private final int BR;
    private final String Wa;
    private final int FD;
    private final String mName;
    private final String Tr;
    private final Uri Wb;
    private final String Wc;
    private final Uri Wd;
    private final String We;
    private final int Wf;
    private final String Wg;
    private final PlayerEntity Wh;
    private final int mState;
    private final int Wi;
    private final String Wj;
    private final long Wk;
    private final long Wl;

    public AchievementEntity(Achievement achievement) {
        this.BR = 1;
        this.Wa = achievement.getAchievementId();
        this.FD = achievement.getType();
        this.mName = achievement.getName();
        this.Tr = achievement.getDescription();
        this.Wb = achievement.getUnlockedImageUri();
        this.Wc = achievement.getUnlockedImageUrl();
        this.Wd = achievement.getRevealedImageUri();
        this.We = achievement.getRevealedImageUrl();
        this.Wh = (PlayerEntity)achievement.getPlayer().freeze();
        this.mState = achievement.getState();
        this.Wk = achievement.getLastUpdatedTimestamp();
        this.Wl = achievement.getXpValue();
        if (achievement.getType() == 1) {
            this.Wf = achievement.getTotalSteps();
            this.Wg = achievement.getFormattedTotalSteps();
            this.Wi = achievement.getCurrentSteps();
            this.Wj = achievement.getFormattedCurrentSteps();
        } else {
            this.Wf = 0;
            this.Wg = null;
            this.Wi = 0;
            this.Wj = null;
        }
        a.f(this.Wa);
        a.f(this.Tr);
    }

    AchievementEntity(int versionCode, String achievementId, int type, String name, String description, Uri unlockedImageUri, String unlockedImageUrl, Uri revealedImageUri, String revealedImageUrl, int totalSteps, String formattedTotalSteps, PlayerEntity player, int state, int currentSteps, String formattedCurrentSteps, long lastUpdatedTimestamp, long xpValue) {
        this.BR = versionCode;
        this.Wa = achievementId;
        this.FD = type;
        this.mName = name;
        this.Tr = description;
        this.Wb = unlockedImageUri;
        this.Wc = unlockedImageUrl;
        this.Wd = revealedImageUri;
        this.We = revealedImageUrl;
        this.Wf = totalSteps;
        this.Wg = formattedTotalSteps;
        this.Wh = player;
        this.mState = state;
        this.Wi = currentSteps;
        this.Wj = formattedCurrentSteps;
        this.Wk = lastUpdatedTimestamp;
        this.Wl = xpValue;
    }

    public int getVersionCode() {
        return this.BR;
    }

    @Override
    public String getAchievementId() {
        return this.Wa;
    }

    @Override
    public int getType() {
        return this.FD;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer dataOut) {
        jv.b(this.mName, dataOut);
    }

    @Override
    public String getDescription() {
        return this.Tr;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        jv.b(this.Tr, dataOut);
    }

    @Override
    public Uri getUnlockedImageUri() {
        return this.Wb;
    }

    @Override
    public String getUnlockedImageUrl() {
        return this.Wc;
    }

    @Override
    public Uri getRevealedImageUri() {
        return this.Wd;
    }

    @Override
    public String getRevealedImageUrl() {
        return this.We;
    }

    @Override
    public int getTotalSteps() {
        return this.Wf;
    }

    @Override
    public String getFormattedTotalSteps() {
        return this.Wg;
    }

    @Override
    public void getFormattedTotalSteps(CharArrayBuffer dataOut) {
        jv.b(this.Wg, dataOut);
    }

    @Override
    public Player getPlayer() {
        return this.Wh;
    }

    @Override
    public int getState() {
        return this.mState;
    }

    @Override
    public int getCurrentSteps() {
        return this.Wi;
    }

    @Override
    public String getFormattedCurrentSteps() {
        return this.Wj;
    }

    @Override
    public void getFormattedCurrentSteps(CharArrayBuffer dataOut) {
        jv.b(this.Wj, dataOut);
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.Wk;
    }

    @Override
    public long getXpValue() {
        return this.Wl;
    }

    @Override
    public Achievement freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return AchievementEntity.a(this);
    }

    static int a(Achievement achievement) {
        int n2 = 0;
        int n3 = 0;
        if (achievement.getType() == 1) {
            n2 = achievement.getCurrentSteps();
            n3 = achievement.getTotalSteps();
        }
        return n.hashCode(achievement.getAchievementId(), achievement.getName(), achievement.getType(), achievement.getDescription(), achievement.getXpValue(), achievement.getState(), achievement.getLastUpdatedTimestamp(), achievement.getPlayer(), n2, n3);
    }

    public boolean equals(Object obj) {
        return AchievementEntity.a(this, obj);
    }

    static boolean a(Achievement achievement, Object object) {
        if (!(object instanceof Achievement)) {
            return false;
        }
        if (achievement == object) {
            return true;
        }
        Achievement achievement2 = (Achievement)object;
        boolean bl2 = true;
        boolean bl3 = true;
        if (achievement.getType() == 1) {
            bl2 = n.equal(achievement2.getCurrentSteps(), achievement.getCurrentSteps());
            bl3 = n.equal(achievement2.getTotalSteps(), achievement.getTotalSteps());
        }
        return n.equal(achievement2.getAchievementId(), achievement.getAchievementId()) && n.equal(achievement2.getName(), achievement.getName()) && n.equal(achievement2.getType(), achievement.getType()) && n.equal(achievement2.getDescription(), achievement.getDescription()) && n.equal(achievement2.getXpValue(), achievement.getXpValue()) && n.equal(achievement2.getState(), achievement.getState()) && n.equal(achievement2.getLastUpdatedTimestamp(), achievement.getLastUpdatedTimestamp()) && n.equal(achievement2.getPlayer(), achievement.getPlayer()) && bl2 && bl3;
    }

    public String toString() {
        return AchievementEntity.b(this);
    }

    static String b(Achievement achievement) {
        n.a a2 = n.h(achievement).a("Id", achievement.getAchievementId()).a("Type", achievement.getType()).a("Name", achievement.getName()).a("Description", achievement.getDescription()).a("Player", achievement.getPlayer()).a("State", achievement.getState());
        if (achievement.getType() == 1) {
            a2.a("CurrentSteps", achievement.getCurrentSteps());
            a2.a("TotalSteps", achievement.getTotalSteps());
        }
        return a2.toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        AchievementEntityCreator.a(this, dest, flags);
    }
}

