/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.achievement;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.d;
import com.google.android.gms.common.internal.a;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerRef;
import com.google.android.gms.games.achievement.Achievement;
import com.google.android.gms.games.achievement.AchievementEntity;

public final class AchievementRef
extends d
implements Achievement {
    AchievementRef(DataHolder holder, int dataRow) {
        super(holder, dataRow);
    }

    @Override
    public String getAchievementId() {
        return this.getString("external_achievement_id");
    }

    @Override
    public int getType() {
        return this.getInteger("type");
    }

    @Override
    public String getName() {
        return this.getString("name");
    }

    @Override
    public void getName(CharArrayBuffer dataOut) {
        this.a("name", dataOut);
    }

    @Override
    public String getDescription() {
        return this.getString("description");
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        this.a("description", dataOut);
    }

    @Override
    public Uri getUnlockedImageUri() {
        return this.aR("unlocked_icon_image_uri");
    }

    @Override
    public String getUnlockedImageUrl() {
        return this.getString("unlocked_icon_image_url");
    }

    @Override
    public Uri getRevealedImageUri() {
        return this.aR("revealed_icon_image_uri");
    }

    @Override
    public String getRevealedImageUrl() {
        return this.getString("revealed_icon_image_url");
    }

    @Override
    public int getTotalSteps() {
        a.I(this.getType() == 1);
        return this.getInteger("total_steps");
    }

    @Override
    public String getFormattedTotalSteps() {
        a.I(this.getType() == 1);
        return this.getString("formatted_total_steps");
    }

    @Override
    public void getFormattedTotalSteps(CharArrayBuffer dataOut) {
        a.I(this.getType() == 1);
        this.a("formatted_total_steps", dataOut);
    }

    @Override
    public Player getPlayer() {
        return new PlayerRef(this.II, this.JX);
    }

    @Override
    public int getState() {
        return this.getInteger("state");
    }

    @Override
    public int getCurrentSteps() {
        a.I(this.getType() == 1);
        return this.getInteger("current_steps");
    }

    @Override
    public String getFormattedCurrentSteps() {
        a.I(this.getType() == 1);
        return this.getString("formatted_current_steps");
    }

    @Override
    public void getFormattedCurrentSteps(CharArrayBuffer dataOut) {
        a.I(this.getType() == 1);
        this.a("formatted_current_steps", dataOut);
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.getLong("last_updated_timestamp");
    }

    @Override
    public long getXpValue() {
        if (!this.aQ("instance_xp_value") || this.aS("instance_xp_value")) {
            return this.getLong("definition_xp_value");
        }
        return this.getLong("instance_xp_value");
    }

    @Override
    public Achievement freeze() {
        return new AchievementEntity(this);
    }

    public String toString() {
        return AchievementEntity.b(this);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        AchievementEntity achievementEntity = (AchievementEntity)this.freeze();
        achievementEntity.writeToParcel(dest, flags);
    }
}

