/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardVariant;
import com.google.android.gms.games.leaderboard.LeaderboardVariantEntity;
import com.google.android.gms.internal.jv;
import java.util.ArrayList;

public final class LeaderboardEntity
implements Leaderboard {
    private final String abu;
    private final String NH;
    private final Uri Vh;
    private final int abv;
    private final ArrayList<LeaderboardVariantEntity> abw;
    private final Game abx;
    private final String Vs;

    public LeaderboardEntity(Leaderboard leaderboard) {
        this.abu = leaderboard.getLeaderboardId();
        this.NH = leaderboard.getDisplayName();
        this.Vh = leaderboard.getIconImageUri();
        this.Vs = leaderboard.getIconImageUrl();
        this.abv = leaderboard.getScoreOrder();
        Game game = leaderboard.getGame();
        this.abx = game == null ? null : new GameEntity(game);
        ArrayList<LeaderboardVariant> arrayList = leaderboard.getVariants();
        int n2 = arrayList.size();
        this.abw = new ArrayList(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.abw.add((LeaderboardVariantEntity)arrayList.get(i2).freeze());
        }
    }

    @Override
    public String getLeaderboardId() {
        return this.abu;
    }

    @Override
    public String getDisplayName() {
        return this.NH;
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        jv.b(this.NH, dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.Vh;
    }

    @Override
    public String getIconImageUrl() {
        return this.Vs;
    }

    @Override
    public int getScoreOrder() {
        return this.abv;
    }

    @Override
    public ArrayList<LeaderboardVariant> getVariants() {
        return new ArrayList<LeaderboardVariant>(this.abw);
    }

    @Override
    public Game getGame() {
        return this.abx;
    }

    public Leaderboard lz() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return LeaderboardEntity.a(this);
    }

    static int a(Leaderboard leaderboard) {
        return n.hashCode(leaderboard.getLeaderboardId(), leaderboard.getDisplayName(), leaderboard.getIconImageUri(), leaderboard.getScoreOrder(), leaderboard.getVariants());
    }

    public boolean equals(Object obj) {
        return LeaderboardEntity.a(this, obj);
    }

    static boolean a(Leaderboard leaderboard, Object object) {
        if (!(object instanceof Leaderboard)) {
            return false;
        }
        if (leaderboard == object) {
            return true;
        }
        Leaderboard leaderboard2 = (Leaderboard)object;
        return n.equal(leaderboard2.getLeaderboardId(), leaderboard.getLeaderboardId()) && n.equal(leaderboard2.getDisplayName(), leaderboard.getDisplayName()) && n.equal(leaderboard2.getIconImageUri(), leaderboard.getIconImageUri()) && n.equal(leaderboard2.getScoreOrder(), leaderboard.getScoreOrder()) && n.equal(leaderboard2.getVariants(), leaderboard.getVariants());
    }

    public String toString() {
        return LeaderboardEntity.b(this);
    }

    static String b(Leaderboard leaderboard) {
        return n.h(leaderboard).a("LeaderboardId", leaderboard.getLeaderboardId()).a("DisplayName", leaderboard.getDisplayName()).a("IconImageUri", leaderboard.getIconImageUri()).a("IconImageUrl", leaderboard.getIconImageUrl()).a("ScoreOrder", leaderboard.getScoreOrder()).a("Variants", leaderboard.getVariants()).toString();
    }

    @Override
    public /* synthetic */ Object freeze() {
        return this.lz();
    }
}

