/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.os.Bundle;
import com.google.android.gms.common.internal.o;
import java.util.ArrayList;

public final class TurnBasedMatchConfig {
    private final int acd;
    private final String[] acr;
    private final Bundle acs;
    private final int acD;

    private TurnBasedMatchConfig(Builder builder) {
        this.acd = builder.acd;
        this.acD = builder.acD;
        this.acs = builder.acs;
        int n2 = builder.acv.size();
        this.acr = builder.acv.toArray(new String[n2]);
    }

    public int getVariant() {
        return this.acd;
    }

    public int lH() {
        return this.acD;
    }

    public String[] getInvitedPlayerIds() {
        return this.acr;
    }

    public Bundle getAutoMatchCriteria() {
        return this.acs;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Bundle createAutoMatchCriteria(int minAutoMatchPlayers, int maxAutoMatchPlayers, long exclusiveBitMask) {
        Bundle bundle = new Bundle();
        bundle.putInt("min_automatch_players", minAutoMatchPlayers);
        bundle.putInt("max_automatch_players", maxAutoMatchPlayers);
        bundle.putLong("exclusive_bit_mask", exclusiveBitMask);
        return bundle;
    }

    public static final class Builder {
        int acd = -1;
        ArrayList<String> acv = new ArrayList();
        Bundle acs = null;
        int acD = 2;

        private Builder() {
        }

        public Builder addInvitedPlayer(String playerId) {
            o.i(playerId);
            this.acv.add(playerId);
            return this;
        }

        public Builder addInvitedPlayers(ArrayList<String> playerIds) {
            o.i(playerIds);
            this.acv.addAll(playerIds);
            return this;
        }

        public Builder setVariant(int variant) {
            o.b(variant == -1 || variant > 0, (Object)"Variant must be a positive integer or TurnBasedMatch.MATCH_VARIANT_ANY");
            this.acd = variant;
            return this;
        }

        public Builder setAutoMatchCriteria(Bundle autoMatchCriteria) {
            this.acs = autoMatchCriteria;
            return this;
        }

        public TurnBasedMatchConfig build() {
            return new TurnBasedMatchConfig(this);
        }
    }
}

