/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.database.CharArrayBuffer;
import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchEntityCreator;
import com.google.android.gms.internal.jv;
import java.util.ArrayList;

public final class TurnBasedMatchEntity
implements SafeParcelable,
TurnBasedMatch {
    public static final TurnBasedMatchEntityCreator CREATOR = new TurnBasedMatchEntityCreator();
    private final int BR;
    private final GameEntity aay;
    private final String Xh;
    private final String acw;
    private final long abZ;
    private final String acE;
    private final long Wk;
    private final String acF;
    private final int acG;
    private final int acd;
    private final int Di;
    private final byte[] acH;
    private final ArrayList<ParticipantEntity> acc;
    private final String acI;
    private final byte[] acJ;
    private final int acK;
    private final Bundle acs;
    private final int acL;
    private final boolean acM;
    private final String Tr;
    private final String acN;

    public TurnBasedMatchEntity(TurnBasedMatch match) {
        this.BR = 2;
        this.aay = new GameEntity(match.getGame());
        this.Xh = match.getMatchId();
        this.acw = match.getCreatorId();
        this.abZ = match.getCreationTimestamp();
        this.acE = match.getLastUpdaterId();
        this.Wk = match.getLastUpdatedTimestamp();
        this.acF = match.getPendingParticipantId();
        this.acG = match.getStatus();
        this.acL = match.getTurnStatus();
        this.acd = match.getVariant();
        this.Di = match.getVersion();
        this.acI = match.getRematchId();
        this.acK = match.getMatchNumber();
        this.acs = match.getAutoMatchCriteria();
        this.acM = match.isLocallyModified();
        this.Tr = match.getDescription();
        this.acN = match.getDescriptionParticipantId();
        byte[] byArray = match.getData();
        if (byArray == null) {
            this.acH = null;
        } else {
            this.acH = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.acH, 0, byArray.length);
        }
        byte[] byArray2 = match.getPreviousMatchData();
        if (byArray2 == null) {
            this.acJ = null;
        } else {
            this.acJ = new byte[byArray2.length];
            System.arraycopy(byArray2, 0, this.acJ, 0, byArray2.length);
        }
        ArrayList arrayList = match.getParticipants();
        int n2 = arrayList.size();
        this.acc = new ArrayList(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.acc.add((ParticipantEntity)((Participant)arrayList.get(i2)).freeze());
        }
    }

    TurnBasedMatchEntity(int versionCode, GameEntity game, String matchId, String creatorId, long creationTimestamp, String lastUpdaterId, long lastUpdatedTimestamp, String pendingParticipantId, int matchStatus, int variant, int version, byte[] data, ArrayList<ParticipantEntity> participants, String rematchId, byte[] previousData, int matchNumber, Bundle autoMatchCriteria, int turnStatus, boolean isLocallyModified, String description, String descriptionParticipantId) {
        this.BR = versionCode;
        this.aay = game;
        this.Xh = matchId;
        this.acw = creatorId;
        this.abZ = creationTimestamp;
        this.acE = lastUpdaterId;
        this.Wk = lastUpdatedTimestamp;
        this.acF = pendingParticipantId;
        this.acG = matchStatus;
        this.acL = turnStatus;
        this.acd = variant;
        this.Di = version;
        this.acH = data;
        this.acc = participants;
        this.acI = rematchId;
        this.acJ = previousData;
        this.acK = matchNumber;
        this.acs = autoMatchCriteria;
        this.acM = isLocallyModified;
        this.Tr = description;
        this.acN = descriptionParticipantId;
    }

    public int getVersionCode() {
        return this.BR;
    }

    @Override
    public Game getGame() {
        return this.aay;
    }

    @Override
    public String getMatchId() {
        return this.Xh;
    }

    @Override
    public String getCreatorId() {
        return this.acw;
    }

    @Override
    public long getCreationTimestamp() {
        return this.abZ;
    }

    @Override
    public String getLastUpdaterId() {
        return this.acE;
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.Wk;
    }

    @Override
    public String getPendingParticipantId() {
        return this.acF;
    }

    @Override
    public int getStatus() {
        return this.acG;
    }

    @Override
    public int getTurnStatus() {
        return this.acL;
    }

    @Override
    public String getDescription() {
        return this.Tr;
    }

    @Override
    public String getDescriptionParticipantId() {
        return this.acN;
    }

    @Override
    public Participant getDescriptionParticipant() {
        String string2 = this.getDescriptionParticipantId();
        if (string2 == null) {
            return null;
        }
        return this.getParticipant(string2);
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        jv.b(this.Tr, dataOut);
    }

    @Override
    public int getVariant() {
        return this.acd;
    }

    @Override
    public byte[] getData() {
        return this.acH;
    }

    @Override
    public int getVersion() {
        return this.Di;
    }

    @Override
    public String getRematchId() {
        return this.acI;
    }

    @Override
    public byte[] getPreviousMatchData() {
        return this.acJ;
    }

    @Override
    public int getMatchNumber() {
        return this.acK;
    }

    @Override
    public Bundle getAutoMatchCriteria() {
        return this.acs;
    }

    @Override
    public int getAvailableAutoMatchSlots() {
        if (this.acs == null) {
            return 0;
        }
        return this.acs.getInt("max_automatch_players");
    }

    @Override
    public boolean canRematch() {
        return this.acG == 2 && this.acI == null;
    }

    @Override
    public boolean isLocallyModified() {
        return this.acM;
    }

    @Override
    public int getParticipantStatus(String participantId) {
        return TurnBasedMatchEntity.a((TurnBasedMatch)this, participantId);
    }

    @Override
    public ArrayList<String> getParticipantIds() {
        return TurnBasedMatchEntity.c(this);
    }

    @Override
    public String getParticipantId(String playerId) {
        return TurnBasedMatchEntity.b(this, playerId);
    }

    @Override
    public Participant getParticipant(String participantId) {
        return TurnBasedMatchEntity.c(this, participantId);
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.acc);
    }

    @Override
    public TurnBasedMatch freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return TurnBasedMatchEntity.a(this);
    }

    static int a(TurnBasedMatch turnBasedMatch) {
        return n.hashCode(turnBasedMatch.getGame(), turnBasedMatch.getMatchId(), turnBasedMatch.getCreatorId(), turnBasedMatch.getCreationTimestamp(), turnBasedMatch.getLastUpdaterId(), turnBasedMatch.getLastUpdatedTimestamp(), turnBasedMatch.getPendingParticipantId(), turnBasedMatch.getStatus(), turnBasedMatch.getTurnStatus(), turnBasedMatch.getDescription(), turnBasedMatch.getVariant(), turnBasedMatch.getVersion(), turnBasedMatch.getParticipants(), turnBasedMatch.getRematchId(), turnBasedMatch.getMatchNumber(), turnBasedMatch.getAutoMatchCriteria(), turnBasedMatch.getAvailableAutoMatchSlots(), turnBasedMatch.isLocallyModified());
    }

    public boolean equals(Object obj) {
        return TurnBasedMatchEntity.a((TurnBasedMatch)this, obj);
    }

    static boolean a(TurnBasedMatch turnBasedMatch, Object object) {
        if (!(object instanceof TurnBasedMatch)) {
            return false;
        }
        if (turnBasedMatch == object) {
            return true;
        }
        TurnBasedMatch turnBasedMatch2 = (TurnBasedMatch)object;
        return n.equal(turnBasedMatch2.getGame(), turnBasedMatch.getGame()) && n.equal(turnBasedMatch2.getMatchId(), turnBasedMatch.getMatchId()) && n.equal(turnBasedMatch2.getCreatorId(), turnBasedMatch.getCreatorId()) && n.equal(turnBasedMatch2.getCreationTimestamp(), turnBasedMatch.getCreationTimestamp()) && n.equal(turnBasedMatch2.getLastUpdaterId(), turnBasedMatch.getLastUpdaterId()) && n.equal(turnBasedMatch2.getLastUpdatedTimestamp(), turnBasedMatch.getLastUpdatedTimestamp()) && n.equal(turnBasedMatch2.getPendingParticipantId(), turnBasedMatch.getPendingParticipantId()) && n.equal(turnBasedMatch2.getStatus(), turnBasedMatch.getStatus()) && n.equal(turnBasedMatch2.getTurnStatus(), turnBasedMatch.getTurnStatus()) && n.equal(turnBasedMatch2.getDescription(), turnBasedMatch.getDescription()) && n.equal(turnBasedMatch2.getVariant(), turnBasedMatch.getVariant()) && n.equal(turnBasedMatch2.getVersion(), turnBasedMatch.getVersion()) && n.equal(turnBasedMatch2.getParticipants(), turnBasedMatch.getParticipants()) && n.equal(turnBasedMatch2.getRematchId(), turnBasedMatch.getRematchId()) && n.equal(turnBasedMatch2.getMatchNumber(), turnBasedMatch.getMatchNumber()) && n.equal(turnBasedMatch2.getAutoMatchCriteria(), turnBasedMatch.getAutoMatchCriteria()) && n.equal(turnBasedMatch2.getAvailableAutoMatchSlots(), turnBasedMatch.getAvailableAutoMatchSlots()) && n.equal(turnBasedMatch2.isLocallyModified(), turnBasedMatch.isLocallyModified());
    }

    public String toString() {
        return TurnBasedMatchEntity.b(this);
    }

    static String b(TurnBasedMatch turnBasedMatch) {
        return n.h(turnBasedMatch).a("Game", turnBasedMatch.getGame()).a("MatchId", turnBasedMatch.getMatchId()).a("CreatorId", turnBasedMatch.getCreatorId()).a("CreationTimestamp", turnBasedMatch.getCreationTimestamp()).a("LastUpdaterId", turnBasedMatch.getLastUpdaterId()).a("LastUpdatedTimestamp", turnBasedMatch.getLastUpdatedTimestamp()).a("PendingParticipantId", turnBasedMatch.getPendingParticipantId()).a("MatchStatus", turnBasedMatch.getStatus()).a("TurnStatus", turnBasedMatch.getTurnStatus()).a("Description", turnBasedMatch.getDescription()).a("Variant", turnBasedMatch.getVariant()).a("Data", turnBasedMatch.getData()).a("Version", turnBasedMatch.getVersion()).a("Participants", turnBasedMatch.getParticipants()).a("RematchId", turnBasedMatch.getRematchId()).a("PreviousData", turnBasedMatch.getPreviousMatchData()).a("MatchNumber", turnBasedMatch.getMatchNumber()).a("AutoMatchCriteria", turnBasedMatch.getAutoMatchCriteria()).a("AvailableAutoMatchSlots", turnBasedMatch.getAvailableAutoMatchSlots()).a("LocallyModified", turnBasedMatch.isLocallyModified()).a("DescriptionParticipantId", turnBasedMatch.getDescriptionParticipantId()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        TurnBasedMatchEntityCreator.a(this, out, flags);
    }

    static int a(TurnBasedMatch turnBasedMatch, String string2) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            if (!participant.getParticipantId().equals(string2)) continue;
            return participant.getStatus();
        }
        throw new IllegalStateException("Participant " + string2 + " is not in match " + turnBasedMatch.getMatchId());
    }

    static ArrayList<String> c(TurnBasedMatch turnBasedMatch) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n2 = arrayList.size();
        ArrayList<String> arrayList2 = new ArrayList<String>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            arrayList2.add(participant.getParticipantId());
        }
        return arrayList2;
    }

    static String b(TurnBasedMatch turnBasedMatch, String string2) {
        String string3 = null;
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            Player player = participant.getPlayer();
            if (player == null || !player.getPlayerId().equals(string2)) continue;
            string3 = participant.getParticipantId();
            break;
        }
        return string3;
    }

    static Participant c(TurnBasedMatch turnBasedMatch, String string2) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            if (!participant.getParticipantId().equals(string2)) continue;
            return participant;
        }
        throw new IllegalStateException("Participant " + string2 + " is not in match " + turnBasedMatch.getMatchId());
    }
}

