/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.quest;

import android.os.Parcel;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.MilestoneEntityCreator;

public final class MilestoneEntity
implements SafeParcelable,
Milestone {
    public static final MilestoneEntityCreator CREATOR = new MilestoneEntityCreator();
    private final int BR;
    private final String Xu;
    private final long acO;
    private final long acP;
    private final byte[] acQ;
    private final int mState;
    private final String Wm;

    public MilestoneEntity(Milestone milestone) {
        this.BR = 4;
        this.Xu = milestone.getMilestoneId();
        this.acO = milestone.getCurrentProgress();
        this.acP = milestone.getTargetProgress();
        this.mState = milestone.getState();
        this.Wm = milestone.getEventId();
        byte[] byArray = milestone.getCompletionRewardData();
        if (byArray == null) {
            this.acQ = null;
        } else {
            this.acQ = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.acQ, 0, byArray.length);
        }
    }

    MilestoneEntity(int versionCode, String milestoneId, long currentProgress, long targetProgress, byte[] completionBlob, int state, String eventId) {
        this.BR = versionCode;
        this.Xu = milestoneId;
        this.acO = currentProgress;
        this.acP = targetProgress;
        this.acQ = completionBlob;
        this.mState = state;
        this.Wm = eventId;
    }

    public int getVersionCode() {
        return this.BR;
    }

    @Override
    public String getEventId() {
        return this.Wm;
    }

    @Override
    public String getMilestoneId() {
        return this.Xu;
    }

    @Override
    public long getCurrentProgress() {
        return this.acO;
    }

    @Override
    public long getTargetProgress() {
        return this.acP;
    }

    @Override
    public byte[] getCompletionRewardData() {
        return this.acQ;
    }

    @Override
    public int getState() {
        return this.mState;
    }

    @Override
    public Milestone freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return MilestoneEntity.a(this);
    }

    static int a(Milestone milestone) {
        return n.hashCode(milestone.getMilestoneId(), milestone.getCurrentProgress(), milestone.getTargetProgress(), milestone.getState(), milestone.getEventId());
    }

    public boolean equals(Object obj) {
        return MilestoneEntity.a(this, obj);
    }

    static boolean a(Milestone milestone, Object object) {
        if (!(object instanceof Milestone)) {
            return false;
        }
        if (milestone == object) {
            return true;
        }
        Milestone milestone2 = (Milestone)object;
        return n.equal(milestone2.getMilestoneId(), milestone.getMilestoneId()) && n.equal(milestone2.getCurrentProgress(), milestone.getCurrentProgress()) && n.equal(milestone2.getTargetProgress(), milestone.getTargetProgress()) && n.equal(milestone2.getState(), milestone.getState()) && n.equal(milestone2.getEventId(), milestone.getEventId());
    }

    public String toString() {
        return MilestoneEntity.b(this);
    }

    static String b(Milestone milestone) {
        return n.h(milestone).a("MilestoneId", milestone.getMilestoneId()).a("CurrentProgress", milestone.getCurrentProgress()).a("TargetProgress", milestone.getTargetProgress()).a("State", milestone.getState()).a("CompletionRewardData", milestone.getCompletionRewardData()).a("EventId", milestone.getEventId()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        MilestoneEntityCreator.a(this, out, flags);
    }
}

