/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.os.PowerManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import com.google.android.gms.internal.ac;
import com.google.android.gms.internal.ad;
import com.google.android.gms.internal.ag;
import com.google.android.gms.internal.ah;
import com.google.android.gms.internal.aj;
import com.google.android.gms.internal.ay;
import com.google.android.gms.internal.bx;
import com.google.android.gms.internal.by;
import com.google.android.gms.internal.ez;
import com.google.android.gms.internal.fz;
import com.google.android.gms.internal.gs;
import com.google.android.gms.internal.gt;
import com.google.android.gms.internal.gv;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@ez
public final class af
implements ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    private final Object mw = new Object();
    private final WeakReference<fz> mz;
    private WeakReference<ViewTreeObserver> mA;
    private final WeakReference<View> mB;
    private final ad mC;
    private final Context mD;
    private final ah mE;
    private boolean mF;
    private final WindowManager mG;
    private final PowerManager mH;
    private final KeyguardManager mI;
    private ag mJ;
    private static final long mK = TimeUnit.MILLISECONDS.toNanos(100L);
    private boolean mn = false;
    private boolean mL = false;
    private final BlockingQueue<Runnable> mM = new ArrayBlockingQueue<Runnable>(2);
    private long mN = Long.MIN_VALUE;
    private boolean mO;
    private boolean mP;
    private BroadcastReceiver mQ;
    private final HashSet<ac> mR = new HashSet();

    public af(ay ay2, fz fz2, gt gt2, final View view, ah ah2) {
        this.mz = new WeakReference<fz>(fz2);
        this.mB = new WeakReference<View>(view);
        this.mA = new WeakReference<Object>(null);
        this.mO = true;
        this.mC = new ad(UUID.randomUUID().toString(), gt2, ay2.of, fz2.vp);
        this.mE = ah2;
        this.mG = (WindowManager)view.getContext().getSystemService("window");
        this.mH = (PowerManager)view.getContext().getApplicationContext().getSystemService("power");
        this.mI = (KeyguardManager)view.getContext().getSystemService("keyguard");
        this.mD = view.getContext().getApplicationContext();
        this.a(ah2);
        this.mE.a(new ah.a(){

            @Override
            public void aM() {
                af.this.mF = true;
                af.this.d(view);
                af.this.aD();
            }
        });
        this.b(this.mE);
        try {
            final JSONObject jSONObject = this.e(view);
            this.mM.add(new Runnable(){

                @Override
                public void run() {
                    af.this.a(jSONObject);
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.mM.add(new Runnable(){

            @Override
            public void run() {
                af.this.e(false);
            }
        });
        gs.S("Tracking ad unit: " + this.mC.aC());
    }

    public af(Context context, ay ay2, fz fz2, View view, gt gt2) {
        this(ay2, fz2, gt2, view, new aj(context, gt2));
    }

    public void a(ac ac2) {
        this.mR.add(ac2);
    }

    protected void d(View view) {
        ArrayList arrayList = new ArrayList();
        this.mM.drainTo(arrayList);
        for (Runnable runnable : arrayList) {
            runnable.run();
        }
    }

    protected void d(boolean bl2) {
        for (ac ac2 : this.mR) {
            ac2.a(this, bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void aD() {
        Object object = this.mw;
        synchronized (object) {
            if (this.mQ != null) {
                return;
            }
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.SCREEN_ON");
            intentFilter.addAction("android.intent.action.SCREEN_OFF");
            this.mQ = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    af.this.e(false);
                }
            };
            this.mD.registerReceiver(this.mQ, intentFilter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void aE() {
        Object object = this.mw;
        synchronized (object) {
            if (this.mQ != null) {
                this.mD.unregisterReceiver(this.mQ);
                this.mQ = null;
            }
        }
    }

    protected void a(ah ah2) {
        ah2.f("https://googleads.g.doubleclick.net/mads/static/sdk/native/sdk-core-v40.html");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        Object object = this.mw;
        synchronized (object) {
            this.aJ();
            this.aE();
            this.mO = false;
            try {
                this.mE.destroy();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.aG();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aF() {
        Object object = this.mw;
        synchronized (object) {
            if (this.mO) {
                this.mP = true;
                try {
                    JSONObject jSONObject = this.aL();
                    this.a(jSONObject);
                }
                catch (JSONException jSONException) {
                    gs.b("JSON Failure while processing active view data.", jSONException);
                }
                gs.S("Untracking ad unit: " + this.mC.aC());
            }
        }
    }

    protected void a(View view, Map<String, String> map) {
        this.e(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void e(boolean bl2) {
        Object object = this.mw;
        synchronized (object) {
            boolean bl3;
            if (!this.mF || !this.mO) {
                return;
            }
            long l2 = System.nanoTime();
            if (bl2 && this.mN + mK > l2) {
                return;
            }
            this.mN = l2;
            fz fz2 = (fz)this.mz.get();
            View view = (View)this.mB.get();
            boolean bl4 = bl3 = view == null || fz2 == null;
            if (bl3) {
                this.aF();
                return;
            }
            try {
                JSONObject jSONObject = this.e(view);
                this.a(jSONObject);
            }
            catch (JSONException jSONException) {
                gs.a("Active view update failed.", jSONException);
            }
            this.aI();
            this.aG();
        }
    }

    protected void aG() {
        if (this.mJ != null) {
            this.mJ.a(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean aH() {
        Object object = this.mw;
        synchronized (object) {
            return this.mO;
        }
    }

    protected int a(int n2, DisplayMetrics displayMetrics) {
        float f2 = displayMetrics.density;
        return (int)((float)n2 / f2);
    }

    protected void aI() {
        View view = (View)this.mB.get();
        if (view == null) {
            return;
        }
        ViewTreeObserver viewTreeObserver = (ViewTreeObserver)this.mA.get();
        ViewTreeObserver viewTreeObserver2 = view.getViewTreeObserver();
        if (viewTreeObserver2 == viewTreeObserver) {
            return;
        }
        this.mA = new WeakReference<ViewTreeObserver>(viewTreeObserver2);
        viewTreeObserver2.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
        viewTreeObserver2.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    protected boolean a(Map<String, String> map) {
        if (map == null) {
            return false;
        }
        String string2 = map.get("hashCode");
        return !TextUtils.isEmpty((CharSequence)string2) && string2.equals(this.mC.aC());
    }

    protected void b(ah ah2) {
        ah2.a("/updateActiveView", new by(){

            @Override
            public void a(gv gv2, Map<String, String> map) {
                if (!af.this.a(map)) {
                    return;
                }
                af.this.a((View)gv2, map);
            }
        });
        ah2.a("/untrackActiveViewUnit", new by(){

            @Override
            public void a(gv gv2, Map<String, String> map) {
                if (!af.this.a(map)) {
                    return;
                }
                gs.S("Received request to untrack: " + af.this.mC.aC());
                af.this.destroy();
            }
        });
        ah2.a("/visibilityChanged", new by(){

            @Override
            public void a(gv gv2, Map<String, String> map) {
                if (!af.this.a(map)) {
                    return;
                }
                if (!map.containsKey("isVisible")) {
                    return;
                }
                Boolean bl2 = "1".equals(map.get("isVisible")) || "true".equals(map.get("isVisible"));
                af.this.d(bl2);
            }
        });
        ah2.a("/viewabilityChanged", bx.pA);
    }

    protected void aJ() {
        ViewTreeObserver viewTreeObserver = (ViewTreeObserver)this.mA.get();
        if (viewTreeObserver == null || !viewTreeObserver.isAlive()) {
            return;
        }
        viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
        viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    protected JSONObject aK() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("afmaVersion", (Object)this.mC.aA()).put("activeViewJSON", (Object)this.mC.aB()).put("timestamp", TimeUnit.NANOSECONDS.toMillis(System.nanoTime())).put("adFormat", (Object)this.mC.az()).put("hashCode", (Object)this.mC.aC());
        return jSONObject;
    }

    protected void a(JSONObject jSONObject) {
        try {
            JSONArray jSONArray = new JSONArray();
            JSONObject jSONObject2 = new JSONObject();
            jSONArray.put((Object)jSONObject);
            jSONObject2.put("units", (Object)jSONArray);
            this.mE.a("AFMA_updateActiveView", jSONObject2);
        }
        catch (Throwable throwable) {
            gs.b("Skipping active view message.", throwable);
        }
    }

    protected JSONObject e(View view) throws JSONException {
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        view.getLocationOnScreen(nArray);
        view.getLocationInWindow(nArray2);
        JSONObject jSONObject = this.aK();
        DisplayMetrics displayMetrics = view.getContext().getResources().getDisplayMetrics();
        Rect rect = new Rect();
        rect.left = nArray[0];
        rect.top = nArray[1];
        rect.right = rect.left + view.getWidth();
        rect.bottom = rect.top + view.getHeight();
        Rect rect2 = new Rect();
        rect2.right = this.mG.getDefaultDisplay().getWidth();
        rect2.bottom = this.mG.getDefaultDisplay().getHeight();
        Rect rect3 = new Rect();
        boolean bl2 = view.getGlobalVisibleRect(rect3, null);
        Rect rect4 = new Rect();
        boolean bl3 = view.getLocalVisibleRect(rect4);
        jSONObject.put("viewBox", (Object)new JSONObject().put("top", this.a(rect2.top, displayMetrics)).put("bottom", this.a(rect2.bottom, displayMetrics)).put("left", this.a(rect2.left, displayMetrics)).put("right", this.a(rect2.right, displayMetrics))).put("adBox", (Object)new JSONObject().put("top", this.a(rect.top, displayMetrics)).put("bottom", this.a(rect.bottom, displayMetrics)).put("left", this.a(rect.left, displayMetrics)).put("right", this.a(rect.right, displayMetrics))).put("globalVisibleBox", (Object)new JSONObject().put("top", this.a(rect3.top, displayMetrics)).put("bottom", this.a(rect3.bottom, displayMetrics)).put("left", this.a(rect3.left, displayMetrics)).put("right", this.a(rect3.right, displayMetrics))).put("globalVisibleBoxVisible", bl2).put("localVisibleBox", (Object)new JSONObject().put("top", this.a(rect4.top, displayMetrics)).put("bottom", this.a(rect4.bottom, displayMetrics)).put("left", this.a(rect4.left, displayMetrics)).put("right", this.a(rect4.right, displayMetrics))).put("localVisibleBoxVisible", bl3).put("screenDensity", (double)displayMetrics.density).put("isVisible", this.f(view)).put("isStopped", this.mL).put("isPaused", this.mn);
        return jSONObject;
    }

    protected boolean f(View view) {
        return view.getVisibility() == 0 && view.isShown() && this.mH.isScreenOn() && !this.mI.inKeyguardRestrictedInputMode();
    }

    protected JSONObject aL() throws JSONException {
        JSONObject jSONObject = this.aK();
        jSONObject.put("doneReasonCode", (Object)"u");
        return jSONObject;
    }

    public void onScrollChanged() {
        this.e(true);
    }

    public void onGlobalLayout() {
        this.e(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(ag ag2) {
        Object object = this.mw;
        synchronized (object) {
            this.mJ = ag2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.mw;
        synchronized (object) {
            this.mL = true;
            this.e(false);
            this.mE.pause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Object object = this.mw;
        synchronized (object) {
            this.mn = true;
            this.e(false);
            this.mE.pause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.mw;
        synchronized (object) {
            this.mE.resume();
            this.mn = false;
            this.e(false);
        }
    }
}

