/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.MutableContextWrapper;
import android.net.Uri;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.MotionEvent;
import android.view.View;
import android.view.WindowManager;
import android.webkit.DownloadListener;
import android.webkit.ValueCallback;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.google.android.gms.internal.ay;
import com.google.android.gms.internal.dk;
import com.google.android.gms.internal.ez;
import com.google.android.gms.internal.gj;
import com.google.android.gms.internal.gn;
import com.google.android.gms.internal.gp;
import com.google.android.gms.internal.gs;
import com.google.android.gms.internal.gt;
import com.google.android.gms.internal.gw;
import com.google.android.gms.internal.gx;
import com.google.android.gms.internal.gy;
import com.google.android.gms.internal.gz;
import com.google.android.gms.internal.k;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@ez
public class gv
extends WebView
implements DownloadListener {
    private final gw wH;
    private final a wI;
    private final Object mw = new Object();
    private final k sX;
    private final gt qs;
    private dk wJ;
    private ay qr;
    private boolean wK;
    private boolean wL;
    private boolean wM;
    private boolean wN;
    private final WindowManager mG;

    public static gv a(Context context, ay ay2, boolean bl2, boolean bl3, k k2, gt gt2) {
        a a2 = new a(context);
        return new gv(a2, ay2, bl2, bl3, k2, gt2);
    }

    protected gv(a a2, ay ay2, boolean bl2, boolean bl3, k k2, gt gt2) {
        super((Context)a2);
        this.wI = a2;
        this.qr = ay2;
        this.wK = bl2;
        this.sX = k2;
        this.qs = gt2;
        this.mG = (WindowManager)this.getContext().getSystemService("window");
        this.setBackgroundColor(0);
        WebSettings webSettings = this.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setSavePassword(false);
        webSettings.setSupportMultipleWindows(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        gj.a((Context)a2, gt2.wD, webSettings);
        if (Build.VERSION.SDK_INT >= 17) {
            gp.a(this.getContext(), webSettings);
        } else if (Build.VERSION.SDK_INT >= 11) {
            gn.a(this.getContext(), webSettings);
        }
        this.setDownloadListener(this);
        this.wH = Build.VERSION.SDK_INT >= 11 ? new gy(this, bl3) : new gw(this, bl3);
        this.setWebViewClient(this.wH);
        if (Build.VERSION.SDK_INT >= 14) {
            this.setWebChromeClient(new gz(this));
        } else if (Build.VERSION.SDK_INT >= 11) {
            this.setWebChromeClient(new gx(this));
        }
        this.dA();
    }

    public void bS() {
        if (!this.du().dE()) {
            return;
        }
        DisplayMetrics displayMetrics = new DisplayMetrics();
        Display display = this.mG.getDefaultDisplay();
        display.getMetrics(displayMetrics);
        int n2 = gj.s(this.getContext());
        float f2 = 160.0f / (float)displayMetrics.densityDpi;
        int n3 = Math.round((float)displayMetrics.widthPixels * f2);
        int n4 = Math.round((float)(displayMetrics.heightPixels - n2) * f2);
        try {
            JSONObject jSONObject = new JSONObject().put("width", n3).put("height", n4).put("density", (double)displayMetrics.density).put("rotation", display.getRotation());
            this.b("onScreenInfoChanged", jSONObject);
        }
        catch (JSONException jSONException) {
            gs.b("Error occured while obtaining screen information.", jSONException);
        }
    }

    public void a(String string2, Map<String, ?> map) {
        JSONObject jSONObject;
        try {
            jSONObject = gj.t(map);
        }
        catch (JSONException jSONException) {
            gs.W("Could not convert parameters to JSON.");
            return;
        }
        this.b(string2, jSONObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluateJavascript(String script, ValueCallback<String> resultCallback) {
        Object object = this.mw;
        synchronized (object) {
            if (this.isDestroyed()) {
                gs.W("The webview is destroyed. Ignoring action.");
                if (resultCallback != null) {
                    resultCallback.onReceiveValue(null);
                }
                return;
            }
            super.evaluateJavascript(script, resultCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void X(String string2) {
        Object object = this.mw;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.loadUrl(string2);
            } else {
                gs.W("The webview is destroyed. Ignoring action.");
            }
        }
    }

    public void a(String string2, JSONObject jSONObject) {
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string3 = jSONObject.toString();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("javascript:" + string2 + "(");
        stringBuilder.append(string3);
        stringBuilder.append(");");
        this.X(stringBuilder.toString());
    }

    public void b(String string2, JSONObject jSONObject) {
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string3 = jSONObject.toString();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("javascript:AFMA_ReceiveMessage('");
        stringBuilder.append(string2);
        stringBuilder.append("'");
        stringBuilder.append(",");
        stringBuilder.append(string3);
        stringBuilder.append(");");
        gs.V("Dispatching AFMA event: " + stringBuilder);
        this.X(stringBuilder.toString());
    }

    public void ca() {
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.qs.wD);
        this.a("onhide", hashMap);
    }

    public void bZ() {
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.qs.wD);
        this.a("onshow", hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public dk dt() {
        Object object = this.mw;
        synchronized (object) {
            return this.wJ;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ay Y() {
        Object object = this.mw;
        synchronized (object) {
            return this.qr;
        }
    }

    public gw du() {
        return this.wH;
    }

    public boolean dv() {
        return this.wN;
    }

    public k dw() {
        return this.sX;
    }

    public gt dx() {
        return this.qs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dy() {
        Object object = this.mw;
        synchronized (object) {
            return this.wK;
        }
    }

    public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimeType, long size) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setDataAndType(Uri.parse((String)url), mimeType);
            this.getContext().startActivity(intent);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            gs.S("Couldn't find an Activity to view url/mimetype: " + url + " / " + mimeType);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.sX != null) {
            this.sX.a(event);
        }
        return super.onTouchEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Object object = this.mw;
        synchronized (object) {
            if (this.isInEditMode() || this.wK) {
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
                return;
            }
            int n2 = View.MeasureSpec.getMode((int)widthMeasureSpec);
            int n3 = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int n4 = View.MeasureSpec.getMode((int)heightMeasureSpec);
            int n5 = View.MeasureSpec.getSize((int)heightMeasureSpec);
            int n6 = Integer.MAX_VALUE;
            if (n2 == Integer.MIN_VALUE || n2 == 0x40000000) {
                n6 = n3;
            }
            int n7 = Integer.MAX_VALUE;
            if (n4 == Integer.MIN_VALUE || n4 == 0x40000000) {
                n7 = n5;
            }
            if (this.qr.widthPixels > n6 || this.qr.heightPixels > n7) {
                float f2 = this.wI.getResources().getDisplayMetrics().density;
                gs.W("Not enough space to show ad. Needs " + (int)((float)this.qr.widthPixels / f2) + "x" + (int)((float)this.qr.heightPixels / f2) + " dp, but only has " + (int)((float)n3 / f2) + "x" + (int)((float)n5 / f2) + " dp.");
                if (this.getVisibility() != 8) {
                    this.setVisibility(4);
                }
                this.setMeasuredDimension(0, 0);
            } else {
                if (this.getVisibility() != 8) {
                    this.setVisibility(0);
                }
                this.setMeasuredDimension(this.qr.widthPixels, this.qr.heightPixels);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(Context context, ay ay2) {
        Object object = this.mw;
        synchronized (object) {
            this.wI.setBaseContext(context);
            this.wJ = null;
            this.qr = ay2;
            this.wK = false;
            this.wN = false;
            gj.b(this);
            this.loadUrl("about:blank");
            this.wH.reset();
            this.setOnTouchListener(null);
            this.setOnClickListener(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(dk dk2) {
        Object object = this.mw;
        synchronized (object) {
            this.wJ = dk2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(ay ay2) {
        Object object = this.mw;
        synchronized (object) {
            this.qr = ay2;
            this.requestLayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void x(boolean bl2) {
        Object object = this.mw;
        synchronized (object) {
            this.wK = bl2;
            this.dA();
        }
    }

    public void setContext(Context context) {
        this.wI.setBaseContext(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void o(boolean bl2) {
        Object object = this.mw;
        synchronized (object) {
            if (this.wJ != null) {
                this.wJ.o(bl2);
            } else {
                this.wN = bl2;
            }
        }
    }

    public Context dz() {
        return this.wI.dz();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dA() {
        Object object = this.mw;
        synchronized (object) {
            if (this.wK || this.qr.og) {
                if (Build.VERSION.SDK_INT < 14) {
                    gs.S("Disabling hardware acceleration on an overlay.");
                    this.dB();
                } else {
                    gs.S("Enabling hardware acceleration on an overlay.");
                    this.dC();
                }
            } else if (Build.VERSION.SDK_INT < 18) {
                gs.S("Disabling hardware acceleration on an AdView.");
                this.dB();
            } else {
                gs.S("Enabling hardware acceleration on an AdView.");
                this.dC();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dB() {
        Object object = this.mw;
        synchronized (object) {
            if (!this.wL && Build.VERSION.SDK_INT >= 11) {
                gn.i((View)this);
            }
            this.wL = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dC() {
        Object object = this.mw;
        synchronized (object) {
            if (this.wL && Build.VERSION.SDK_INT >= 11) {
                gn.j((View)this);
            }
            this.wL = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.mw;
        synchronized (object) {
            super.destroy();
            this.wM = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDestroyed() {
        Object object = this.mw;
        synchronized (object) {
            return this.wM;
        }
    }

    @ez
    protected static class a
    extends MutableContextWrapper {
        private Activity wO;
        private Context mD;

        public a(Context context) {
            super(context);
            this.setBaseContext(context);
        }

        public void setBaseContext(Context base) {
            this.mD = base.getApplicationContext();
            this.wO = base instanceof Activity ? (Activity)base : null;
            super.setBaseContext(this.mD);
        }

        public void startActivity(Intent intent) {
            if (this.wO != null) {
                this.wO.startActivity(intent);
            } else {
                intent.setFlags(0x10000000);
                this.mD.startActivity(intent);
            }
        }

        public Context dz() {
            return this.wO;
        }
    }
}

