/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.net.Uri;
import android.util.Log;
import com.google.android.gms.internal.pc;
import com.google.android.gms.internal.pn;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.DataMap;
import com.google.android.gms.wearable.DataMapItem;
import com.google.android.gms.wearable.PutDataRequest;

public class PutDataMapRequest {
    private final PutDataRequest auY;
    private final DataMap auX;

    private PutDataMapRequest(PutDataRequest putDataRequest, DataMap dataMap) {
        this.auY = putDataRequest;
        this.auX = new DataMap();
        if (dataMap != null) {
            this.auX.putAll(dataMap);
        }
    }

    public static PutDataMapRequest createFromDataMapItem(DataMapItem source) {
        return new PutDataMapRequest(PutDataRequest.k(source.getUri()), source.getDataMap());
    }

    public static PutDataMapRequest createWithAutoAppendedId(String pathPrefix) {
        return new PutDataMapRequest(PutDataRequest.createWithAutoAppendedId(pathPrefix), null);
    }

    public static PutDataMapRequest create(String path) {
        return new PutDataMapRequest(PutDataRequest.create(path), null);
    }

    public Uri getUri() {
        return this.auY.getUri();
    }

    public DataMap getDataMap() {
        return this.auX;
    }

    public PutDataRequest asPutDataRequest() {
        pc.a a2 = pc.a(this.auX);
        this.auY.setData(pn.f(a2.awb));
        int n2 = a2.awc.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = Integer.toString(i2);
            Asset asset = a2.awc.get(i2);
            if (string2 == null) {
                throw new IllegalStateException("asset key cannot be null: " + asset);
            }
            if (asset == null) {
                throw new IllegalStateException("asset cannot be null: key=" + string2);
            }
            if (Log.isLoggable((String)"DataMap", (int)3)) {
                Log.d((String)"DataMap", (String)("asPutDataRequest: adding asset: " + string2 + " " + asset));
            }
            this.auY.putAsset(string2, asset);
        }
        return this.auY;
    }
}

